/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates.model;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class SchemaData {
    final String name;
    final String shortName;
    final String doc;
    final Schema.Type type;
    final List<FieldData> fields;
    final String displayType;
    final boolean required;
    final Object defaultValue;

    private SchemaData(Schema schema) {
        int i;
        this.name = schema.name();
        this.shortName = Strings.isNullOrEmpty((String)this.name) ? this.name : ((i = this.name.lastIndexOf(".")) > 0 ? this.name.substring(i + 1) : this.name);
        this.doc = Strings.isNullOrEmpty((String)schema.doc()) ? "" : schema.doc();
        this.type = schema.type();
        this.required = !schema.isOptional();
        this.defaultValue = schema.defaultValue();
        ArrayList<FieldData> fields = new ArrayList<FieldData>();
        if (Schema.Type.STRUCT == this.type) {
            for (Field field : schema.fields()) {
                fields.add(new FieldData(field.name(), field.schema()));
            }
        }
        this.fields = ImmutableList.copyOf(fields);
        this.displayType = this.type(schema);
    }

    public static SchemaData of(Schema schema) {
        return new SchemaData(schema);
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDoc() {
        return this.doc;
    }

    public Schema.Type getType() {
        return this.type;
    }

    public List<FieldData> getFields() {
        return this.fields;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public boolean getRequired() {
        return this.required;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    String type(Schema schema) {
        String result;
        switch (schema.type()) {
            case ARRAY: {
                result = String.format("Array of %s", this.type(schema.valueSchema()));
                break;
            }
            case MAP: {
                result = String.format("Map of %s, %s", this.type(schema.keySchema()), this.type(schema.valueSchema()));
                break;
            }
            default: {
                result = String.format(":ref:`schema-%s`", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, schema.type().toString()));
            }
        }
        return result;
    }

    public static class FieldData {
        public final String name;
        public final SchemaData schema;

        public FieldData(String name, Schema schema) {
            this.name = name;
            this.schema = SchemaData.of(schema);
        }

        public String getName() {
            return this.name;
        }

        public SchemaData getSchema() {
            return this.schema;
        }
    }
}

