/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates.model;

import com.github.jcustenborder.kafka.connect.utils.config.AnnotationHelper;
import com.github.jcustenborder.kafka.connect.utils.docs.Example;
import com.github.jcustenborder.kafka.connect.utils.templates.model.Configuration;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.transforms.Transformation;

public class Configurable {
    private final String title;
    private final String description;
    private final String className;
    private final String warning;
    private final String tip;
    private final String important;
    private final String danger;
    private final String note;
    private final String simpleName;
    private final String diagramFileName;
    private final Configuration config;
    private final Class<?> cls;
    List<Example> examples;
    private final List<String> resourceFilters;

    public Configurable(Class<?> cls) {
        ConfigDef configDef;
        ArrayList<String> resourceFilters;
        block6: {
            this.cls = cls;
            this.title = AnnotationHelper.title(cls);
            this.description = AnnotationHelper.description(cls);
            this.className = cls.getName();
            this.simpleName = cls.getSimpleName();
            this.diagramFileName = this.simpleName + ".svg";
            this.warning = AnnotationHelper.warning(cls);
            this.tip = AnnotationHelper.tip(cls);
            this.important = AnnotationHelper.important(cls);
            this.danger = AnnotationHelper.danger(cls);
            this.note = AnnotationHelper.note(cls);
            resourceFilters = new ArrayList<String>();
            try {
                if (Connector.class.isAssignableFrom(cls)) {
                    Connector connector = (Connector)cls.newInstance();
                    resourceFilters.add(cls.getName().replace('.', '/') + "/");
                    configDef = connector.config();
                    break block6;
                }
                if (Transformation.class.isAssignableFrom(cls)) {
                    if ("Key".equalsIgnoreCase(cls.getSimpleName()) || "Value".equalsIgnoreCase(cls.getSimpleName())) {
                        resourceFilters.add(cls.getSuperclass().getName().replace('.', '/') + "/");
                    } else {
                        resourceFilters.add(cls.getName().replace('.', '/') + "/");
                    }
                    Transformation transformation = (Transformation)cls.newInstance();
                    configDef = transformation.config();
                    break block6;
                }
                throw new UnsupportedOperationException(String.format("Class %s is not supported", cls.getName()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
        this.resourceFilters = ImmutableList.copyOf(resourceFilters);
        this.config = Configuration.from(configDef);
    }

    public List<Example> getExamples() {
        return this.examples;
    }

    public void setExamples(List<Example> examples) {
        this.examples = examples;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassName() {
        return this.className;
    }

    Predicate<String> resourceFilter() {
        return s -> {
            for (String filter : this.resourceFilters) {
                if (!s.startsWith(filter)) continue;
                return true;
            }
            return false;
        };
    }

    public String getResourceFilter() {
        return this.className.replace('.', '/') + "/";
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getTip() {
        return this.tip;
    }

    public String getNote() {
        return this.note;
    }

    public String getImportant() {
        return this.important;
    }

    public String getDanger() {
        return this.danger;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getDiagramFileName() {
        return this.diagramFileName;
    }
}

