/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates.model;

import com.github.jcustenborder.kafka.connect.utils.config.Description;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationDanger;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationImportant;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationNote;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationTip;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationWarning;
import com.github.jcustenborder.kafka.connect.utils.config.Title;
import com.github.jcustenborder.kafka.connect.utils.templates.model.Configuration;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.transforms.Transformation;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Input {
    private static final Logger log = LoggerFactory.getLogger(Input.class);
    private String title;
    private String description;
    private String className;
    private String warning;
    private String tip;
    private String important;
    private String danger;
    private String note;
    private Configuration config;

    private static String title(Class<?> aClass) {
        Title annotation = aClass.getAnnotation(Title.class);
        String result = null != annotation ? annotation.value() : aClass.getSimpleName();
        return result;
    }

    private static String description(Class<?> aClass) {
        Description annotation = aClass.getAnnotation(Description.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String danger(Class<?> aClass) {
        DocumentationDanger annotation = aClass.getAnnotation(DocumentationDanger.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String important(Class<?> aClass) {
        DocumentationImportant annotation = aClass.getAnnotation(DocumentationImportant.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String tip(Class<?> aClass) {
        DocumentationTip annotation = aClass.getAnnotation(DocumentationTip.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String note(Class<?> aClass) {
        DocumentationNote annotation = aClass.getAnnotation(DocumentationNote.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String warning(Class<?> aClass) {
        DocumentationWarning annotation = aClass.getAnnotation(DocumentationWarning.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static void populateTemplate(Class<?> aClass, Input result, ConfigDef config) {
        result.className = aClass.getName();
        result.title = Input.title(aClass);
        result.description = Input.description(aClass);
        result.tip = Input.tip(aClass);
        result.warning = Input.warning(aClass);
        result.important = Input.important(aClass);
        result.danger = Input.danger(aClass);
        result.config = Configuration.from(config);
    }

    public static Input fromTransformation(Class<? extends Transformation> transform) throws IllegalAccessException, InstantiationException {
        Input result = new Input();
        Transformation sourceConnector = transform.newInstance();
        ConfigDef config = sourceConnector.config();
        Assertions.assertNotNull((Object)config, (String)"config() cannot return a null.");
        Input.populateTemplate(transform, result, config);
        return result;
    }

    public static Input fromConnector(Class<? extends Connector> connectorClass) throws IllegalAccessException, InstantiationException {
        Input result = new Input();
        Connector connector = connectorClass.newInstance();
        ConfigDef config = connector.config();
        Assertions.assertNotNull((Object)config, (String)"config() cannot return a null.");
        Input.populateTemplate(connectorClass, result, config);
        return result;
    }

    public static void checkLength(Map<String, Integer> columnLengths, String name, Object value) {
        int current;
        int length = (value != null ? value.toString().length() : 0) + 2;
        if (length > (current = columnLengths.getOrDefault(name, 0).intValue())) {
            columnLengths.put(name, length);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassName() {
        return this.className;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getTip() {
        return this.tip;
    }

    public String getNote() {
        return this.note;
    }

    public String getImportant() {
        return this.important;
    }

    public String getDanger() {
        return this.danger;
    }

    public Configuration getConfig() {
        return this.config;
    }
}

