/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.github.jcustenborder.kafka.connect.utils.config.Description;
import com.github.jcustenborder.kafka.connect.utils.config.MarkdownFormatter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.transforms.Transformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDocumentationTest {
    private static final Logger log = LoggerFactory.getLogger(BaseDocumentationTest.class);
    Reflections reflections;

    protected List<Schema> schemas() {
        return Arrays.asList(new Schema[0]);
    }

    protected abstract String[] packages();

    @BeforeEach
    public void before() throws MalformedURLException {
        log.info("before() - Configuring reflections to use package '{}'", (Object[])this.packages());
        this.reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()).forPackages(this.packages()));
    }

    protected List<Map.Entry<String, ConfigDef.ConfigKey>> required(ConfigDef configDef) {
        ArrayList entries = new ArrayList();
        for (Map.Entry kvp : configDef.configKeys().entrySet()) {
            if (((ConfigDef.ConfigKey)kvp.getValue()).hasDefault()) continue;
            entries.add(kvp);
        }
        return ImmutableList.copyOf(entries);
    }

    @Test
    public void markdown() throws IOException, IllegalAccessException, InstantiationException {
        Set transformClasses = this.reflections.getSubTypesOf(Transformation.class);
        ArrayList<Class> transformClassesSorted = new ArrayList<Class>(transformClasses);
        transformClassesSorted.sort(Comparator.comparing(Class::getName));
        Set connectorClasses = this.reflections.getSubTypesOf(Connector.class);
        ArrayList<Class> connectorClassesSorted = new ArrayList<Class>(connectorClasses);
        connectorClassesSorted.sort(Comparator.comparing(Class::getName));
        Assertions.assertFalse((boolean)connectorClassesSorted.isEmpty(), (String)"No connector classes were found.");
        try (StringWriter stringWriter = new StringWriter();){
            try (PrintWriter writer = new PrintWriter(stringWriter);){
                ConfigDef configDef;
                Description descriptionAttribute;
                writer.println();
                writer.println("# Configuration");
                writer.println();
                for (Class connectorClass : connectorClassesSorted) {
                    if (Modifier.isAbstract(connectorClass.getModifiers())) {
                        log.trace("Skipping {} because it's abstract.", (Object)connectorClass.getName());
                        continue;
                    }
                    writer.printf("## %s", connectorClass.getSimpleName());
                    writer.println();
                    descriptionAttribute = connectorClass.getAnnotation(Description.class);
                    if (null != descriptionAttribute && !Strings.isNullOrEmpty((String)descriptionAttribute.value())) {
                        writer.println();
                        writer.append(descriptionAttribute.value());
                        writer.println();
                    }
                    writer.println();
                    Connector connector = (Connector)connectorClass.newInstance();
                    configDef = connector.config();
                    writer.println("```properties");
                    writer.println("name=connector1");
                    writer.println("tasks.max=1");
                    writer.printf("connector.class=%s", connectorClass.getName());
                    writer.println();
                    writer.println();
                    writer.println("# Set these required values");
                    List<Map.Entry<String, ConfigDef.ConfigKey>> requiredValues = this.required(configDef);
                    for (Map.Entry<String, ConfigDef.ConfigKey> kvp : requiredValues) {
                        writer.printf("%s=", kvp.getKey());
                        writer.println();
                    }
                    writer.println("```");
                    writer.println();
                    writer.println(MarkdownFormatter.toMarkdown((ConfigDef)configDef));
                }
                for (Class transformationClass : transformClassesSorted) {
                    if (Modifier.isAbstract(transformationClass.getModifiers())) {
                        log.trace("Skipping {} because it's abstract.", (Object)transformationClass.getName());
                        continue;
                    }
                    writer.printf("## %s", transformationClass.getSimpleName());
                    writer.println();
                    descriptionAttribute = transformationClass.getAnnotation(Description.class);
                    if (null != descriptionAttribute && !Strings.isNullOrEmpty((String)descriptionAttribute.value())) {
                        writer.println();
                        writer.append(descriptionAttribute.value());
                        writer.println();
                    }
                    writer.println();
                    Transformation transformation = (Transformation)transformationClass.newInstance();
                    configDef = transformation.config();
                    writer.println("```properties");
                    String transformName = transformationClass.getSimpleName().toLowerCase();
                    writer.printf("transforms=%s", transformName);
                    writer.println();
                    writer.printf("transforms.%s.type=%s", transformName, transformationClass.getName());
                    writer.println();
                    writer.println();
                    writer.println("# Set these required values");
                    List<Map.Entry<String, ConfigDef.ConfigKey>> requiredValues = this.required(configDef);
                    for (Map.Entry<String, ConfigDef.ConfigKey> kvp : requiredValues) {
                        writer.printf("transforms.%s.%s=", transformName, kvp.getKey());
                        writer.println();
                    }
                    writer.println("```");
                    writer.println();
                }
                List<Schema> schemas = this.schemas();
                if (!schemas.isEmpty()) {
                    writer.println();
                    writer.println("# Schemas");
                    writer.println();
                    for (Schema schema : this.schemas()) {
                        writer.println(MarkdownFormatter.toMarkdown((Schema)schema));
                    }
                }
            }
            log.info("{}", (Object)stringWriter);
        }
    }
}

