/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.google.common.base.Strings;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;

public class GenericAssertions {
    private GenericAssertions() {
    }

    static void assertMap(Map<String, ?> expected, Map<String, ?> actual, String message) {
        if (null == expected && null == actual) {
            return;
        }
        String prefix = Strings.isNullOrEmpty((String)message) ? "" : message + ": ";
        Assertions.assertNotNull(expected, (String)(prefix + "expected cannot be null"));
        Assertions.assertNotNull(actual, (String)(prefix + "actual cannot be null"));
        MapDifference mapDifference = Maps.difference(expected, actual);
        Assertions.assertTrue((boolean)mapDifference.areEqual(), (Supplier)new MapDifferenceSupplier(mapDifference, prefix));
    }

    static class MapDifferenceSupplier
    implements Supplier<String> {
        final MapDifference<?, ?> mapDifference;
        final String method;

        public MapDifferenceSupplier(MapDifference<?, ?> mapDifference, String method) {
            this.mapDifference = mapDifference;
            this.method = method;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String get() {
            try (StringWriter w = new StringWriter();){
                try (BufferedWriter writer = new BufferedWriter(w);){
                    writer.append(String.format("Map for actual.%s() does not match expected.%s().", this.method, this.method));
                    writer.newLine();
                    Map differences = this.mapDifference.entriesDiffering();
                    if (!differences.isEmpty()) {
                        writer.append("Keys with Differences");
                        writer.newLine();
                        for (Map.Entry kvp : differences.entrySet()) {
                            writer.append("  ");
                            writer.append(kvp.getKey().toString());
                            writer.newLine();
                            writer.append("    expected:");
                            writer.append(((MapDifference.ValueDifference)kvp.getValue()).leftValue().toString());
                            writer.newLine();
                            writer.append("    actual:");
                            writer.append(((MapDifference.ValueDifference)kvp.getValue()).rightValue().toString());
                            writer.newLine();
                        }
                    }
                    Map entries = this.mapDifference.entriesOnlyOnLeft();
                    this.writeEntries(writer, "Only in expected map", entries);
                    Map onlyInActual = this.mapDifference.entriesOnlyOnRight();
                    this.writeEntries(writer, "Only in actual map", onlyInActual);
                }
                String string = ((Object)w).toString();
                return string;
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private void writeEntries(BufferedWriter writer, String header, Map<?, ?> entries) throws IOException {
            if (!entries.isEmpty()) {
                writer.append(header);
                writer.newLine();
                for (Map.Entry<?, ?> kvp : entries.entrySet()) {
                    writer.append("  ");
                    writer.append(kvp.getKey().toString());
                    writer.append(": ");
                    writer.append(kvp.getValue().toString());
                    writer.newLine();
                }
                writer.newLine();
            }
        }
    }
}

