/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data;

import com.github.jcustenborder.kafka.connect.utils.data.NamedTest;
import com.github.jcustenborder.kafka.connect.utils.jackson.ObjectMapperFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataUtils {
    private static final Logger log = LoggerFactory.getLogger(TestDataUtils.class);
    static Random random = new SecureRandom();

    public static BigDecimal randomBigDecimal(int scale) {
        long longValue = random.nextLong();
        return BigDecimal.valueOf(longValue, scale);
    }

    public static <T extends NamedTest> List<T> loadJsonResourceFiles(String packageName, Class<T> cls) throws IOException {
        Preconditions.checkNotNull((Object)packageName, (Object)"packageName cannot be null");
        Reflections reflections = new Reflections(packageName, new Scanner[]{new ResourcesScanner()});
        Set resources = reflections.getResources((Predicate)new FilterBuilder.Include(".*"));
        ArrayList<NamedTest> datas = new ArrayList<NamedTest>(resources.size());
        Path packagePath = Paths.get("/" + packageName.replace(".", "/"), new String[0]);
        for (String resource : resources) {
            NamedTest data;
            log.trace("Loading resource {}", (Object)resource);
            Path resourcePath = Paths.get("/" + resource, new String[0]);
            Path relativePath = packagePath.relativize(resourcePath);
            File resourceFile = new File("/" + resource);
            try (InputStream inputStream = cls.getResourceAsStream(resourceFile.getAbsolutePath());){
                data = (NamedTest)ObjectMapperFactory.INSTANCE.readValue(inputStream, cls);
            }
            catch (IOException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Exception thrown while loading {}", (Object)resourcePath, (Object)ex);
                }
                throw ex;
            }
            String nameWithoutExtension = Files.getNameWithoutExtension((String)resource);
            if (null != relativePath.getParent()) {
                String parentName = relativePath.getParent().getFileName().toString();
                data.testName(parentName + "/" + nameWithoutExtension);
            } else {
                data.testName(nameWithoutExtension);
            }
            datas.add(data);
        }
        return datas;
    }
}

