/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.types.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDefSerializationModule
extends SimpleModule {
    private static final Logger log = LoggerFactory.getLogger(ConfigDefSerializationModule.class);

    public ConfigDefSerializationModule() {
        this.addSerializer(Password.class, new Serializer());
        this.addDeserializer(Password.class, new Deserializer());
        this.addSerializer(ConfigDef.Validator.class, (JsonSerializer)new JsonSerializer<ConfigDef.Validator>(){

            public void serialize(ConfigDef.Validator validator, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(validator.toString());
            }
        });
    }

    static class Deserializer
    extends JsonDeserializer<Password> {
        Deserializer() {
        }

        public Password deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String text = (String)jsonParser.readValueAs(String.class);
            return new Password(text);
        }
    }

    static class Serializer
    extends JsonSerializer<Password> {
        Serializer() {
        }

        public void serialize(Password password, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeString(password.toString());
        }
    }
}

