/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.transport;

import android.util.Log;
import com.fsck.k9.mail.Address;
import com.fsck.k9.mail.AuthType;
import com.fsck.k9.mail.Authentication;
import com.fsck.k9.mail.AuthenticationFailedException;
import com.fsck.k9.mail.CertificateValidationException;
import com.fsck.k9.mail.ConnectionSecurity;
import com.fsck.k9.mail.K9MailLib;
import com.fsck.k9.mail.Message;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.ServerSettings;
import com.fsck.k9.mail.Transport;
import com.fsck.k9.mail.filter.Base64;
import com.fsck.k9.mail.filter.EOLConvertingOutputStream;
import com.fsck.k9.mail.filter.LineWrapOutputStream;
import com.fsck.k9.mail.filter.PeekableInputStream;
import com.fsck.k9.mail.filter.SmtpDataStuffing;
import com.fsck.k9.mail.internet.CharsetSupport;
import com.fsck.k9.mail.ssl.TrustedSocketFactory;
import com.fsck.k9.mail.store.StoreConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLException;

public class SmtpTransport
extends Transport {
    private TrustedSocketFactory mTrustedSocketFactory;
    private String mHost;
    private int mPort;
    private String mUsername;
    private String mPassword;
    private String mClientCertificateAlias;
    private AuthType mAuthType;
    private ConnectionSecurity mConnectionSecurity;
    private Socket mSocket;
    private PeekableInputStream mIn;
    private OutputStream mOut;
    private boolean m8bitEncodingAllowed;
    private int mLargestAcceptableMessage;

    public static ServerSettings decodeUri(String uri) {
        int port;
        ConnectionSecurity connectionSecurity;
        URI smtpUri;
        AuthType authType = null;
        String username = null;
        String password = null;
        String clientCertificateAlias = null;
        try {
            smtpUri = new URI(uri);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Invalid SmtpTransport URI", use);
        }
        String scheme = smtpUri.getScheme();
        if (scheme.equals("smtp")) {
            connectionSecurity = ConnectionSecurity.NONE;
            port = ServerSettings.Type.SMTP.defaultPort;
        } else if (scheme.startsWith("smtp+tls")) {
            connectionSecurity = ConnectionSecurity.STARTTLS_REQUIRED;
            port = ServerSettings.Type.SMTP.defaultPort;
        } else if (scheme.startsWith("smtp+ssl")) {
            connectionSecurity = ConnectionSecurity.SSL_TLS_REQUIRED;
            port = ServerSettings.Type.SMTP.defaultTlsPort;
        } else {
            throw new IllegalArgumentException("Unsupported protocol (" + scheme + ")");
        }
        String host = smtpUri.getHost();
        if (smtpUri.getPort() != -1) {
            port = smtpUri.getPort();
        }
        if (smtpUri.getUserInfo() != null) {
            String[] userInfoParts = smtpUri.getUserInfo().split(":");
            if (userInfoParts.length == 1) {
                authType = AuthType.PLAIN;
                username = SmtpTransport.decodeUtf8(userInfoParts[0]);
            } else if (userInfoParts.length == 2) {
                authType = AuthType.PLAIN;
                username = SmtpTransport.decodeUtf8(userInfoParts[0]);
                password = SmtpTransport.decodeUtf8(userInfoParts[1]);
            } else if (userInfoParts.length == 3) {
                authType = AuthType.valueOf(userInfoParts[2]);
                username = SmtpTransport.decodeUtf8(userInfoParts[0]);
                if (authType == AuthType.EXTERNAL) {
                    clientCertificateAlias = SmtpTransport.decodeUtf8(userInfoParts[1]);
                } else {
                    password = SmtpTransport.decodeUtf8(userInfoParts[1]);
                }
            }
        }
        return new ServerSettings(ServerSettings.Type.SMTP, host, port, connectionSecurity, authType, username, password, clientCertificateAlias);
    }

    public static String createUri(ServerSettings server) {
        String scheme;
        String userEnc = server.username != null ? SmtpTransport.encodeUtf8(server.username) : "";
        String passwordEnc = server.password != null ? SmtpTransport.encodeUtf8(server.password) : "";
        String clientCertificateAliasEnc = server.clientCertificateAlias != null ? SmtpTransport.encodeUtf8(server.clientCertificateAlias) : "";
        switch (server.connectionSecurity) {
            case SSL_TLS_REQUIRED: {
                scheme = "smtp+ssl+";
                break;
            }
            case STARTTLS_REQUIRED: {
                scheme = "smtp+tls+";
                break;
            }
            default: {
                scheme = "smtp";
            }
        }
        AuthType authType = server.authenticationType;
        String userInfo = authType != null ? (AuthType.EXTERNAL == authType ? userEnc + ":" + clientCertificateAliasEnc + ":" + authType.name() : userEnc + ":" + passwordEnc + ":" + authType.name()) : userEnc + ":" + passwordEnc;
        try {
            return new URI(scheme, userInfo, server.host, server.port, null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Can't create SmtpTransport URI", e);
        }
    }

    public SmtpTransport(StoreConfig storeConfig, TrustedSocketFactory trustedSocketFactory) throws MessagingException {
        ServerSettings settings;
        try {
            settings = SmtpTransport.decodeUri(storeConfig.getTransportUri());
        }
        catch (IllegalArgumentException e) {
            throw new MessagingException("Error while decoding transport URI", e);
        }
        this.mHost = settings.host;
        this.mPort = settings.port;
        this.mConnectionSecurity = settings.connectionSecurity;
        this.mAuthType = settings.authenticationType;
        this.mUsername = settings.username;
        this.mPassword = settings.password;
        this.mClientCertificateAlias = settings.clientCertificateAlias;
        this.mTrustedSocketFactory = trustedSocketFactory;
    }

    @Override
    public void open() throws MessagingException {
        try {
            boolean secureConnection = false;
            InetAddress[] addresses = InetAddress.getAllByName(this.mHost);
            for (int i = 0; i < addresses.length; ++i) {
                try {
                    InetSocketAddress socketAddress = new InetSocketAddress(addresses[i], this.mPort);
                    if (this.mConnectionSecurity == ConnectionSecurity.SSL_TLS_REQUIRED) {
                        this.mSocket = this.mTrustedSocketFactory.createSocket(null, this.mHost, this.mPort, this.mClientCertificateAlias);
                        this.mSocket.connect(socketAddress, 10000);
                        secureConnection = true;
                        break;
                    }
                    this.mSocket = new Socket();
                    this.mSocket.connect(socketAddress, 10000);
                    break;
                }
                catch (SocketException e) {
                    if (i < addresses.length - 1) continue;
                    throw new MessagingException("Cannot connect to host", e);
                }
            }
            this.mSocket.setSoTimeout(300000);
            this.mIn = new PeekableInputStream(new BufferedInputStream(this.mSocket.getInputStream(), 1024));
            this.mOut = new BufferedOutputStream(this.mSocket.getOutputStream(), 1024);
            this.executeSimpleCommand(null);
            InetAddress localAddress = this.mSocket.getLocalAddress();
            String localHost = this.getCanonicalHostName(localAddress);
            String ipAddr = localAddress.getHostAddress();
            if (localHost.equals("") || localHost.equals(ipAddr) || localHost.contains("_")) {
                localHost = !ipAddr.equals("") ? (localAddress instanceof Inet6Address ? "[IPv6:" + ipAddr + "]" : "[" + ipAddr + "]") : "android";
            }
            Map<String, String> extensions = this.sendHello(localHost);
            this.m8bitEncodingAllowed = extensions.containsKey("8BITMIME");
            if (this.mConnectionSecurity == ConnectionSecurity.STARTTLS_REQUIRED) {
                if (extensions.containsKey("STARTTLS")) {
                    this.executeSimpleCommand("STARTTLS");
                    this.mSocket = this.mTrustedSocketFactory.createSocket(this.mSocket, this.mHost, this.mPort, this.mClientCertificateAlias);
                    this.mIn = new PeekableInputStream(new BufferedInputStream(this.mSocket.getInputStream(), 1024));
                    this.mOut = new BufferedOutputStream(this.mSocket.getOutputStream(), 1024);
                    extensions = this.sendHello(localHost);
                    secureConnection = true;
                } else {
                    throw new CertificateValidationException("STARTTLS connection security not available");
                }
            }
            boolean authLoginSupported = false;
            boolean authPlainSupported = false;
            boolean authCramMD5Supported = false;
            boolean authExternalSupported = false;
            if (extensions.containsKey("AUTH")) {
                List<String> saslMech = Arrays.asList(extensions.get("AUTH").split(" "));
                authLoginSupported = saslMech.contains("LOGIN");
                authPlainSupported = saslMech.contains("PLAIN");
                authCramMD5Supported = saslMech.contains("CRAM-MD5");
                authExternalSupported = saslMech.contains("EXTERNAL");
            }
            this.parseOptionalSizeValue(extensions);
            if (this.mUsername != null && this.mUsername.length() > 0 && (this.mPassword != null && this.mPassword.length() > 0 || AuthType.EXTERNAL == this.mAuthType)) {
                switch (this.mAuthType) {
                    case LOGIN: 
                    case PLAIN: {
                        if (authPlainSupported) {
                            this.saslAuthPlain(this.mUsername, this.mPassword);
                            break;
                        }
                        if (authLoginSupported) {
                            this.saslAuthLogin(this.mUsername, this.mPassword);
                            break;
                        }
                        throw new MessagingException("Authentication methods SASL PLAIN and LOGIN are unavailable.");
                    }
                    case CRAM_MD5: {
                        if (authCramMD5Supported) {
                            this.saslAuthCramMD5(this.mUsername, this.mPassword);
                            break;
                        }
                        throw new MessagingException("Authentication method CRAM-MD5 is unavailable.");
                    }
                    case EXTERNAL: {
                        if (authExternalSupported) {
                            this.saslAuthExternal(this.mUsername);
                            break;
                        }
                        throw new CertificateValidationException(CertificateValidationException.Reason.MissingCapability);
                    }
                    case AUTOMATIC: {
                        if (secureConnection) {
                            if (authPlainSupported) {
                                this.saslAuthPlain(this.mUsername, this.mPassword);
                                break;
                            }
                            if (authLoginSupported) {
                                this.saslAuthLogin(this.mUsername, this.mPassword);
                                break;
                            }
                            if (authCramMD5Supported) {
                                this.saslAuthCramMD5(this.mUsername, this.mPassword);
                                break;
                            }
                            throw new MessagingException("No supported authentication methods available.");
                        }
                        if (authCramMD5Supported) {
                            this.saslAuthCramMD5(this.mUsername, this.mPassword);
                            break;
                        }
                        throw new MessagingException("Update your outgoing server authentication setting. AUTOMATIC auth. is unavailable.");
                    }
                    default: {
                        throw new MessagingException("Unhandled authentication method found in the server settings (bug).");
                    }
                }
            }
        }
        catch (SSLException e) {
            throw new CertificateValidationException(e.getMessage(), e);
        }
        catch (GeneralSecurityException gse) {
            throw new MessagingException("Unable to open connection to SMTP server due to security error.", gse);
        }
        catch (IOException ioe) {
            throw new MessagingException("Unable to open connection to SMTP server.", ioe);
        }
    }

    private void parseOptionalSizeValue(Map<String, String> extensions) {
        block3: {
            String optionalsizeValue;
            if (extensions.containsKey("SIZE") && (optionalsizeValue = extensions.get("SIZE")) != null && optionalsizeValue != "") {
                try {
                    this.mLargestAcceptableMessage = Integer.parseInt(optionalsizeValue);
                }
                catch (NumberFormatException e) {
                    if (!K9MailLib.isDebug() || !K9MailLib.DEBUG_PROTOCOL_SMTP) break block3;
                    Log.d((String)"k9", (String)("Tried to parse " + optionalsizeValue + " and get an int"), (Throwable)e);
                }
            }
        }
    }

    private Map<String, String> sendHello(String host) throws IOException, MessagingException {
        HashMap<String, String> extensions = new HashMap<String, String>();
        try {
            List<String> results = this.executeSimpleCommand("EHLO " + host);
            results.remove(0);
            for (String result : results) {
                String[] pair = result.split(" ", 2);
                extensions.put(pair[0].toUpperCase(Locale.US), pair.length == 1 ? "" : pair[1]);
            }
        }
        catch (NegativeSmtpReplyException e) {
            if (K9MailLib.isDebug()) {
                Log.v((String)"k9", (String)"Server doesn't support the EHLO command. Trying HELO...");
            }
            try {
                this.executeSimpleCommand("HELO " + host);
            }
            catch (NegativeSmtpReplyException e2) {
                Log.w((String)"k9", (String)"Server doesn't support the HELO command. Continuing anyway.");
            }
        }
        return extensions;
    }

    @Override
    public void sendMessage(Message message) throws MessagingException {
        ArrayList<Address> addresses = new ArrayList<Address>();
        addresses.addAll(Arrays.asList(message.getRecipients(Message.RecipientType.TO)));
        addresses.addAll(Arrays.asList(message.getRecipients(Message.RecipientType.CC)));
        addresses.addAll(Arrays.asList(message.getRecipients(Message.RecipientType.BCC)));
        message.setRecipients(Message.RecipientType.BCC, null);
        HashMap<String, ArrayList<String>> charsetAddressesMap = new HashMap<String, ArrayList<String>>();
        for (Address address : addresses) {
            String addressString = address.getAddress();
            String charset = CharsetSupport.getCharsetFromAddress(addressString);
            ArrayList<String> addressesOfCharset = (ArrayList<String>)charsetAddressesMap.get(charset);
            if (addressesOfCharset == null) {
                addressesOfCharset = new ArrayList<String>();
                charsetAddressesMap.put(charset, addressesOfCharset);
            }
            addressesOfCharset.add(addressString);
        }
        for (Map.Entry entry : charsetAddressesMap.entrySet()) {
            String charset = (String)entry.getKey();
            List addressesOfCharset = (List)entry.getValue();
            message.setCharset(charset);
            this.sendMessageTo(addressesOfCharset, message);
        }
    }

    private void sendMessageTo(List<String> addresses, Message message) throws MessagingException {
        this.close();
        this.open();
        if (!this.m8bitEncodingAllowed) {
            Log.d((String)"k9", (String)"Server does not support 8bit transfer encoding");
        }
        if (this.mLargestAcceptableMessage > 0 && message.hasAttachments() && message.calculateSize() > (long)this.mLargestAcceptableMessage) {
            throw new MessagingException("Message too large for server", true);
        }
        boolean entireMessageSent = false;
        Address[] from = message.getFrom();
        try {
            this.executeSimpleCommand("MAIL FROM:<" + from[0].getAddress() + ">" + (this.m8bitEncodingAllowed ? " BODY=8BITMIME" : ""));
            for (String address : addresses) {
                this.executeSimpleCommand("RCPT TO:<" + address + ">");
            }
            this.executeSimpleCommand("DATA");
            EOLConvertingOutputStream msgOut = new EOLConvertingOutputStream(new LineWrapOutputStream(new SmtpDataStuffing(this.mOut), 1000));
            message.writeTo(msgOut);
            msgOut.endWithCrLfAndFlush();
            entireMessageSent = true;
            this.executeSimpleCommand(".");
        }
        catch (NegativeSmtpReplyException e) {
            throw e;
        }
        catch (Exception e) {
            MessagingException me = new MessagingException("Unable to send message", e);
            me.setPermanentFailure(entireMessageSent);
            throw me;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        try {
            this.executeSimpleCommand("QUIT");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mIn = null;
        this.mOut = null;
        this.mSocket = null;
    }

    private String readLine() throws IOException {
        int d;
        StringBuilder sb = new StringBuilder();
        while ((d = this.mIn.read()) != -1) {
            if ((char)d == '\r') continue;
            if ((char)d == '\n') break;
            sb.append((char)d);
        }
        String ret = sb.toString();
        if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_SMTP) {
            Log.d((String)"k9", (String)("SMTP <<< " + ret));
        }
        return ret;
    }

    private void writeLine(String s, boolean sensitive) throws IOException {
        if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_SMTP) {
            String commandToLog = sensitive && !K9MailLib.isDebugSensitive() ? "SMTP >>> *sensitive*" : "SMTP >>> " + s;
            Log.d((String)"k9", (String)commandToLog);
        }
        byte[] data = s.concat("\r\n").getBytes();
        this.mOut.write(data);
        this.mOut.flush();
    }

    private void checkLine(String line) throws MessagingException {
        int length = line.length();
        if (length < 1) {
            throw new MessagingException("SMTP response is 0 length");
        }
        char c = line.charAt(0);
        if (c == '4' || c == '5') {
            int replyCode = -1;
            String message = line;
            if (length >= 3) {
                try {
                    replyCode = Integer.parseInt(line.substring(0, 3));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                message = length > 4 ? line.substring(4) : "";
            }
            throw new NegativeSmtpReplyException(replyCode, message);
        }
    }

    private List<String> executeSimpleCommand(String command) throws IOException, MessagingException {
        return this.executeSimpleCommand(command, false);
    }

    private List<String> executeSimpleCommand(String command, boolean sensitive) throws IOException, MessagingException {
        ArrayList<String> results = new ArrayList<String>();
        if (command != null) {
            this.writeLine(command, sensitive);
        }
        String line = this.readLine();
        while (line.length() >= 4) {
            if (line.length() > 4) {
                results.add(line.substring(4));
            }
            if (line.charAt(3) != '-') break;
            line = this.readLine();
        }
        this.checkLine(line);
        return results;
    }

    private void saslAuthLogin(String username, String password) throws MessagingException, AuthenticationFailedException, IOException {
        try {
            this.executeSimpleCommand("AUTH LOGIN");
            this.executeSimpleCommand(Base64.encode(username), true);
            this.executeSimpleCommand(Base64.encode(password), true);
        }
        catch (NegativeSmtpReplyException exception) {
            if (exception.getReplyCode() == 535) {
                throw new AuthenticationFailedException("AUTH LOGIN failed (" + exception.getMessage() + ")");
            }
            throw exception;
        }
    }

    private void saslAuthPlain(String username, String password) throws MessagingException, AuthenticationFailedException, IOException {
        String data = Base64.encode("\u0000" + username + "\u0000" + password);
        try {
            this.executeSimpleCommand("AUTH PLAIN " + data, true);
        }
        catch (NegativeSmtpReplyException exception) {
            if (exception.getReplyCode() == 535) {
                throw new AuthenticationFailedException("AUTH PLAIN failed (" + exception.getMessage() + ")");
            }
            throw exception;
        }
    }

    private void saslAuthCramMD5(String username, String password) throws MessagingException, AuthenticationFailedException, IOException {
        List<String> respList = this.executeSimpleCommand("AUTH CRAM-MD5");
        if (respList.size() != 1) {
            throw new MessagingException("Unable to negotiate CRAM-MD5");
        }
        String b64Nonce = respList.get(0);
        String b64CRAMString = Authentication.computeCramMd5(this.mUsername, this.mPassword, b64Nonce);
        try {
            this.executeSimpleCommand(b64CRAMString, true);
        }
        catch (NegativeSmtpReplyException exception) {
            if (exception.getReplyCode() == 535) {
                throw new AuthenticationFailedException(exception.getMessage(), exception);
            }
            throw exception;
        }
    }

    private void saslAuthExternal(String username) throws MessagingException, IOException {
        this.executeSimpleCommand(String.format("AUTH EXTERNAL %s", Base64.encode(username)), false);
    }

    protected String getCanonicalHostName(InetAddress localAddress) {
        return localAddress.getCanonicalHostName();
    }

    static class NegativeSmtpReplyException
    extends MessagingException {
        private static final long serialVersionUID = 8696043577357897135L;
        private final int mReplyCode;
        private final String mReplyText;

        public NegativeSmtpReplyException(int replyCode, String replyText) {
            super("Negative SMTP reply: " + replyCode + " " + replyText, NegativeSmtpReplyException.isPermanentSmtpError(replyCode));
            this.mReplyCode = replyCode;
            this.mReplyText = replyText;
        }

        private static boolean isPermanentSmtpError(int replyCode) {
            return replyCode >= 500 && replyCode <= 599;
        }

        public int getReplyCode() {
            return this.mReplyCode;
        }

        public String getReplyText() {
            return this.mReplyText;
        }
    }
}

