/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.webdav;

import android.util.Log;
import com.fsck.k9.mail.CertificateValidationException;
import com.fsck.k9.mail.ConnectionSecurity;
import com.fsck.k9.mail.Folder;
import com.fsck.k9.mail.K9MailLib;
import com.fsck.k9.mail.Message;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.ServerSettings;
import com.fsck.k9.mail.filter.Base64;
import com.fsck.k9.mail.helper.UrlEncodingHelper;
import com.fsck.k9.mail.store.RemoteStore;
import com.fsck.k9.mail.store.StoreConfig;
import com.fsck.k9.mail.store.webdav.ConnectionInfo;
import com.fsck.k9.mail.store.webdav.DataSet;
import com.fsck.k9.mail.store.webdav.HttpGeneric;
import com.fsck.k9.mail.store.webdav.WebDavFolder;
import com.fsck.k9.mail.store.webdav.WebDavHandler;
import com.fsck.k9.mail.store.webdav.WebDavHttpClient;
import com.fsck.k9.mail.store.webdav.WebDavSocketFactory;
import com.fsck.k9.mail.store.webdav.WebDavStoreSettings;
import com.fsck.k9.mail.store.webdav.WebDavUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class WebDavStore
extends RemoteStore {
    private ConnectionSecurity mConnectionSecurity;
    private String mUsername;
    private String mAlias;
    private String mPassword;
    private String mUrl;
    private String mHost;
    private int mPort;
    private String mPath;
    private String mAuthPath;
    private String mMailboxPath;
    private final WebDavHttpClient.WebDavHttpClientFactory mHttpClientFactory;
    private WebDavHttpClient mHttpClient = null;
    private HttpContext mContext = null;
    private String mAuthString;
    private CookieStore mAuthCookies = null;
    private short mAuthentication = 0;
    private String mCachedLoginUrl;
    private Folder mSendFolder = null;
    private Map<String, WebDavFolder> mFolderList = new HashMap<String, WebDavFolder>();

    public static WebDavStoreSettings decodeUri(String uri) {
        String[] hostParts;
        ConnectionSecurity connectionSecurity;
        URI webDavUri;
        String username = null;
        String password = null;
        String alias = null;
        String path = null;
        String authPath = null;
        String mailboxPath = null;
        try {
            webDavUri = new URI(uri);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Invalid WebDavStore URI", use);
        }
        String scheme = webDavUri.getScheme();
        if (scheme.equals("webdav")) {
            connectionSecurity = ConnectionSecurity.NONE;
        } else if (scheme.startsWith("webdav+")) {
            connectionSecurity = ConnectionSecurity.SSL_TLS_REQUIRED;
        } else {
            throw new IllegalArgumentException("Unsupported protocol (" + scheme + ")");
        }
        String host = webDavUri.getHost();
        if (host.startsWith("http") && (hostParts = host.split("://", 2)).length > 1) {
            host = hostParts[1];
        }
        int port = webDavUri.getPort();
        String userInfo = webDavUri.getUserInfo();
        if (userInfo != null) {
            String[] userInfoParts = userInfo.split(":");
            username = UrlEncodingHelper.decodeUtf8(userInfoParts[0]);
            String[] userParts = username.split("\\\\", 2);
            alias = userParts.length > 1 ? userParts[1] : username;
            if (userInfoParts.length > 1) {
                password = UrlEncodingHelper.decodeUtf8(userInfoParts[1]);
            }
        }
        String[] pathParts = webDavUri.getPath().split("\\|");
        int count = pathParts.length;
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                if (pathParts[0] == null || pathParts[0].length() <= 1) continue;
                path = pathParts[0];
                continue;
            }
            if (i == 1) {
                if (pathParts[1] == null || pathParts[1].length() <= 1) continue;
                authPath = pathParts[1];
                continue;
            }
            if (i != 2 || pathParts[2] == null || pathParts[2].length() <= 1) continue;
            mailboxPath = pathParts[2];
        }
        return new WebDavStoreSettings(host, port, connectionSecurity, null, username, password, null, alias, path, authPath, mailboxPath);
    }

    public static String createUri(ServerSettings server) {
        String uriPath;
        String scheme;
        String userEnc = UrlEncodingHelper.encodeUtf8(server.username);
        String passwordEnc = server.password != null ? UrlEncodingHelper.encodeUtf8(server.password) : "";
        switch (server.connectionSecurity) {
            case SSL_TLS_REQUIRED: {
                scheme = "webdav+ssl+";
                break;
            }
            default: {
                scheme = "webdav";
            }
        }
        String userInfo = userEnc + ":" + passwordEnc;
        Map<String, String> extra = server.getExtra();
        if (extra != null) {
            String path = extra.get("path");
            path = path != null ? path : "";
            String authPath = extra.get("authPath");
            authPath = authPath != null ? authPath : "";
            String mailboxPath = extra.get("mailboxPath");
            mailboxPath = mailboxPath != null ? mailboxPath : "";
            uriPath = "/" + path + "|" + authPath + "|" + mailboxPath;
        } else {
            uriPath = "/||";
        }
        try {
            return new URI(scheme, userInfo, server.host, server.port, uriPath, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Can't create WebDavStore URI", e);
        }
    }

    public WebDavStore(StoreConfig storeConfig, WebDavHttpClient.WebDavHttpClientFactory clientFactory) throws MessagingException {
        super(storeConfig, null);
        WebDavStoreSettings settings;
        this.mHttpClientFactory = clientFactory;
        try {
            settings = WebDavStore.decodeUri(storeConfig.getStoreUri());
        }
        catch (IllegalArgumentException e) {
            throw new MessagingException("Error while decoding store URI", e);
        }
        this.mHost = settings.host;
        this.mPort = settings.port;
        this.mConnectionSecurity = settings.connectionSecurity;
        this.mUsername = settings.username;
        this.mPassword = settings.password;
        this.mAlias = settings.alias;
        this.mPath = settings.path;
        this.mAuthPath = settings.authPath;
        this.mMailboxPath = settings.mailboxPath;
        if (this.mPath == null || this.mPath.equals("")) {
            this.mPath = "/Exchange";
        } else if (!this.mPath.startsWith("/")) {
            this.mPath = "/" + this.mPath;
        }
        if (this.mMailboxPath == null || this.mMailboxPath.equals("")) {
            this.mMailboxPath = "/" + this.mAlias;
        } else if (!this.mMailboxPath.startsWith("/")) {
            this.mMailboxPath = "/" + this.mMailboxPath;
        }
        if (this.mAuthPath != null && !this.mAuthPath.equals("") && !this.mAuthPath.startsWith("/")) {
            this.mAuthPath = "/" + this.mAuthPath;
        }
        this.mUrl = this.getRoot() + this.mPath + this.mMailboxPath;
        this.mAuthString = "Basic " + Base64.encode(this.mUsername + ":" + this.mPassword);
    }

    private String getRoot() {
        String root = this.mConnectionSecurity == ConnectionSecurity.SSL_TLS_REQUIRED ? "https" : "http";
        root = root + "://" + this.mHost + ":" + this.mPort;
        return root;
    }

    HttpContext getContext() {
        return this.mContext;
    }

    short getAuthentication() {
        return this.mAuthentication;
    }

    StoreConfig getStoreConfig() {
        return this.mStoreConfig;
    }

    @Override
    public void checkSettings() throws MessagingException {
        this.authenticate();
    }

    @Override
    public List<? extends Folder> getPersonalNamespaces(boolean forceListAll) throws MessagingException {
        String[] folderUrls;
        LinkedList<WebDavFolder> folderList = new LinkedList<WebDavFolder>();
        this.getHttpClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Depth", "0");
        headers.put("Brief", "t");
        DataSet dataset = this.processRequest(this.mUrl, "PROPFIND", this.getSpecialFoldersList(), headers);
        Map<String, String> specialFoldersMap = dataset.getSpecialFolderToUrl();
        String folderName = this.getFolderName(specialFoldersMap.get("inbox"));
        if (folderName != null) {
            this.mStoreConfig.setAutoExpandFolderName(folderName);
            this.mStoreConfig.setInboxFolderName(folderName);
        }
        if ((folderName = this.getFolderName(specialFoldersMap.get("drafts"))) != null) {
            this.mStoreConfig.setDraftsFolderName(folderName);
        }
        if ((folderName = this.getFolderName(specialFoldersMap.get("deleteditems"))) != null) {
            this.mStoreConfig.setTrashFolderName(folderName);
        }
        if ((folderName = this.getFolderName(specialFoldersMap.get("junkemail"))) != null) {
            this.mStoreConfig.setSpamFolderName(folderName);
        }
        if ((folderName = this.getFolderName(specialFoldersMap.get("sentitems"))) != null) {
            this.mStoreConfig.setSentFolderName(folderName);
        }
        headers = new HashMap();
        headers.put("Brief", "t");
        dataset = this.processRequest(this.mUrl, "SEARCH", this.getFolderListXml(), headers);
        for (String tempUrl : folderUrls = dataset.getHrefs()) {
            WebDavFolder folder = this.createFolder(tempUrl);
            if (folder == null) continue;
            folderList.add(folder);
        }
        return folderList;
    }

    private WebDavFolder createFolder(String folderUrl) {
        if (folderUrl == null) {
            return null;
        }
        WebDavFolder wdFolder = null;
        String folderName = this.getFolderName(folderUrl);
        if (folderName != null && (wdFolder = this.getFolder(folderName)) != null) {
            wdFolder.setUrl(folderUrl);
        }
        return wdFolder;
    }

    private String getFolderName(String folderUrl) {
        if (folderUrl == null) {
            return null;
        }
        int folderSlash = -1;
        for (int j = 0; j < 5 && (folderSlash = folderUrl.indexOf(47, folderSlash + 1)) >= 0; ++j) {
        }
        if (folderSlash > 0) {
            String fullPathName = folderUrl.charAt(folderUrl.length() - 1) == '/' ? folderUrl.substring(folderSlash + 1, folderUrl.length() - 1) : folderUrl.substring(folderSlash + 1);
            return UrlEncodingHelper.decodeUtf8(fullPathName);
        }
        return null;
    }

    public WebDavFolder getFolder(String name) {
        WebDavFolder folder = this.mFolderList.get(name);
        if (folder == null) {
            folder = new WebDavFolder(this, name);
            this.mFolderList.put(name, folder);
        }
        return folder;
    }

    public Folder getSendSpoolFolder() throws MessagingException {
        if (this.mSendFolder == null) {
            this.mSendFolder = this.getFolder("##DavMailSubmissionURI##");
        }
        return this.mSendFolder;
    }

    @Override
    public boolean isMoveCapable() {
        return true;
    }

    @Override
    public boolean isCopyCapable() {
        return true;
    }

    private String getSpecialFoldersList() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
        builder.append("<propfind xmlns=\"DAV:\">");
        builder.append("<prop>");
        builder.append("<").append("inbox").append(" xmlns=\"urn:schemas:httpmail:\"/>");
        builder.append("<").append("drafts").append(" xmlns=\"urn:schemas:httpmail:\"/>");
        builder.append("<").append("outbox").append(" xmlns=\"urn:schemas:httpmail:\"/>");
        builder.append("<").append("sentitems").append(" xmlns=\"urn:schemas:httpmail:\"/>");
        builder.append("<").append("deleteditems").append(" xmlns=\"urn:schemas:httpmail:\"/>");
        builder.append("<").append("junkemail").append(" xmlns=\"urn:schemas:httpmail:\"/>");
        builder.append("</prop>");
        builder.append("</propfind>");
        return builder.toString();
    }

    private String getFolderListXml() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("<?xml version='1.0' ?>");
        builder.append("<a:searchrequest xmlns:a='DAV:'><a:sql>\r\n");
        builder.append("SELECT \"DAV:uid\", \"DAV:ishidden\"\r\n");
        builder.append(" FROM SCOPE('deep traversal of \"").append(this.mUrl).append("\"')\r\n");
        builder.append(" WHERE \"DAV:ishidden\"=False AND \"DAV:isfolder\"=True\r\n");
        builder.append("</a:sql></a:searchrequest>\r\n");
        return builder.toString();
    }

    String getMessageCountXml(String messageState) {
        StringBuilder builder = new StringBuilder(200);
        builder.append("<?xml version='1.0' ?>");
        builder.append("<a:searchrequest xmlns:a='DAV:'><a:sql>\r\n");
        builder.append("SELECT \"DAV:visiblecount\"\r\n");
        builder.append(" FROM \"\"\r\n");
        builder.append(" WHERE \"DAV:ishidden\"=False AND \"DAV:isfolder\"=False AND \"urn:schemas:httpmail:read\"=").append(messageState).append("\r\n");
        builder.append(" GROUP BY \"DAV:ishidden\"\r\n");
        builder.append("</a:sql></a:searchrequest>\r\n");
        return builder.toString();
    }

    String getMessageEnvelopeXml(String[] uids) {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append("<?xml version='1.0' ?>");
        buffer.append("<a:searchrequest xmlns:a='DAV:'><a:sql>\r\n");
        buffer.append("SELECT \"DAV:uid\", \"DAV:getcontentlength\",");
        buffer.append(" \"urn:schemas:mailheader:mime-version\",");
        buffer.append(" \"urn:schemas:mailheader:content-type\",");
        buffer.append(" \"urn:schemas:mailheader:subject\",");
        buffer.append(" \"urn:schemas:mailheader:date\",");
        buffer.append(" \"urn:schemas:mailheader:thread-topic\",");
        buffer.append(" \"urn:schemas:mailheader:thread-index\",");
        buffer.append(" \"urn:schemas:mailheader:from\",");
        buffer.append(" \"urn:schemas:mailheader:to\",");
        buffer.append(" \"urn:schemas:mailheader:in-reply-to\",");
        buffer.append(" \"urn:schemas:mailheader:cc\",");
        buffer.append(" \"urn:schemas:httpmail:read\"");
        buffer.append(" \r\n");
        buffer.append(" FROM \"\"\r\n");
        buffer.append(" WHERE \"DAV:ishidden\"=False AND \"DAV:isfolder\"=False AND ");
        int count = uids.length;
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                buffer.append("  OR ");
            }
            buffer.append(" \"DAV:uid\"='").append(uids[i]).append("' ");
        }
        buffer.append("\r\n");
        buffer.append("</a:sql></a:searchrequest>\r\n");
        return buffer.toString();
    }

    String getMessagesXml() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("<?xml version='1.0' ?>");
        builder.append("<a:searchrequest xmlns:a='DAV:'><a:sql>\r\n");
        builder.append("SELECT \"DAV:uid\"\r\n");
        builder.append(" FROM \"\"\r\n");
        builder.append(" WHERE \"DAV:ishidden\"=False AND \"DAV:isfolder\"=False\r\n");
        builder.append("</a:sql></a:searchrequest>\r\n");
        return builder.toString();
    }

    String getMessageUrlsXml(String[] uids) {
        StringBuilder buffer = new StringBuilder(600);
        buffer.append("<?xml version='1.0' ?>");
        buffer.append("<a:searchrequest xmlns:a='DAV:'><a:sql>\r\n");
        buffer.append("SELECT \"urn:schemas:httpmail:read\", \"DAV:uid\"\r\n");
        buffer.append(" FROM \"\"\r\n");
        buffer.append(" WHERE \"DAV:ishidden\"=False AND \"DAV:isfolder\"=False AND ");
        int count = uids.length;
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                buffer.append("  OR ");
            }
            buffer.append(" \"DAV:uid\"='").append(uids[i]).append("' ");
        }
        buffer.append("\r\n");
        buffer.append("</a:sql></a:searchrequest>\r\n");
        return buffer.toString();
    }

    String getMessageFlagsXml(String[] uids) throws MessagingException {
        if (uids.length == 0) {
            throw new MessagingException("Attempt to get flags on 0 length array for uids");
        }
        StringBuilder buffer = new StringBuilder(200);
        buffer.append("<?xml version='1.0' ?>");
        buffer.append("<a:searchrequest xmlns:a='DAV:'><a:sql>\r\n");
        buffer.append("SELECT \"urn:schemas:httpmail:read\", \"DAV:uid\"\r\n");
        buffer.append(" FROM \"\"\r\n");
        buffer.append(" WHERE \"DAV:ishidden\"=False AND \"DAV:isfolder\"=False AND ");
        int count = uids.length;
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                buffer.append(" OR ");
            }
            buffer.append(" \"DAV:uid\"='").append(uids[i]).append("' ");
        }
        buffer.append("\r\n");
        buffer.append("</a:sql></a:searchrequest>\r\n");
        return buffer.toString();
    }

    String getMarkMessagesReadXml(String[] urls, boolean read) {
        StringBuilder buffer = new StringBuilder(600);
        buffer.append("<?xml version='1.0' ?>\r\n");
        buffer.append("<a:propertyupdate xmlns:a='DAV:' xmlns:b='urn:schemas:httpmail:'>\r\n");
        buffer.append("<a:target>\r\n");
        for (String url : urls) {
            buffer.append(" <a:href>").append(url).append("</a:href>\r\n");
        }
        buffer.append("</a:target>\r\n");
        buffer.append("<a:set>\r\n");
        buffer.append(" <a:prop>\r\n");
        buffer.append("  <b:read>").append(read ? "1" : "0").append("</b:read>\r\n");
        buffer.append(" </a:prop>\r\n");
        buffer.append("</a:set>\r\n");
        buffer.append("</a:propertyupdate>\r\n");
        return buffer.toString();
    }

    String getMoveOrCopyMessagesReadXml(String[] urls, boolean isMove) {
        String action = isMove ? "move" : "copy";
        StringBuilder buffer = new StringBuilder(600);
        buffer.append("<?xml version='1.0' ?>\r\n");
        buffer.append("<a:").append(action).append(" xmlns:a='DAV:' xmlns:b='urn:schemas:httpmail:'>\r\n");
        buffer.append("<a:target>\r\n");
        for (String url : urls) {
            buffer.append(" <a:href>").append(url).append("</a:href>\r\n");
        }
        buffer.append("</a:target>\r\n");
        buffer.append("</a:").append(action).append(">\r\n");
        return buffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean authenticate() throws MessagingException {
        block8: {
            try {
                if (this.mAuthentication == 0) {
                    ConnectionInfo info = this.doInitialConnection();
                    if (info.requiredAuthType == 1) {
                        HttpGeneric request = new HttpGeneric(this.mUrl);
                        request.setMethod("GET");
                        request.setHeader("Authorization", this.mAuthString);
                        WebDavHttpClient httpClient = this.getHttpClient();
                        HttpResponse response = httpClient.executeOverride((HttpUriRequest)request, this.mContext);
                        int statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode >= 200 && statusCode < 300) {
                            this.mAuthentication = 1;
                            break block8;
                        } else {
                            if (statusCode != 401) throw new MessagingException("Error with code " + response.getStatusLine().getStatusCode() + " during request processing: " + response.getStatusLine().toString());
                            throw new MessagingException("Invalid username or password for authentication.");
                        }
                    }
                    if (info.requiredAuthType == 2) {
                        this.doFBA(info);
                    }
                    break block8;
                }
                if (this.mAuthentication != 1 && this.mAuthentication == 2) {
                    this.doFBA(null);
                }
            }
            catch (IOException ioe) {
                Log.e((String)"k9", (String)("Error during authentication: " + ioe + "\nStack: " + WebDavUtils.processException(ioe)));
                throw new MessagingException("Error during authentication", ioe);
            }
        }
        if (this.mAuthentication == 0) return false;
        return true;
    }

    private ConnectionInfo doInitialConnection() throws MessagingException {
        ConnectionInfo info;
        block6: {
            info = new ConnectionInfo();
            WebDavHttpClient httpClient = this.getHttpClient();
            HttpGeneric request = new HttpGeneric(this.mUrl);
            request.setMethod("GET");
            try {
                HttpResponse response = httpClient.executeOverride((HttpUriRequest)request, this.mContext);
                info.statusCode = response.getStatusLine().getStatusCode();
                if (info.statusCode == 401) {
                    info.requiredAuthType = 1;
                    break block6;
                }
                if (info.statusCode >= 200 && info.statusCode < 300 || info.statusCode >= 300 && info.statusCode < 400 || info.statusCode == 440) {
                    info.requiredAuthType = (short)2;
                    info.guessedAuthUrl = this.mAuthPath != null && !this.mAuthPath.equals("") ? this.getRoot() + this.mAuthPath : this.getRoot() + "/exchweb/bin/auth/owaauth.dll";
                    Header location = response.getFirstHeader("Location");
                    if (location != null) {
                        info.redirectUrl = location.getValue();
                    }
                    break block6;
                }
                throw new IOException("Error with code " + info.statusCode + " during request processing: " + response.getStatusLine().toString());
            }
            catch (SSLException e) {
                throw new CertificateValidationException(e.getMessage(), e);
            }
            catch (IOException ioe) {
                Log.e((String)"k9", (String)("IOException: " + ioe + "\nTrace: " + WebDavUtils.processException(ioe)));
                throw new MessagingException("IOException", ioe);
            }
        }
        return info;
    }

    public void doFBA(ConnectionInfo info) throws IOException, MessagingException {
        String loginUrl;
        if (this.mAuthCookies != null) {
            this.mAuthCookies.clear();
        }
        WebDavHttpClient httpClient = this.getHttpClient();
        if (info != null) {
            loginUrl = info.guessedAuthUrl;
        } else if (this.mCachedLoginUrl != null && !this.mCachedLoginUrl.equals("")) {
            loginUrl = this.mCachedLoginUrl;
        } else {
            throw new MessagingException("No valid login URL available for form-based authentication.");
        }
        HttpGeneric request = new HttpGeneric(loginUrl);
        request.setMethod("POST");
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        pairs.add(new BasicNameValuePair("destination", this.mUrl));
        pairs.add(new BasicNameValuePair("username", this.mUsername));
        pairs.add(new BasicNameValuePair("password", this.mPassword));
        pairs.add(new BasicNameValuePair("flags", "0"));
        pairs.add(new BasicNameValuePair("SubmitCreds", "Log+On"));
        pairs.add(new BasicNameValuePair("forcedownlevel", "0"));
        pairs.add(new BasicNameValuePair("trusted", "0"));
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(pairs);
        request.setEntity((HttpEntity)formEntity);
        HttpResponse response = httpClient.executeOverride((HttpUriRequest)request, this.mContext);
        boolean authenticated = this.testAuthenticationResponse(response);
        if (!authenticated) {
            String formAction = this.findFormAction(WebDavHttpClient.getUngzippedContent(response.getEntity()));
            if (formAction == null && info != null && info.redirectUrl != null && !info.redirectUrl.equals("")) {
                loginUrl = info.redirectUrl;
                request = new HttpGeneric(loginUrl);
                request.setMethod("GET");
                response = httpClient.executeOverride((HttpUriRequest)request, this.mContext);
                formAction = this.findFormAction(WebDavHttpClient.getUngzippedContent(response.getEntity()));
            }
            if (formAction != null) {
                try {
                    URI formActionUri = new URI(formAction);
                    URI loginUri = new URI(loginUrl);
                    if (formActionUri.isAbsolute()) {
                        loginUrl = formAction;
                    } else {
                        String urlPath;
                        if (formAction.startsWith("/")) {
                            urlPath = formAction;
                        } else {
                            urlPath = loginUri.getPath();
                            int lastPathPos = urlPath.lastIndexOf(47);
                            if (lastPathPos > -1) {
                                urlPath = urlPath.substring(0, lastPathPos + 1);
                                urlPath = urlPath.concat(formAction);
                            }
                        }
                        URI finalUri = new URI(loginUri.getScheme(), loginUri.getUserInfo(), loginUri.getHost(), loginUri.getPort(), urlPath, null, null);
                        loginUrl = finalUri.toString();
                    }
                    request = new HttpGeneric(loginUrl);
                    request.setMethod("POST");
                    request.setEntity((HttpEntity)formEntity);
                    response = httpClient.executeOverride((HttpUriRequest)request, this.mContext);
                    authenticated = this.testAuthenticationResponse(response);
                }
                catch (URISyntaxException e) {
                    Log.e((String)"k9", (String)("URISyntaxException caught " + e + "\nTrace: " + WebDavUtils.processException(e)));
                    throw new MessagingException("URISyntaxException caught", e);
                }
            } else {
                throw new MessagingException("A valid URL for Exchange authentication could not be found.");
            }
        }
        if (!authenticated) {
            throw new MessagingException("Invalid credentials provided for authentication.");
        }
        this.mAuthentication = (short)2;
        this.mCachedLoginUrl = loginUrl;
    }

    private String findFormAction(InputStream istream) throws IOException {
        String tempText;
        String formAction = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(istream), 4096);
        while ((tempText = reader.readLine()) != null && formAction == null) {
            int quesPos;
            char openQuote;
            int closePos;
            String[] actionParts;
            if (!tempText.contains(" action=") || (actionParts = tempText.split(" action=")).length <= 1 || actionParts[1].length() <= 1 || (closePos = actionParts[1].indexOf(openQuote = actionParts[1].charAt(0), 1)) <= 1 || (quesPos = (formAction = actionParts[1].substring(1, closePos)).indexOf(63)) == -1) continue;
            formAction = formAction.substring(0, quesPos);
        }
        return formAction;
    }

    private boolean testAuthenticationResponse(HttpResponse response) throws MessagingException {
        boolean authenticated = false;
        int statusCode = response.getStatusLine().getStatusCode();
        if ((statusCode >= 200 && statusCode < 300 || statusCode == 302) && this.mAuthCookies != null && !this.mAuthCookies.getCookies().isEmpty()) {
            ConnectionInfo info = this.doInitialConnection();
            if (info.statusCode >= 200 && info.statusCode < 300) {
                authenticated = true;
            } else if (info.statusCode == 302) {
                try {
                    String thisPath = new URI(this.mUrl).getPath();
                    String redirectPath = new URI(info.redirectUrl).getPath();
                    if (!thisPath.endsWith("/")) {
                        thisPath = thisPath.concat("/");
                    }
                    if (!redirectPath.endsWith("/")) {
                        redirectPath = redirectPath.concat("/");
                    }
                    if (redirectPath.equalsIgnoreCase(thisPath)) {
                        authenticated = true;
                    } else {
                        String replace;
                        int found = thisPath.indexOf(47, 1);
                        if (found != -1 && (redirectPath = redirectPath.replace("/owa/", replace = thisPath.substring(0, found + 1))).equalsIgnoreCase(thisPath)) {
                            authenticated = true;
                        }
                    }
                }
                catch (URISyntaxException e) {
                    Log.e((String)"k9", (String)("URISyntaxException caught " + e + "\nTrace: " + WebDavUtils.processException(e)));
                    throw new MessagingException("URISyntaxException caught", e);
                }
            }
        }
        return authenticated;
    }

    public CookieStore getAuthCookies() {
        return this.mAuthCookies;
    }

    public String getAlias() {
        return this.mAlias;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public WebDavHttpClient getHttpClient() throws MessagingException {
        if (this.mHttpClient == null) {
            this.mHttpClient = this.mHttpClientFactory.create();
            this.mHttpClient.getParams().setBooleanParameter("http.protocol.handle-redirects", false);
            this.mContext = new BasicHttpContext();
            this.mAuthCookies = new BasicCookieStore();
            this.mContext.setAttribute("http.cookie-store", (Object)this.mAuthCookies);
            SchemeRegistry reg = this.mHttpClient.getConnectionManager().getSchemeRegistry();
            try {
                Scheme s = new Scheme("https", (SocketFactory)new WebDavSocketFactory(this.mHost, 443), 443);
                reg.register(s);
            }
            catch (NoSuchAlgorithmException nsa) {
                Log.e((String)"k9", (String)("NoSuchAlgorithmException in getHttpClient: " + nsa));
                throw new MessagingException("NoSuchAlgorithmException in getHttpClient: " + nsa);
            }
            catch (KeyManagementException kme) {
                Log.e((String)"k9", (String)("KeyManagementException in getHttpClient: " + kme));
                throw new MessagingException("KeyManagementException in getHttpClient: " + kme);
            }
        }
        return this.mHttpClient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream sendRequest(String url, String method, StringEntity messageBody, Map<String, String> headers, boolean tryAuth) throws MessagingException {
        if (url == null || method == null) {
            return null;
        }
        WebDavHttpClient httpClient = this.getHttpClient();
        try {
            HttpGeneric httpMethod = new HttpGeneric(url);
            if (messageBody != null) {
                httpMethod.setEntity((HttpEntity)messageBody);
            }
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpMethod.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (this.mAuthentication == 0) {
                if (!tryAuth || !this.authenticate()) {
                    throw new MessagingException("Unable to authenticate in sendRequest().");
                }
            } else if (this.mAuthentication == 1) {
                httpMethod.setHeader("Authorization", this.mAuthString);
            }
            httpMethod.setMethod(method);
            HttpResponse response = httpClient.executeOverride((HttpUriRequest)httpMethod, this.mContext);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (statusCode == 401) {
                throw new MessagingException("Invalid username or password for Basic authentication.");
            }
            if (statusCode == 440) {
                if (!tryAuth || this.mAuthentication != 2) throw new MessagingException("Authentication failure in sendRequest().");
                this.doFBA(null);
                this.sendRequest(url, method, messageBody, headers, false);
            } else if (statusCode < 200 || statusCode >= 300) {
                throw new IOException("Error with code " + statusCode + " during request processing: " + response.getStatusLine().toString());
            }
            if (entity == null) return null;
            return WebDavHttpClient.getUngzippedContent(entity);
        }
        catch (UnsupportedEncodingException uee) {
            Log.e((String)"k9", (String)("UnsupportedEncodingException: " + uee + "\nTrace: " + WebDavUtils.processException(uee)));
            throw new MessagingException("UnsupportedEncodingException", uee);
        }
        catch (IOException ioe) {
            Log.e((String)"k9", (String)("IOException: " + ioe + "\nTrace: " + WebDavUtils.processException(ioe)));
            throw new MessagingException("IOException", ioe);
        }
    }

    public String getAuthString() {
        return this.mAuthString;
    }

    DataSet processRequest(String url, String method, String messageBody, Map<String, String> headers) throws MessagingException {
        return this.processRequest(url, method, messageBody, headers, true);
    }

    DataSet processRequest(String url, String method, String messageBody, Map<String, String> headers, boolean needsParsing) throws MessagingException {
        DataSet dataset;
        block9: {
            dataset = new DataSet();
            if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_WEBDAV) {
                Log.v((String)"k9", (String)("processRequest url = '" + url + "', method = '" + method + "', messageBody = '" + messageBody + "'"));
            }
            if (url == null || method == null) {
                return dataset;
            }
            this.getHttpClient();
            try {
                InputStream istream;
                StringEntity messageEntity = null;
                if (messageBody != null) {
                    messageEntity = new StringEntity(messageBody);
                    messageEntity.setContentType("text/xml");
                }
                if ((istream = this.sendRequest(url, method, messageEntity, headers, true)) == null || !needsParsing) break block9;
                try {
                    SAXParserFactory spf = SAXParserFactory.newInstance();
                    spf.setNamespaceAware(true);
                    SAXParser sp = spf.newSAXParser();
                    XMLReader xr = sp.getXMLReader();
                    WebDavHandler myHandler = new WebDavHandler();
                    xr.setContentHandler(myHandler);
                    xr.parse(new InputSource(istream));
                    dataset = myHandler.getDataSet();
                }
                catch (SAXException se) {
                    Log.e((String)"k9", (String)("SAXException in processRequest() " + se + "\nTrace: " + WebDavUtils.processException(se)));
                    throw new MessagingException("SAXException in processRequest() ", se);
                }
                catch (ParserConfigurationException pce) {
                    Log.e((String)"k9", (String)("ParserConfigurationException in processRequest() " + pce + "\nTrace: " + WebDavUtils.processException(pce)));
                    throw new MessagingException("ParserConfigurationException in processRequest() ", pce);
                }
                istream.close();
            }
            catch (UnsupportedEncodingException uee) {
                Log.e((String)"k9", (String)("UnsupportedEncodingException: " + uee + "\nTrace: " + WebDavUtils.processException(uee)));
                throw new MessagingException("UnsupportedEncodingException in processRequest() ", uee);
            }
            catch (IOException ioe) {
                Log.e((String)"k9", (String)("IOException: " + ioe + "\nTrace: " + WebDavUtils.processException(ioe)));
                throw new MessagingException("IOException in processRequest() ", ioe);
            }
        }
        return dataset;
    }

    @Override
    public boolean isSendCapable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessages(List<? extends Message> messages) throws MessagingException {
        try (WebDavFolder tmpFolder = this.getFolder(this.mStoreConfig.getDraftsFolderName());){
            tmpFolder.open(0);
            List<? extends Message> retMessages = tmpFolder.appendWebDavMessages(messages);
            tmpFolder.moveMessages(retMessages, this.getSendSpoolFolder());
        }
    }
}

