/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.webdav;

import android.util.Log;
import com.fsck.k9.mail.Flag;
import com.fsck.k9.mail.Folder;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.helper.UrlEncodingHelper;
import com.fsck.k9.mail.internet.MimeMessage;
import com.fsck.k9.mail.store.webdav.ParsedMessageEnvelope;
import com.fsck.k9.mail.store.webdav.WebDavFolder;
import com.fsck.k9.mail.store.webdav.WebDavUtils;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

class WebDavMessage
extends MimeMessage {
    private String mUrl = "";

    WebDavMessage(String uid, Folder folder) {
        this.mUid = uid;
        this.mFolder = folder;
    }

    public void setUrl(String url) {
        if (!url.toLowerCase(Locale.US).contains("http")) {
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
            url = ((WebDavFolder)this.mFolder).getUrl() + url;
        }
        String[] urlParts = url.split("/");
        int length = urlParts.length;
        String end = urlParts[length - 1];
        this.mUrl = "";
        url = "";
        try {
            end = UrlEncodingHelper.decodeUtf8(end);
            end = UrlEncodingHelper.encodeUtf8(end);
            end = end.replaceAll("\\+", "%20");
        }
        catch (IllegalArgumentException iae) {
            Log.e((String)"k9", (String)("IllegalArgumentException caught in setUrl: " + iae + "\nTrace: " + WebDavUtils.processException(iae)));
        }
        for (int i = 0; i < length - 1; ++i) {
            url = i != 0 ? url + "/" + urlParts[i] : urlParts[i];
        }
        this.mUrl = url = url + "/" + end;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setSize(int size) {
        this.mSize = size;
    }

    public void setFlagInternal(Flag flag, boolean set) throws MessagingException {
        super.setFlag(flag, set);
    }

    public void setNewHeaders(ParsedMessageEnvelope envelope) throws MessagingException {
        String[] headers = envelope.getHeaderList();
        Map<String, String> messageHeaders = envelope.getMessageHeaders();
        for (String header : headers) {
            String headerValue = messageHeaders.get(header);
            if (header.equals("Content-Length")) {
                int size = Integer.parseInt(headerValue);
                this.setSize(size);
            }
            if (headerValue == null || headerValue.equals("")) continue;
            this.addHeader(header, headerValue);
        }
    }

    @Override
    public void delete(String trashFolderName) throws MessagingException {
        WebDavFolder wdFolder = (WebDavFolder)this.getFolder();
        Log.i((String)"k9", (String)("Deleting message by moving to " + trashFolderName));
        wdFolder.moveMessages(Collections.singletonList(this), wdFolder.getStore().getFolder(trashFolderName));
    }

    @Override
    public void setFlag(Flag flag, boolean set) throws MessagingException {
        super.setFlag(flag, set);
        this.mFolder.setFlags(Collections.singletonList(this), Collections.singleton(flag), set);
    }
}

