/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.webdav;

import android.util.Log;
import com.fsck.k9.mail.FetchProfile;
import com.fsck.k9.mail.Flag;
import com.fsck.k9.mail.Folder;
import com.fsck.k9.mail.K9MailLib;
import com.fsck.k9.mail.Message;
import com.fsck.k9.mail.MessageRetrievalListener;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.filter.EOLConvertingOutputStream;
import com.fsck.k9.mail.helper.UrlEncodingHelper;
import com.fsck.k9.mail.store.webdav.DataSet;
import com.fsck.k9.mail.store.webdav.HttpGeneric;
import com.fsck.k9.mail.store.webdav.ParsedMessageEnvelope;
import com.fsck.k9.mail.store.webdav.WebDavHttpClient;
import com.fsck.k9.mail.store.webdav.WebDavMessage;
import com.fsck.k9.mail.store.webdav.WebDavStore;
import com.fsck.k9.mail.store.webdav.WebDavUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class WebDavFolder
extends Folder<WebDavMessage> {
    private String mName;
    private String mFolderUrl;
    private boolean mIsOpen = false;
    private int mMessageCount = 0;
    private int mUnreadMessageCount = 0;
    private WebDavStore store;

    protected WebDavStore getStore() {
        return this.store;
    }

    public WebDavFolder(WebDavStore nStore, String name) {
        this.store = nStore;
        this.mName = name;
        this.buildFolderUrl();
    }

    private void buildFolderUrl() {
        String[] urlParts = this.mName.split("/");
        String url = "";
        int count = urlParts.length;
        for (int i = 0; i < count; ++i) {
            url = i != 0 ? url + "/" + UrlEncodingHelper.encodeUtf8(urlParts[i]) : UrlEncodingHelper.encodeUtf8(urlParts[i]);
        }
        String encodedName = url;
        encodedName = encodedName.replaceAll("\\+", "%20");
        this.mFolderUrl = this.store.getUrl();
        if (!this.store.getUrl().endsWith("/")) {
            this.mFolderUrl = this.mFolderUrl + "/";
        }
        this.mFolderUrl = this.mFolderUrl + encodedName;
    }

    public void setUrl(String url) {
        if (url != null) {
            this.mFolderUrl = url;
        }
    }

    @Override
    public void open(int mode) throws MessagingException {
        this.store.getHttpClient();
        this.mIsOpen = true;
    }

    @Override
    public Map<String, String> copyMessages(List<? extends Message> messages, Folder folder) throws MessagingException {
        this.moveOrCopyMessages(messages, folder.getName(), false);
        return null;
    }

    @Override
    public Map<String, String> moveMessages(List<? extends Message> messages, Folder folder) throws MessagingException {
        this.moveOrCopyMessages(messages, folder.getName(), true);
        return null;
    }

    @Override
    public void delete(List<? extends Message> msgs, String trashFolderName) throws MessagingException {
        this.moveOrCopyMessages(msgs, trashFolderName, true);
    }

    private void moveOrCopyMessages(List<? extends Message> messages, String folderName, boolean isMove) throws MessagingException {
        String[] uids = new String[messages.size()];
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            uids[i] = messages.get(i).getUid();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        Map<String, String> uidToUrl = this.getMessageUrls(uids);
        String[] urls = new String[uids.length];
        int count2 = uids.length;
        for (int i = 0; i < count2; ++i) {
            urls[i] = uidToUrl.get(uids[i]);
            if (urls[i] != null || !(messages.get(i) instanceof WebDavMessage)) continue;
            WebDavMessage wdMessage = (WebDavMessage)messages.get(i);
            urls[i] = wdMessage.getUrl();
        }
        String messageBody = this.store.getMoveOrCopyMessagesReadXml(urls, isMove);
        WebDavFolder destFolder = this.store.getFolder(folderName);
        headers.put("Destination", destFolder.mFolderUrl);
        headers.put("Brief", "t");
        headers.put("If-Match", "*");
        String action = isMove ? "BMOVE" : "BCOPY";
        Log.i((String)"k9", (String)("Moving " + messages.size() + " messages to " + destFolder.mFolderUrl));
        this.store.processRequest(this.mFolderUrl, action, messageBody, headers, false);
    }

    private int getMessageCount(boolean read) throws MessagingException {
        int messageCount = 0;
        HashMap<String, String> headers = new HashMap<String, String>();
        String isRead = read ? "True" : "False";
        String messageBody = this.store.getMessageCountXml(isRead);
        headers.put("Brief", "t");
        DataSet dataset = this.store.processRequest(this.mFolderUrl, "SEARCH", messageBody, headers);
        if (dataset != null) {
            messageCount = dataset.getMessageCount();
        }
        if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_WEBDAV) {
            Log.v((String)"k9", (String)("Counted messages and webdav returned: " + messageCount));
        }
        return messageCount;
    }

    @Override
    public int getMessageCount() throws MessagingException {
        this.open(0);
        this.mMessageCount = this.getMessageCount(true);
        return this.mMessageCount;
    }

    @Override
    public int getUnreadMessageCount() throws MessagingException {
        this.open(0);
        this.mUnreadMessageCount = this.getMessageCount(false);
        return this.mUnreadMessageCount;
    }

    @Override
    public int getFlaggedMessageCount() throws MessagingException {
        return -1;
    }

    @Override
    public boolean isOpen() {
        return this.mIsOpen;
    }

    @Override
    public int getMode() {
        return 0;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void close() {
        this.mMessageCount = 0;
        this.mUnreadMessageCount = 0;
        this.mIsOpen = false;
    }

    @Override
    public boolean create(Folder.FolderType type) throws MessagingException {
        return true;
    }

    @Override
    public void delete(boolean recursive) throws MessagingException {
        throw new Error("WebDavFolder.delete() not implemeneted");
    }

    @Override
    public WebDavMessage getMessage(String uid) throws MessagingException {
        return new WebDavMessage(uid, this);
    }

    @Override
    public List<WebDavMessage> getMessages(int start, int end, Date earliestDate, MessageRetrievalListener<WebDavMessage> listener) throws MessagingException {
        ArrayList<WebDavMessage> messages = new ArrayList<WebDavMessage>();
        HashMap<String, String> headers = new HashMap<String, String>();
        int prevStart = start;
        start = this.mMessageCount - end;
        end = start + (end - prevStart);
        if (start < 0 || end < 0 || end < start) {
            throw new MessagingException(String.format(Locale.US, "Invalid message set %d %d", start, end));
        }
        if (start == 0 && end < 10) {
            end = 10;
        }
        String messageBody = this.store.getMessagesXml();
        headers.put("Brief", "t");
        headers.put("Range", "rows=" + start + "-" + end);
        DataSet dataset = this.store.processRequest(this.mFolderUrl, "SEARCH", messageBody, headers);
        String[] uids = dataset.getUids();
        Map<String, String> uidToUrl = dataset.getUidToUrl();
        int uidsLength = uids.length;
        for (int i = 0; i < uidsLength; ++i) {
            if (listener != null) {
                listener.messageStarted(uids[i], i, uidsLength);
            }
            WebDavMessage message = new WebDavMessage(uids[i], this);
            message.setUrl(uidToUrl.get(uids[i]));
            messages.add(message);
            if (listener == null) continue;
            listener.messageFinished(message, i, uidsLength);
        }
        return messages;
    }

    @Override
    public boolean areMoreMessagesAvailable(int indexOfOldestMessage, Date earliestDate) {
        return indexOfOldestMessage > 1;
    }

    private Map<String, String> getMessageUrls(String[] uids) throws MessagingException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String messageBody = this.store.getMessageUrlsXml(uids);
        headers.put("Brief", "t");
        DataSet dataset = this.store.processRequest(this.mFolderUrl, "SEARCH", messageBody, headers);
        return dataset.getUidToUrl();
    }

    @Override
    public void fetch(List<WebDavMessage> messages, FetchProfile fp, MessageRetrievalListener<WebDavMessage> listener) throws MessagingException {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        if (fp.contains((Object)FetchProfile.Item.ENVELOPE)) {
            this.fetchEnvelope(messages, listener);
        }
        if (fp.contains((Object)FetchProfile.Item.FLAGS)) {
            this.fetchFlags(messages, listener);
        }
        if (fp.contains((Object)FetchProfile.Item.BODY_SANE)) {
            int maximumAutoDownloadSize = this.store.getStoreConfig().getMaximumAutoDownloadMessageSize();
            if (maximumAutoDownloadSize > 0) {
                this.fetchMessages(messages, listener, maximumAutoDownloadSize / 76);
            } else {
                this.fetchMessages(messages, listener, -1);
            }
        }
        if (fp.contains((Object)FetchProfile.Item.BODY)) {
            this.fetchMessages(messages, listener, -1);
        }
    }

    private void fetchMessages(List<WebDavMessage> messages, MessageRetrievalListener<WebDavMessage> listener, int lines) throws MessagingException {
        WebDavHttpClient httpclient = this.store.getHttpClient();
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            WebDavMessage wdMessage;
            block18: {
                wdMessage = messages.get(i);
                int statusCode = 0;
                if (listener != null) {
                    listener.messageStarted(wdMessage.getUid(), i, count);
                }
                if (wdMessage.getUrl().equals("")) {
                    wdMessage.setUrl(this.getMessageUrls(new String[]{wdMessage.getUid()}).get(wdMessage.getUid()));
                    Log.i((String)"k9", (String)("Fetching messages with UID = '" + wdMessage.getUid() + "', URL = '" + wdMessage.getUrl() + "'"));
                    if (wdMessage.getUrl().equals("")) {
                        throw new MessagingException("Unable to get URL for message");
                    }
                }
                try {
                    Log.i((String)"k9", (String)("Fetching message with UID = '" + wdMessage.getUid() + "', URL = '" + wdMessage.getUrl() + "'"));
                    HttpGet httpget = new HttpGet(new URI(wdMessage.getUrl()));
                    httpget.setHeader("translate", "f");
                    if (this.store.getAuthentication() == 1) {
                        httpget.setHeader("Authorization", this.store.getAuthString());
                    }
                    HttpResponse response = httpclient.executeOverride((HttpUriRequest)httpget, this.store.getContext());
                    statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    if (statusCode < 200 || statusCode > 300) {
                        throw new IOException("Error during with code " + statusCode + " during fetch: " + response.getStatusLine().toString());
                    }
                    if (entity != null) {
                        InputStream istream = null;
                        StringBuilder buffer = new StringBuilder();
                        BufferedReader reader = null;
                        try {
                            istream = WebDavHttpClient.getUngzippedContent(entity);
                            if (lines != -1) {
                                String tempText;
                                reader = new BufferedReader(new InputStreamReader(istream), 8192);
                                for (int currentLines = 0; (tempText = reader.readLine()) != null && currentLines < lines; ++currentLines) {
                                    buffer.append(tempText).append("\r\n");
                                }
                                IOUtils.closeQuietly((InputStream)istream);
                                String resultText = buffer.toString();
                                istream = new ByteArrayInputStream(resultText.getBytes("UTF-8"));
                            }
                            wdMessage.parse(istream);
                            break block18;
                        }
                        catch (IOException ioe) {
                            Log.e((String)"k9", (String)("IOException: " + ioe.getMessage() + "\nTrace: " + WebDavUtils.processException(ioe)));
                            throw new MessagingException("I/O Error", ioe);
                        }
                        finally {
                            IOUtils.closeQuietly(reader);
                            IOUtils.closeQuietly((InputStream)istream);
                        }
                    }
                    Log.v((String)"k9", (String)"Empty response");
                }
                catch (IllegalArgumentException iae) {
                    Log.e((String)"k9", (String)("IllegalArgumentException caught " + iae + "\nTrace: " + WebDavUtils.processException(iae)));
                    throw new MessagingException("IllegalArgumentException caught", iae);
                }
                catch (URISyntaxException use) {
                    Log.e((String)"k9", (String)("URISyntaxException caught " + use + "\nTrace: " + WebDavUtils.processException(use)));
                    throw new MessagingException("URISyntaxException caught", use);
                }
                catch (IOException ioe) {
                    Log.e((String)"k9", (String)("Non-success response code loading message, response code was " + statusCode + "\nURL: " + wdMessage.getUrl() + "\nError: " + ioe.getMessage() + "\nTrace: " + WebDavUtils.processException(ioe)));
                    throw new MessagingException("Failure code " + statusCode, ioe);
                }
            }
            if (listener == null) continue;
            listener.messageFinished(wdMessage, i, count);
        }
    }

    private void fetchFlags(List<WebDavMessage> startMessages, MessageRetrievalListener<WebDavMessage> listener) throws MessagingException {
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList<WebDavMessage> messages = new ArrayList<WebDavMessage>(20);
        if (startMessages == null || startMessages.isEmpty()) {
            return;
        }
        if (startMessages.size() > 20) {
            ArrayList<WebDavMessage> newMessages = new ArrayList<WebDavMessage>(startMessages.size() - 20);
            int count = startMessages.size();
            for (int i = 0; i < count; ++i) {
                if (i < 20) {
                    messages.add(startMessages.get(i));
                    continue;
                }
                newMessages.add(startMessages.get(i));
            }
            this.fetchFlags(newMessages, listener);
        } else {
            messages.addAll(startMessages);
        }
        String[] uids = new String[messages.size()];
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            uids[i] = ((Message)messages.get(i)).getUid();
        }
        String messageBody = this.store.getMessageFlagsXml(uids);
        headers.put("Brief", "t");
        DataSet dataset = this.store.processRequest(this.mFolderUrl, "SEARCH", messageBody, headers);
        if (dataset == null) {
            throw new MessagingException("Data Set from request was null");
        }
        Map<String, Boolean> uidToReadStatus = dataset.getUidToRead();
        int count2 = messages.size();
        for (int i = 0; i < count2; ++i) {
            if (!(messages.get(i) instanceof WebDavMessage)) {
                throw new MessagingException("WebDavStore fetch called with non-WebDavMessage");
            }
            WebDavMessage wdMessage = (WebDavMessage)messages.get(i);
            try {
                wdMessage.setFlagInternal(Flag.SEEN, uidToReadStatus.get(wdMessage.getUid()));
                continue;
            }
            catch (NullPointerException e) {
                Log.v((String)"k9", (String)"Under some weird circumstances, setting the read status when syncing from webdav threw an NPE. Skipping.");
            }
        }
    }

    private void fetchEnvelope(List<WebDavMessage> startMessages, MessageRetrievalListener<WebDavMessage> listener) throws MessagingException {
        int count;
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList<WebDavMessage> messages = new ArrayList<WebDavMessage>(10);
        if (startMessages == null || startMessages.isEmpty()) {
            return;
        }
        if (startMessages.size() > 10) {
            ArrayList<WebDavMessage> newMessages = new ArrayList<WebDavMessage>(startMessages.size() - 10);
            count = startMessages.size();
            for (int i = 0; i < count; ++i) {
                if (i < 10) {
                    messages.add(i, startMessages.get(i));
                    continue;
                }
                newMessages.add(i - 10, startMessages.get(i));
            }
            this.fetchEnvelope(newMessages, listener);
        } else {
            messages.addAll(startMessages);
        }
        String[] uids = new String[messages.size()];
        int count2 = messages.size();
        for (int i = 0; i < count2; ++i) {
            uids[i] = ((WebDavMessage)messages.get(i)).getUid();
        }
        String messageBody = this.store.getMessageEnvelopeXml(uids);
        headers.put("Brief", "t");
        DataSet dataset = this.store.processRequest(this.mFolderUrl, "SEARCH", messageBody, headers);
        Map<String, ParsedMessageEnvelope> envelopes = dataset.getMessageEnvelopes();
        count = messages.size();
        for (int i = messages.size() - 1; i >= 0; --i) {
            ParsedMessageEnvelope envelope;
            WebDavMessage message = (WebDavMessage)messages.get(i);
            if (listener != null) {
                listener.messageStarted(((WebDavMessage)messages.get(i)).getUid(), i, count);
            }
            if ((envelope = envelopes.get(message.getUid())) != null) {
                message.setNewHeaders(envelope);
                message.setFlagInternal(Flag.SEEN, envelope.getReadStatus());
            } else {
                Log.e((String)"k9", (String)("Asked to get metadata for a non-existent message: " + message.getUid()));
            }
            if (listener == null) continue;
            listener.messageFinished((WebDavMessage)((Message)messages.get(i)), i, count);
        }
    }

    @Override
    public void setFlags(List<? extends Message> messages, Set<Flag> flags, boolean value) throws MessagingException {
        String[] uids = new String[messages.size()];
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            uids[i] = messages.get(i).getUid();
        }
        for (Flag flag : flags) {
            if (flag == Flag.SEEN) {
                this.markServerMessagesRead(uids, value);
                continue;
            }
            if (flag != Flag.DELETED) continue;
            this.deleteServerMessages(uids);
        }
    }

    private void markServerMessagesRead(String[] uids, boolean read) throws MessagingException {
        HashMap<String, String> headers = new HashMap<String, String>();
        Map<String, String> uidToUrl = this.getMessageUrls(uids);
        String[] urls = new String[uids.length];
        int count = uids.length;
        for (int i = 0; i < count; ++i) {
            urls[i] = uidToUrl.get(uids[i]);
        }
        String messageBody = this.store.getMarkMessagesReadXml(urls, read);
        headers.put("Brief", "t");
        headers.put("If-Match", "*");
        this.store.processRequest(this.mFolderUrl, "BPROPPATCH", messageBody, headers, false);
    }

    private void deleteServerMessages(String[] uids) throws MessagingException {
        Map<String, String> uidToUrl = this.getMessageUrls(uids);
        for (String uid : uids) {
            HashMap<String, String> headers = new HashMap<String, String>();
            String url = uidToUrl.get(uid);
            String destinationUrl = this.generateDeleteUrl(url);
            if (destinationUrl.equals(url)) {
                headers.put("Brief", "t");
                this.store.processRequest(url, "DELETE", null, headers, false);
                continue;
            }
            headers.put("Destination", this.generateDeleteUrl(url));
            headers.put("Brief", "t");
            this.store.processRequest(url, "MOVE", null, headers, false);
        }
    }

    private String generateDeleteUrl(String startUrl) {
        String[] urlParts = startUrl.split("/");
        String filename = urlParts[urlParts.length - 1];
        return this.store.getUrl() + "Deleted%20Items/" + filename;
    }

    @Override
    public Map<String, String> appendMessages(List<? extends Message> messages) throws MessagingException {
        this.appendWebDavMessages(messages);
        return null;
    }

    public List<? extends Message> appendWebDavMessages(List<? extends Message> messages) throws MessagingException {
        ArrayList<WebDavMessage> retMessages = new ArrayList<WebDavMessage>(messages.size());
        WebDavHttpClient httpclient = this.store.getHttpClient();
        for (Message message : messages) {
            try {
                HttpResponse response;
                int statusCode;
                ByteArrayOutputStream out = new ByteArrayOutputStream(message.getSize());
                this.open(0);
                EOLConvertingOutputStream msgOut = new EOLConvertingOutputStream(new BufferedOutputStream(out, 1024));
                message.writeTo(msgOut);
                msgOut.flush();
                StringEntity bodyEntity = new StringEntity(out.toString(), "UTF-8");
                bodyEntity.setContentType("message/rfc822");
                String messageURL = this.mFolderUrl;
                if (!messageURL.endsWith("/")) {
                    messageURL = messageURL + "/";
                }
                messageURL = messageURL + UrlEncodingHelper.encodeUtf8(message.getUid() + ":" + System.currentTimeMillis() + ".eml");
                Log.i((String)"k9", (String)("Uploading message as " + messageURL));
                HttpGeneric httpmethod = new HttpGeneric(messageURL);
                httpmethod.setMethod("PUT");
                httpmethod.setEntity((HttpEntity)bodyEntity);
                String mAuthString = this.store.getAuthString();
                if (mAuthString != null) {
                    httpmethod.setHeader("Authorization", mAuthString);
                }
                if ((statusCode = (response = httpclient.executeOverride((HttpUriRequest)httpmethod, this.store.getContext())).getStatusLine().getStatusCode()) < 200 || statusCode > 300) {
                    throw new IOException("Error with status code " + statusCode + " while sending/appending message.  Response = " + response.getStatusLine().toString() + " for message " + messageURL);
                }
                WebDavMessage retMessage = new WebDavMessage(message.getUid(), this);
                retMessage.setUrl(messageURL);
                retMessages.add(retMessage);
            }
            catch (Exception e) {
                throw new MessagingException("Unable to append", e);
            }
        }
        return retMessages;
    }

    public boolean equals(Object o) {
        if (o instanceof WebDavFolder) {
            return ((WebDavFolder)o).mName.equals(this.mName);
        }
        return super.equals(o);
    }

    @Override
    public String getUidFromMessageId(Message message) throws MessagingException {
        Log.e((String)"k9", (String)"Unimplemented method getUidFromMessageId in WebDavStore.WebDavFolder could lead to duplicate messages  being uploaded to the Sent folder");
        return null;
    }

    @Override
    public void setFlags(Set<Flag> flags, boolean value) throws MessagingException {
        Log.e((String)"k9", (String)"Unimplemented method setFlags(Set<Flag>, boolean) breaks markAllMessagesAsRead and EmptyTrash");
    }

    public String getUrl() {
        return this.mFolderUrl;
    }
}

