/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.pop3;

import android.annotation.SuppressLint;
import android.util.Log;
import com.fsck.k9.mail.AuthType;
import com.fsck.k9.mail.Authentication;
import com.fsck.k9.mail.AuthenticationFailedException;
import com.fsck.k9.mail.CertificateValidationException;
import com.fsck.k9.mail.ConnectionSecurity;
import com.fsck.k9.mail.FetchProfile;
import com.fsck.k9.mail.Flag;
import com.fsck.k9.mail.Folder;
import com.fsck.k9.mail.K9MailLib;
import com.fsck.k9.mail.Message;
import com.fsck.k9.mail.MessageRetrievalListener;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.ServerSettings;
import com.fsck.k9.mail.filter.Base64;
import com.fsck.k9.mail.filter.Hex;
import com.fsck.k9.mail.helper.UrlEncodingHelper;
import com.fsck.k9.mail.internet.MimeMessage;
import com.fsck.k9.mail.ssl.TrustedSocketFactory;
import com.fsck.k9.mail.store.RemoteStore;
import com.fsck.k9.mail.store.StoreConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLException;

public class Pop3Store
extends RemoteStore {
    private static final String STLS_COMMAND = "STLS";
    private static final String USER_COMMAND = "USER";
    private static final String PASS_COMMAND = "PASS";
    private static final String CAPA_COMMAND = "CAPA";
    private static final String AUTH_COMMAND = "AUTH";
    private static final String STAT_COMMAND = "STAT";
    private static final String LIST_COMMAND = "LIST";
    private static final String UIDL_COMMAND = "UIDL";
    private static final String TOP_COMMAND = "TOP";
    private static final String RETR_COMMAND = "RETR";
    private static final String DELE_COMMAND = "DELE";
    private static final String QUIT_COMMAND = "QUIT";
    private static final String STLS_CAPABILITY = "STLS";
    private static final String UIDL_CAPABILITY = "UIDL";
    private static final String TOP_CAPABILITY = "TOP";
    private static final String SASL_CAPABILITY = "SASL";
    private static final String AUTH_PLAIN_CAPABILITY = "PLAIN";
    private static final String AUTH_CRAM_MD5_CAPABILITY = "CRAM-MD5";
    private static final String AUTH_EXTERNAL_CAPABILITY = "EXTERNAL";
    private String mHost;
    private int mPort;
    private String mUsername;
    private String mPassword;
    private String mClientCertificateAlias;
    private AuthType mAuthType;
    private ConnectionSecurity mConnectionSecurity;
    private Map<String, Folder> mFolders = new HashMap<String, Folder>();
    private Pop3Capabilities mCapabilities;
    private boolean mTopNotSupported;

    public static ServerSettings decodeUri(String uri) {
        int port;
        ConnectionSecurity connectionSecurity;
        URI pop3Uri;
        String username = null;
        String password = null;
        String clientCertificateAlias = null;
        try {
            pop3Uri = new URI(uri);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Invalid Pop3Store URI", use);
        }
        String scheme = pop3Uri.getScheme();
        if (scheme.equals("pop3")) {
            connectionSecurity = ConnectionSecurity.NONE;
            port = ServerSettings.Type.POP3.defaultPort;
        } else if (scheme.startsWith("pop3+tls")) {
            connectionSecurity = ConnectionSecurity.STARTTLS_REQUIRED;
            port = ServerSettings.Type.POP3.defaultPort;
        } else if (scheme.startsWith("pop3+ssl")) {
            connectionSecurity = ConnectionSecurity.SSL_TLS_REQUIRED;
            port = ServerSettings.Type.POP3.defaultTlsPort;
        } else {
            throw new IllegalArgumentException("Unsupported protocol (" + scheme + ")");
        }
        String host = pop3Uri.getHost();
        if (pop3Uri.getPort() != -1) {
            port = pop3Uri.getPort();
        }
        AuthType authType = AuthType.PLAIN;
        if (pop3Uri.getUserInfo() != null) {
            int userIndex = 0;
            int passwordIndex = 1;
            String userinfo = pop3Uri.getUserInfo();
            String[] userInfoParts = userinfo.split(":");
            if (userInfoParts.length > 2 || userinfo.endsWith(":")) {
                ++userIndex;
                ++passwordIndex;
                authType = AuthType.valueOf(userInfoParts[0]);
            }
            username = UrlEncodingHelper.decodeUtf8(userInfoParts[userIndex]);
            if (userInfoParts.length > passwordIndex) {
                if (authType == AuthType.EXTERNAL) {
                    clientCertificateAlias = UrlEncodingHelper.decodeUtf8(userInfoParts[passwordIndex]);
                } else {
                    password = UrlEncodingHelper.decodeUtf8(userInfoParts[passwordIndex]);
                }
            }
        }
        return new ServerSettings(ServerSettings.Type.POP3, host, port, connectionSecurity, authType, username, password, clientCertificateAlias);
    }

    public static String createUri(ServerSettings server) {
        String scheme;
        String userEnc = UrlEncodingHelper.encodeUtf8(server.username);
        String passwordEnc = server.password != null ? UrlEncodingHelper.encodeUtf8(server.password) : "";
        String clientCertificateAliasEnc = server.clientCertificateAlias != null ? UrlEncodingHelper.encodeUtf8(server.clientCertificateAlias) : "";
        switch (server.connectionSecurity) {
            case SSL_TLS_REQUIRED: {
                scheme = "pop3+ssl+";
                break;
            }
            case STARTTLS_REQUIRED: {
                scheme = "pop3+tls+";
                break;
            }
            default: {
                scheme = "pop3";
            }
        }
        AuthType authType = server.authenticationType;
        String userInfo = AuthType.EXTERNAL == authType ? authType.name() + ":" + userEnc + ":" + clientCertificateAliasEnc : authType.name() + ":" + userEnc + ":" + passwordEnc;
        try {
            return new URI(scheme, userInfo, server.host, server.port, null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Can't create Pop3Store URI", e);
        }
    }

    public Pop3Store(StoreConfig storeConfig, TrustedSocketFactory socketFactory) throws MessagingException {
        super(storeConfig, socketFactory);
        ServerSettings settings;
        try {
            settings = Pop3Store.decodeUri(storeConfig.getStoreUri());
        }
        catch (IllegalArgumentException e) {
            throw new MessagingException("Error while decoding store URI", e);
        }
        this.mHost = settings.host;
        this.mPort = settings.port;
        this.mConnectionSecurity = settings.connectionSecurity;
        this.mUsername = settings.username;
        this.mPassword = settings.password;
        this.mClientCertificateAlias = settings.clientCertificateAlias;
        this.mAuthType = settings.authenticationType;
    }

    public Folder getFolder(String name) {
        Folder folder = this.mFolders.get(name);
        if (folder == null) {
            folder = new Pop3Folder(name);
            this.mFolders.put(folder.getName(), folder);
        }
        return folder;
    }

    @Override
    public List<? extends Folder> getPersonalNamespaces(boolean forceListAll) throws MessagingException {
        LinkedList<Folder> folders = new LinkedList<Folder>();
        folders.add(this.getFolder(this.mStoreConfig.getInboxFolderName()));
        return folders;
    }

    @Override
    public void checkSettings() throws MessagingException {
        try (Pop3Folder folder = new Pop3Folder(this.mStoreConfig.getInboxFolderName());){
            folder.open(0);
            if (!this.mCapabilities.uidl) {
                folder.executeSimpleCommand("UIDL");
            }
        }
    }

    @Override
    public boolean isSeenFlagSupported() {
        return false;
    }

    static class Pop3ErrorResponse
    extends MessagingException {
        private static final long serialVersionUID = 3672087845857867174L;

        public Pop3ErrorResponse(String message) {
            super(message, true);
        }
    }

    static class Pop3ResponseInputStream
    extends InputStream {
        private InputStream mIn;
        private boolean mStartOfLine = true;
        private boolean mFinished;

        public Pop3ResponseInputStream(InputStream in) {
            this.mIn = in;
        }

        @Override
        public int read() throws IOException {
            if (this.mFinished) {
                return -1;
            }
            int d = this.mIn.read();
            if (this.mStartOfLine && d == 46 && (d = this.mIn.read()) == 13) {
                this.mFinished = true;
                this.mIn.read();
                return -1;
            }
            this.mStartOfLine = d == 10;
            return d;
        }
    }

    static class Pop3Capabilities {
        public boolean cramMD5;
        public boolean authPlain;
        public boolean stls;
        public boolean top;
        public boolean uidl;
        public boolean external;

        Pop3Capabilities() {
        }

        public String toString() {
            return String.format("CRAM-MD5 %b, PLAIN %b, STLS %b, TOP %b, UIDL %b, EXTERNAL %b", this.cramMD5, this.authPlain, this.stls, this.top, this.uidl, this.external);
        }
    }

    static class Pop3Message
    extends MimeMessage {
        Pop3Message(String uid, Pop3Folder folder) {
            this.mUid = uid;
            this.mFolder = folder;
            this.mSize = -1;
        }

        public void setSize(int size) {
            this.mSize = size;
        }

        @Override
        public void setFlag(Flag flag, boolean set) throws MessagingException {
            super.setFlag(flag, set);
            this.mFolder.setFlags(Collections.singletonList(this), Collections.singleton(flag), set);
        }

        @Override
        public void delete(String trashFolderName) throws MessagingException {
            this.setFlag(Flag.DELETED, true);
        }
    }

    class Pop3Folder
    extends Folder<Pop3Message> {
        private Socket mSocket;
        private InputStream mIn;
        private OutputStream mOut;
        private Map<String, Pop3Message> mUidToMsgMap = new HashMap<String, Pop3Message>();
        @SuppressLint(value={"UseSparseArrays"})
        private Map<Integer, Pop3Message> mMsgNumToMsgMap = new HashMap<Integer, Pop3Message>();
        private Map<String, Integer> mUidToMsgNumMap = new HashMap<String, Integer>();
        private String mName;
        private int mMessageCount;

        public Pop3Folder(String name) {
            this.mName = name;
            if (this.mName.equalsIgnoreCase(Pop3Store.this.mStoreConfig.getInboxFolderName())) {
                this.mName = Pop3Store.this.mStoreConfig.getInboxFolderName();
            }
        }

        @Override
        public synchronized void open(int mode) throws MessagingException {
            if (this.isOpen()) {
                return;
            }
            if (!this.mName.equalsIgnoreCase(Pop3Store.this.mStoreConfig.getInboxFolderName())) {
                throw new MessagingException("Folder does not exist");
            }
            try {
                InetSocketAddress socketAddress = new InetSocketAddress(Pop3Store.this.mHost, Pop3Store.this.mPort);
                this.mSocket = Pop3Store.this.mConnectionSecurity == ConnectionSecurity.SSL_TLS_REQUIRED ? Pop3Store.this.mTrustedSocketFactory.createSocket(null, Pop3Store.this.mHost, Pop3Store.this.mPort, Pop3Store.this.mClientCertificateAlias) : new Socket();
                this.mSocket.connect(socketAddress, 30000);
                this.mIn = new BufferedInputStream(this.mSocket.getInputStream(), 1024);
                this.mOut = new BufferedOutputStream(this.mSocket.getOutputStream(), 512);
                this.mSocket.setSoTimeout(120000);
                if (!this.isOpen()) {
                    throw new MessagingException("Unable to connect socket");
                }
                String serverGreeting = this.executeSimpleCommand(null);
                Pop3Store.this.mCapabilities = this.getCapabilities();
                if (Pop3Store.this.mConnectionSecurity == ConnectionSecurity.STARTTLS_REQUIRED) {
                    if (((Pop3Store)Pop3Store.this).mCapabilities.stls) {
                        this.executeSimpleCommand("STLS");
                        this.mSocket = Pop3Store.this.mTrustedSocketFactory.createSocket(this.mSocket, Pop3Store.this.mHost, Pop3Store.this.mPort, Pop3Store.this.mClientCertificateAlias);
                        this.mSocket.setSoTimeout(120000);
                        this.mIn = new BufferedInputStream(this.mSocket.getInputStream(), 1024);
                        this.mOut = new BufferedOutputStream(this.mSocket.getOutputStream(), 512);
                        if (!this.isOpen()) {
                            throw new MessagingException("Unable to connect socket");
                        }
                        Pop3Store.this.mCapabilities = this.getCapabilities();
                    } else {
                        throw new CertificateValidationException("STARTTLS connection security not available");
                    }
                }
                switch (Pop3Store.this.mAuthType) {
                    case PLAIN: {
                        if (((Pop3Store)Pop3Store.this).mCapabilities.authPlain) {
                            this.authPlain();
                            break;
                        }
                        this.login();
                        break;
                    }
                    case CRAM_MD5: {
                        if (((Pop3Store)Pop3Store.this).mCapabilities.cramMD5) {
                            this.authCramMD5();
                            break;
                        }
                        this.authAPOP(serverGreeting);
                        break;
                    }
                    case EXTERNAL: {
                        if (((Pop3Store)Pop3Store.this).mCapabilities.external) {
                            this.authExternal();
                            break;
                        }
                        throw new CertificateValidationException(CertificateValidationException.Reason.MissingCapability);
                    }
                    default: {
                        throw new MessagingException("Unhandled authentication method found in the server settings (bug).");
                    }
                }
            }
            catch (SSLException e) {
                if (e.getCause() instanceof CertificateException) {
                    throw new CertificateValidationException(e.getMessage(), e);
                }
                throw new MessagingException("Unable to connect", e);
            }
            catch (GeneralSecurityException gse) {
                throw new MessagingException("Unable to open connection to POP server due to security error.", gse);
            }
            catch (IOException ioe) {
                throw new MessagingException("Unable to open connection to POP server.", ioe);
            }
            String response = this.executeSimpleCommand(Pop3Store.STAT_COMMAND);
            String[] parts = response.split(" ");
            this.mMessageCount = Integer.parseInt(parts[1]);
            this.mUidToMsgMap.clear();
            this.mMsgNumToMsgMap.clear();
            this.mUidToMsgNumMap.clear();
        }

        private void login() throws MessagingException {
            this.executeSimpleCommand("USER " + Pop3Store.this.mUsername);
            try {
                this.executeSimpleCommand("PASS " + Pop3Store.this.mPassword, true);
            }
            catch (Pop3ErrorResponse e) {
                throw new AuthenticationFailedException("POP3 login authentication failed: " + e.getMessage(), e);
            }
        }

        private void authPlain() throws MessagingException {
            this.executeSimpleCommand("AUTH PLAIN");
            try {
                byte[] encodedBytes = Base64.encodeBase64(("\u0000" + Pop3Store.this.mUsername + "\u0000" + Pop3Store.this.mPassword).getBytes());
                this.executeSimpleCommand(new String(encodedBytes), true);
            }
            catch (Pop3ErrorResponse e) {
                throw new AuthenticationFailedException("POP3 SASL auth PLAIN authentication failed: " + e.getMessage(), e);
            }
        }

        private void authAPOP(String serverGreeting) throws MessagingException {
            MessageDigest md;
            String timestamp = serverGreeting.replaceFirst("^\\+OK *(?:\\[[^\\]]+\\])?[^<]*(<[^>]*>)?[^<]*$", "$1");
            if ("".equals(timestamp)) {
                throw new MessagingException("APOP authentication is not supported");
            }
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new MessagingException("MD5 failure during POP3 auth APOP", e);
            }
            byte[] digest = md.digest((timestamp + Pop3Store.this.mPassword).getBytes());
            String hexDigest = new String(Hex.encodeHex(digest));
            try {
                this.executeSimpleCommand("APOP " + Pop3Store.this.mUsername + " " + hexDigest, true);
            }
            catch (Pop3ErrorResponse e) {
                throw new AuthenticationFailedException("POP3 APOP authentication failed: " + e.getMessage(), e);
            }
        }

        private void authCramMD5() throws MessagingException {
            String b64Nonce = this.executeSimpleCommand("AUTH CRAM-MD5").replace("+ ", "");
            String b64CRAM = Authentication.computeCramMd5(Pop3Store.this.mUsername, Pop3Store.this.mPassword, b64Nonce);
            try {
                this.executeSimpleCommand(b64CRAM, true);
            }
            catch (Pop3ErrorResponse e) {
                throw new AuthenticationFailedException("POP3 CRAM-MD5 authentication failed: " + e.getMessage(), e);
            }
        }

        private void authExternal() throws MessagingException {
            try {
                this.executeSimpleCommand(String.format("AUTH EXTERNAL %s", Base64.encode(Pop3Store.this.mUsername)), false);
            }
            catch (Pop3ErrorResponse e) {
                throw new CertificateValidationException("POP3 client certificate authentication failed: " + e.getMessage(), e);
            }
        }

        @Override
        public boolean isOpen() {
            return this.mIn != null && this.mOut != null && this.mSocket != null && this.mSocket.isConnected() && !this.mSocket.isClosed();
        }

        @Override
        public int getMode() {
            return 0;
        }

        @Override
        public void close() {
            try {
                if (this.isOpen()) {
                    this.executeSimpleCommand(Pop3Store.QUIT_COMMAND);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.closeIO();
        }

        private void closeIO() {
            try {
                this.mIn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.mOut.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.mSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mIn = null;
            this.mOut = null;
            this.mSocket = null;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public boolean create(Folder.FolderType type) throws MessagingException {
            return false;
        }

        @Override
        public boolean exists() throws MessagingException {
            return this.mName.equalsIgnoreCase(Pop3Store.this.mStoreConfig.getInboxFolderName());
        }

        @Override
        public int getMessageCount() {
            return this.mMessageCount;
        }

        @Override
        public int getUnreadMessageCount() throws MessagingException {
            return -1;
        }

        @Override
        public int getFlaggedMessageCount() throws MessagingException {
            return -1;
        }

        @Override
        public Pop3Message getMessage(String uid) throws MessagingException {
            Pop3Message message = this.mUidToMsgMap.get(uid);
            if (message == null) {
                message = new Pop3Message(uid, this);
            }
            return message;
        }

        @Override
        public List<Pop3Message> getMessages(int start, int end, Date earliestDate, MessageRetrievalListener<Pop3Message> listener) throws MessagingException {
            if (start < 1 || end < 1 || end < start) {
                throw new MessagingException(String.format(Locale.US, "Invalid message set %d %d", start, end));
            }
            try {
                this.indexMsgNums(start, end);
            }
            catch (IOException ioe) {
                throw new MessagingException("getMessages", ioe);
            }
            ArrayList<Pop3Message> messages = new ArrayList<Pop3Message>();
            int i = 0;
            for (int msgNum = start; msgNum <= end; ++msgNum) {
                Pop3Message message = this.mMsgNumToMsgMap.get(msgNum);
                if (message == null) continue;
                if (listener != null) {
                    listener.messageStarted(message.getUid(), i++, end - start + 1);
                }
                messages.add(message);
                if (listener == null) continue;
                listener.messageFinished(message, i++, end - start + 1);
            }
            return messages;
        }

        @Override
        public boolean areMoreMessagesAvailable(int indexOfOldestMessage, Date earliestDate) {
            return indexOfOldestMessage > 1;
        }

        private void indexMsgNums(int start, int end) throws MessagingException, IOException {
            int msgNum;
            int unindexedMessageCount = 0;
            for (msgNum = start; msgNum <= end; ++msgNum) {
                if (this.mMsgNumToMsgMap.get(msgNum) != null) continue;
                ++unindexedMessageCount;
            }
            if (unindexedMessageCount == 0) {
                return;
            }
            if (unindexedMessageCount < 50 && this.mMessageCount > 5000) {
                for (msgNum = start; msgNum <= end; ++msgNum) {
                    Pop3Message message = this.mMsgNumToMsgMap.get(msgNum);
                    if (message != null) continue;
                    String response = this.executeSimpleCommand("UIDL " + msgNum);
                    String[] uidParts = response.split(" +");
                    if (uidParts.length < 3 || !"+OK".equals(uidParts[0])) {
                        Log.e((String)"k9", (String)("ERR response: " + response));
                        return;
                    }
                    String msgUid = uidParts[2];
                    message = new Pop3Message(msgUid, this);
                    this.indexMessage(msgNum, message);
                }
            } else {
                String response = this.executeSimpleCommand("UIDL");
                while ((response = this.readLine()) != null && !response.equals(".")) {
                    Pop3Message message;
                    String[] uidParts = response.split(" +");
                    if (uidParts.length >= 3 && "+OK".equals(uidParts[0])) {
                        uidParts[0] = uidParts[1];
                        uidParts[1] = uidParts[2];
                    }
                    if (uidParts.length < 2) continue;
                    Integer msgNum2 = Integer.valueOf(uidParts[0]);
                    String msgUid = uidParts[1];
                    if (msgNum2 < start || msgNum2 > end || (message = this.mMsgNumToMsgMap.get(msgNum2)) != null) continue;
                    message = new Pop3Message(msgUid, this);
                    this.indexMessage(msgNum2, message);
                }
            }
        }

        private void indexUids(List<String> uids) throws MessagingException, IOException {
            HashSet<String> unindexedUids = new HashSet<String>();
            for (String uid : uids) {
                if (this.mUidToMsgMap.get(uid) != null) continue;
                if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_POP3) {
                    Log.d((String)"k9", (String)("Need to index UID " + uid));
                }
                unindexedUids.add(uid);
            }
            if (unindexedUids.isEmpty()) {
                return;
            }
            String response = this.executeSimpleCommand("UIDL");
            while ((response = this.readLine()) != null && !response.equals(".")) {
                Pop3Message message;
                String[] uidParts = response.split(" +");
                if (uidParts.length < 2) continue;
                Integer msgNum = Integer.valueOf(uidParts[0]);
                String msgUid = uidParts[1];
                if (!unindexedUids.contains(msgUid)) continue;
                if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_POP3) {
                    Log.d((String)"k9", (String)("Got msgNum " + msgNum + " for UID " + msgUid));
                }
                if ((message = this.mUidToMsgMap.get(msgUid)) == null) {
                    message = new Pop3Message(msgUid, this);
                }
                this.indexMessage(msgNum, message);
            }
        }

        private void indexMessage(int msgNum, Pop3Message message) {
            if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_POP3) {
                Log.d((String)"k9", (String)("Adding index for UID " + message.getUid() + " to msgNum " + msgNum));
            }
            this.mMsgNumToMsgMap.put(msgNum, message);
            this.mUidToMsgMap.put(message.getUid(), message);
            this.mUidToMsgNumMap.put(message.getUid(), msgNum);
        }

        @Override
        public void fetch(List<Pop3Message> messages, FetchProfile fp, MessageRetrievalListener<Pop3Message> listener) throws MessagingException {
            if (messages == null || messages.isEmpty()) {
                return;
            }
            ArrayList<String> uids = new ArrayList<String>();
            for (Message message : messages) {
                uids.add(message.getUid());
            }
            try {
                this.indexUids(uids);
            }
            catch (IOException ioe) {
                throw new MessagingException("fetch", ioe);
            }
            try {
                if (fp.contains((Object)FetchProfile.Item.ENVELOPE)) {
                    this.fetchEnvelope(messages, fp.size() == 1 ? listener : null);
                }
            }
            catch (IOException ioe) {
                throw new MessagingException("fetch", ioe);
            }
            int n = messages.size();
            for (int i = 0; i < n; ++i) {
                Pop3Message pop3Message = messages.get(i);
                try {
                    if (listener != null && !fp.contains((Object)FetchProfile.Item.ENVELOPE)) {
                        listener.messageStarted(pop3Message.getUid(), i, n);
                    }
                    if (fp.contains((Object)FetchProfile.Item.BODY)) {
                        this.fetchBody(pop3Message, -1);
                    } else if (fp.contains((Object)FetchProfile.Item.BODY_SANE)) {
                        if (Pop3Store.this.mStoreConfig.getMaximumAutoDownloadMessageSize() > 0) {
                            this.fetchBody(pop3Message, Pop3Store.this.mStoreConfig.getMaximumAutoDownloadMessageSize() / 76);
                        } else {
                            this.fetchBody(pop3Message, -1);
                        }
                    } else if (fp.contains((Object)FetchProfile.Item.STRUCTURE)) {
                        pop3Message.setBody(null);
                    }
                    if (listener == null || fp.contains((Object)FetchProfile.Item.ENVELOPE) && fp.size() == 1) continue;
                    listener.messageFinished(pop3Message, i, n);
                    continue;
                }
                catch (IOException ioe) {
                    throw new MessagingException("Unable to fetch message", ioe);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fetchEnvelope(List<Pop3Message> messages, MessageRetrievalListener<Pop3Message> listener) throws IOException, MessagingException {
            int unsizedMessages = 0;
            for (Message message : messages) {
                if (message.getSize() != -1) continue;
                ++unsizedMessages;
            }
            if (unsizedMessages == 0) {
                return;
            }
            if (unsizedMessages < 50 && this.mMessageCount > 5000) {
                int n = messages.size();
                for (int i = 0; i < n; ++i) {
                    Pop3Message pop3Message = messages.get(i);
                    if (listener != null) {
                        listener.messageStarted(pop3Message.getUid(), i, n);
                    }
                    String response = this.executeSimpleCommand(String.format(Locale.US, "LIST %d", this.mUidToMsgNumMap.get(pop3Message.getUid())));
                    String[] listParts = response.split(" ");
                    int msgSize = Integer.parseInt(listParts[2]);
                    pop3Message.setSize(msgSize);
                    if (listener == null) continue;
                    listener.messageFinished(pop3Message, i, n);
                }
            } else {
                HashSet<String> msgUidIndex = new HashSet<String>();
                for (Message message : messages) {
                    msgUidIndex.add(message.getUid());
                }
                boolean bl = false;
                int n = messages.size();
                String response = this.executeSimpleCommand(Pop3Store.LIST_COMMAND);
                while ((response = this.readLine()) != null && !response.equals(".")) {
                    void var5_10;
                    String[] listParts = response.split(" ");
                    int msgNum = Integer.parseInt(listParts[0]);
                    int msgSize = Integer.parseInt(listParts[1]);
                    Pop3Message pop3Message = this.mMsgNumToMsgMap.get(msgNum);
                    if (pop3Message == null || !msgUidIndex.contains(pop3Message.getUid())) continue;
                    if (listener != null) {
                        listener.messageStarted(pop3Message.getUid(), (int)var5_10, n);
                    }
                    pop3Message.setSize(msgSize);
                    if (listener != null) {
                        listener.messageFinished(pop3Message, (int)var5_10, n);
                    }
                    ++var5_10;
                }
            }
        }

        private void fetchBody(Pop3Message message, int lines) throws IOException, MessagingException {
            block10: {
                String response = null;
                if (lines != -1 && (!Pop3Store.this.mTopNotSupported || ((Pop3Store)Pop3Store.this).mCapabilities.top)) {
                    try {
                        if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_POP3 && !((Pop3Store)Pop3Store.this).mCapabilities.top) {
                            Log.d((String)"k9", (String)"This server doesn't support the CAPA command. Checking to see if the TOP command is supported nevertheless.");
                        }
                        response = this.executeSimpleCommand(String.format(Locale.US, "TOP %d %d", this.mUidToMsgNumMap.get(message.getUid()), lines));
                        ((Pop3Store)Pop3Store.this).mCapabilities.top = true;
                    }
                    catch (Pop3ErrorResponse e) {
                        if (((Pop3Store)Pop3Store.this).mCapabilities.top) {
                            throw e;
                        }
                        if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_POP3) {
                            Log.d((String)"k9", (String)"The server really doesn't support the TOP command. Using RETR instead.");
                        }
                        Pop3Store.this.mTopNotSupported = true;
                    }
                }
                if (response == null) {
                    this.executeSimpleCommand(String.format(Locale.US, "RETR %d", this.mUidToMsgNumMap.get(message.getUid())));
                }
                try {
                    message.parse(new Pop3ResponseInputStream(this.mIn));
                    if (lines == -1 || !((Pop3Store)Pop3Store.this).mCapabilities.top) {
                        message.setFlag(Flag.X_DOWNLOADED_FULL, true);
                    }
                }
                catch (MessagingException me) {
                    if (lines != -1) break block10;
                    throw me;
                }
            }
        }

        @Override
        public Map<String, String> appendMessages(List<? extends Message> messages) throws MessagingException {
            return null;
        }

        @Override
        public void delete(boolean recurse) throws MessagingException {
        }

        @Override
        public void delete(List<? extends Message> msgs, String trashFolderName) throws MessagingException {
            this.setFlags(msgs, Collections.singleton(Flag.DELETED), true);
        }

        @Override
        public String getUidFromMessageId(Message message) throws MessagingException {
            return null;
        }

        @Override
        public void setFlags(Set<Flag> flags, boolean value) throws MessagingException {
            throw new UnsupportedOperationException("POP3: No setFlags(Set<Flag>,boolean)");
        }

        @Override
        public void setFlags(List<? extends Message> messages, Set<Flag> flags, boolean value) throws MessagingException {
            if (!value || !flags.contains((Object)Flag.DELETED)) {
                return;
            }
            ArrayList<String> uids = new ArrayList<String>();
            try {
                for (Message message : messages) {
                    uids.add(message.getUid());
                }
                this.indexUids(uids);
            }
            catch (IOException ioe) {
                throw new MessagingException("Could not get message number for uid " + uids, ioe);
            }
            for (Message message : messages) {
                Integer msgNum = this.mUidToMsgNumMap.get(message.getUid());
                if (msgNum == null) {
                    MessagingException me = new MessagingException("Could not delete message " + message.getUid() + " because no msgNum found; permanent error");
                    me.setPermanentFailure(true);
                    throw me;
                }
                this.executeSimpleCommand(String.format("DELE %s", msgNum));
            }
        }

        private String readLine() throws IOException {
            StringBuilder sb = new StringBuilder();
            int d = this.mIn.read();
            if (d == -1) {
                throw new IOException("End of stream reached while trying to read line.");
            }
            do {
                if ((char)d == '\r') continue;
                if ((char)d == '\n') break;
                sb.append((char)d);
            } while ((d = this.mIn.read()) != -1);
            String ret = sb.toString();
            if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_POP3) {
                Log.d((String)"k9", (String)("<<< " + ret));
            }
            return ret;
        }

        private void writeLine(String s) throws IOException {
            this.mOut.write(s.getBytes());
            this.mOut.write(13);
            this.mOut.write(10);
            this.mOut.flush();
        }

        private Pop3Capabilities getCapabilities() throws IOException {
            String response2;
            Pop3Capabilities capabilities = new Pop3Capabilities();
            try {
                response2 = this.executeSimpleCommand(Pop3Store.AUTH_COMMAND);
                while ((response2 = this.readLine()) != null && !response2.equals(".")) {
                    if ((response2 = response2.toUpperCase(Locale.US)).equals(Pop3Store.AUTH_PLAIN_CAPABILITY)) {
                        capabilities.authPlain = true;
                        continue;
                    }
                    if (response2.equals(Pop3Store.AUTH_CRAM_MD5_CAPABILITY)) {
                        capabilities.cramMD5 = true;
                        continue;
                    }
                    if (!response2.equals(Pop3Store.AUTH_EXTERNAL_CAPABILITY)) continue;
                    capabilities.external = true;
                }
            }
            catch (MessagingException response2) {
                // empty catch block
            }
            try {
                response2 = this.executeSimpleCommand(Pop3Store.CAPA_COMMAND);
                while ((response2 = this.readLine()) != null && !response2.equals(".")) {
                    if ((response2 = response2.toUpperCase(Locale.US)).equals("STLS")) {
                        capabilities.stls = true;
                        continue;
                    }
                    if (response2.equals("UIDL")) {
                        capabilities.uidl = true;
                        continue;
                    }
                    if (response2.equals("TOP")) {
                        capabilities.top = true;
                        continue;
                    }
                    if (!response2.startsWith(Pop3Store.SASL_CAPABILITY)) continue;
                    List<String> saslAuthMechanisms = Arrays.asList(response2.split(" "));
                    if (saslAuthMechanisms.contains(Pop3Store.AUTH_PLAIN_CAPABILITY)) {
                        capabilities.authPlain = true;
                    }
                    if (!saslAuthMechanisms.contains(Pop3Store.AUTH_CRAM_MD5_CAPABILITY)) continue;
                    capabilities.cramMD5 = true;
                }
                if (!capabilities.top) {
                    Pop3Store.this.mTopNotSupported = true;
                }
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            return capabilities;
        }

        private String executeSimpleCommand(String command) throws MessagingException {
            return this.executeSimpleCommand(command, false);
        }

        private String executeSimpleCommand(String command, boolean sensitive) throws MessagingException {
            try {
                String response;
                this.open(0);
                if (command != null) {
                    if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_POP3) {
                        if (sensitive && !K9MailLib.isDebugSensitive()) {
                            Log.d((String)"k9", (String)">>> [Command Hidden, Enable Sensitive Debug Logging To Show]");
                        } else {
                            Log.d((String)"k9", (String)(">>> " + command));
                        }
                    }
                    this.writeLine(command);
                }
                if ((response = this.readLine()).length() == 0 || response.charAt(0) != '+') {
                    throw new Pop3ErrorResponse(response);
                }
                return response;
            }
            catch (MessagingException me) {
                throw me;
            }
            catch (Exception e) {
                this.closeIO();
                throw new MessagingException("Unable to execute POP3 command", e);
            }
        }

        @Override
        public boolean isFlagSupported(Flag flag) {
            return flag == Flag.DELETED;
        }

        @Override
        public boolean supportsFetchingFlags() {
            return false;
        }

        public boolean equals(Object o) {
            if (o instanceof Pop3Folder) {
                return ((Pop3Folder)o).mName.equals(this.mName);
            }
            return super.equals(o);
        }

        public int hashCode() {
            return this.mName.hashCode();
        }
    }
}

