/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import com.fsck.k9.mail.store.imap.ImapList;
import com.fsck.k9.mail.store.imap.ImapResponse;
import com.fsck.k9.mail.store.imap.ImapResponseParser;

class SelectOrExamineResponse {
    private final Boolean readWriteMode;

    private SelectOrExamineResponse(Boolean readWriteMode) {
        this.readWriteMode = readWriteMode;
    }

    public static SelectOrExamineResponse parse(ImapResponse response) {
        if (!response.isTagged() || !ImapResponseParser.equalsIgnoreCase(response.get(0), "OK")) {
            return null;
        }
        if (!response.isList(1)) {
            return SelectOrExamineResponse.noOpenModeInResponse();
        }
        ImapList responseTextList = response.getList(1);
        if (!responseTextList.isString(0)) {
            return SelectOrExamineResponse.noOpenModeInResponse();
        }
        String responseCode = responseTextList.getString(0);
        if ("READ-ONLY".equalsIgnoreCase(responseCode)) {
            return new SelectOrExamineResponse(false);
        }
        if ("READ-WRITE".equalsIgnoreCase(responseCode)) {
            return new SelectOrExamineResponse(true);
        }
        return SelectOrExamineResponse.noOpenModeInResponse();
    }

    private static SelectOrExamineResponse noOpenModeInResponse() {
        return new SelectOrExamineResponse(null);
    }

    public boolean hasOpenMode() {
        return this.readWriteMode != null;
    }

    public int getOpenMode() {
        if (!this.hasOpenMode()) {
            throw new IllegalStateException("Called getOpenMode() despite hasOpenMode() returning false");
        }
        return this.readWriteMode != false ? 0 : 1;
    }
}

