/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import com.fsck.k9.mail.store.imap.ImapResponse;
import com.fsck.k9.mail.store.imap.ImapResponseParser;
import java.util.ArrayList;
import java.util.List;

class SearchResponse {
    private final List<Long> numbers;

    private SearchResponse(List<Long> numbers) {
        this.numbers = numbers;
    }

    public static SearchResponse parse(List<ImapResponse> responses) {
        ArrayList<Long> numbers = new ArrayList<Long>();
        for (ImapResponse response : responses) {
            SearchResponse.parseSingleLine(response, numbers);
        }
        return new SearchResponse(numbers);
    }

    private static void parseSingleLine(ImapResponse response, List<Long> numbers) {
        if (response.isTagged() || response.size() < 2 || !ImapResponseParser.equalsIgnoreCase(response.get(0), "SEARCH")) {
            return;
        }
        int end = response.size();
        for (int i = 1; i < end; ++i) {
            try {
                long number = response.getLong(i);
                numbers.add(number);
                continue;
            }
            catch (NumberFormatException e) {
                return;
            }
        }
    }

    public List<Long> getNumbers() {
        return this.numbers;
    }
}

