/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import com.fsck.k9.mail.Flag;
import com.fsck.k9.mail.store.imap.ImapList;
import com.fsck.k9.mail.store.imap.ImapResponse;
import com.fsck.k9.mail.store.imap.ImapResponseParser;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

class PermanentFlagsResponse {
    private final Set<Flag> flags;
    private final boolean canCreateKeywords;

    private PermanentFlagsResponse(Set<Flag> flags, boolean canCreateKeywords) {
        this.flags = Collections.unmodifiableSet(flags);
        this.canCreateKeywords = canCreateKeywords;
    }

    public static PermanentFlagsResponse parse(ImapResponse response) {
        if (response.isTagged() || !ImapResponseParser.equalsIgnoreCase(response.get(0), "OK") || !response.isList(1)) {
            return null;
        }
        ImapList responseTextList = response.getList(1);
        if (responseTextList.size() < 2 || !ImapResponseParser.equalsIgnoreCase(responseTextList.get(0), "PERMANENTFLAGS") || !responseTextList.isList(1)) {
            return null;
        }
        ImapList permanentFlagsList = responseTextList.getList(1);
        int size = permanentFlagsList.size();
        HashSet<Flag> flags = new HashSet<Flag>(size);
        boolean canCreateKeywords = false;
        block16: for (int i = 0; i < size; ++i) {
            String compareFlag;
            if (!permanentFlagsList.isString(i)) {
                return null;
            }
            String flag = permanentFlagsList.getString(i);
            switch (compareFlag = flag.toLowerCase(Locale.US)) {
                case "\\deleted": {
                    flags.add(Flag.DELETED);
                    continue block16;
                }
                case "\\answered": {
                    flags.add(Flag.ANSWERED);
                    continue block16;
                }
                case "\\seen": {
                    flags.add(Flag.SEEN);
                    continue block16;
                }
                case "\\flagged": {
                    flags.add(Flag.FLAGGED);
                    continue block16;
                }
                case "$forwarded": {
                    flags.add(Flag.FORWARDED);
                    continue block16;
                }
                case "\\*": {
                    canCreateKeywords = true;
                }
            }
        }
        return new PermanentFlagsResponse(flags, canCreateKeywords);
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public boolean canCreateKeywords() {
        return this.canCreateKeywords;
    }
}

