/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import com.fsck.k9.mail.store.imap.ImapList;
import com.fsck.k9.mail.store.imap.ImapResponse;
import com.fsck.k9.mail.store.imap.ImapResponseParser;
import java.util.List;

class NamespaceResponse {
    private String prefix;
    private String hierarchyDelimiter;

    private NamespaceResponse(String prefix, String hierarchyDelimiter) {
        this.prefix = prefix;
        this.hierarchyDelimiter = hierarchyDelimiter;
    }

    public static NamespaceResponse parse(List<ImapResponse> responses) {
        for (ImapResponse response : responses) {
            NamespaceResponse prefix = NamespaceResponse.parse(response);
            if (prefix == null) continue;
            return prefix;
        }
        return null;
    }

    static NamespaceResponse parse(ImapResponse response) {
        if (response.size() < 4 || !ImapResponseParser.equalsIgnoreCase(response.get(0), "NAMESPACE")) {
            return null;
        }
        if (!response.isList(1)) {
            return null;
        }
        ImapList personalNamespaces = response.getList(1);
        if (!personalNamespaces.isList(0)) {
            return null;
        }
        ImapList firstPersonalNamespace = personalNamespaces.getList(0);
        if (!firstPersonalNamespace.isString(0) || !firstPersonalNamespace.isString(1)) {
            return null;
        }
        String prefix = firstPersonalNamespace.getString(0);
        String hierarchyDelimiter = firstPersonalNamespace.getString(1);
        return new NamespaceResponse(prefix, hierarchyDelimiter);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getHierarchyDelimiter() {
        return this.hierarchyDelimiter;
    }
}

