/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import com.fsck.k9.mail.store.imap.ImapList;
import com.fsck.k9.mail.store.imap.ImapResponse;
import com.fsck.k9.mail.store.imap.ImapResponseParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ListResponse {
    private final List<String> attributes;
    private final String hierarchyDelimiter;
    private final String name;

    private ListResponse(List<String> attributes, String hierarchyDelimiter, String name) {
        this.attributes = Collections.unmodifiableList(attributes);
        this.hierarchyDelimiter = hierarchyDelimiter;
        this.name = name;
    }

    public static List<ListResponse> parseList(List<ImapResponse> responses) {
        return ListResponse.parse(responses, "LIST");
    }

    public static List<ListResponse> parseLsub(List<ImapResponse> responses) {
        return ListResponse.parse(responses, "LSUB");
    }

    private static List<ListResponse> parse(List<ImapResponse> responses, String commandResponse) {
        ArrayList<ListResponse> listResponses = new ArrayList<ListResponse>();
        for (ImapResponse response : responses) {
            ListResponse listResponse = ListResponse.parseSingleLine(response, commandResponse);
            if (listResponse == null) continue;
            listResponses.add(listResponse);
        }
        return Collections.unmodifiableList(listResponses);
    }

    private static ListResponse parseSingleLine(ImapResponse response, String commandResponse) {
        if (response.size() < 4 || !ImapResponseParser.equalsIgnoreCase(response.get(0), commandResponse)) {
            return null;
        }
        List<String> attributes = ListResponse.extractAttributes(response);
        if (attributes == null) {
            return null;
        }
        String hierarchyDelimiter = response.getString(2);
        if (hierarchyDelimiter.length() != 1) {
            return null;
        }
        String name = response.getString(3);
        return new ListResponse(attributes, hierarchyDelimiter, name);
    }

    private static List<String> extractAttributes(ImapResponse response) {
        ImapList nameAttributes = response.getList(1);
        ArrayList<String> attributes = new ArrayList<String>(nameAttributes.size());
        for (Object nameAttribute : nameAttributes) {
            if (!(nameAttribute instanceof String)) {
                return null;
            }
            String attribute = (String)nameAttribute;
            attributes.add(attribute);
        }
        return attributes;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String attribute) {
        for (String attributeInResponse : this.attributes) {
            if (!attributeInResponse.equalsIgnoreCase(attribute)) continue;
            return true;
        }
        return false;
    }

    public String getHierarchyDelimiter() {
        return this.hierarchyDelimiter;
    }

    public String getName() {
        return this.name;
    }
}

