/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import android.net.ConnectivityManager;
import android.util.Log;
import com.fsck.k9.mail.AuthType;
import com.fsck.k9.mail.ConnectionSecurity;
import com.fsck.k9.mail.Flag;
import com.fsck.k9.mail.K9MailLib;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.NetworkType;
import com.fsck.k9.mail.PushReceiver;
import com.fsck.k9.mail.Pusher;
import com.fsck.k9.mail.ServerSettings;
import com.fsck.k9.mail.ssl.TrustedSocketFactory;
import com.fsck.k9.mail.store.RemoteStore;
import com.fsck.k9.mail.store.StoreConfig;
import com.fsck.k9.mail.store.imap.FolderNameCodec;
import com.fsck.k9.mail.store.imap.ImapConnection;
import com.fsck.k9.mail.store.imap.ImapFolder;
import com.fsck.k9.mail.store.imap.ImapPusher;
import com.fsck.k9.mail.store.imap.ImapResponse;
import com.fsck.k9.mail.store.imap.ImapSettings;
import com.fsck.k9.mail.store.imap.ImapStoreSettings;
import com.fsck.k9.mail.store.imap.ImapStoreUriCreator;
import com.fsck.k9.mail.store.imap.ImapStoreUriDecoder;
import com.fsck.k9.mail.store.imap.ImapUtility;
import com.fsck.k9.mail.store.imap.ListResponse;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImapStore
extends RemoteStore {
    private Set<Flag> permanentFlagsIndex = EnumSet.noneOf(Flag.class);
    private ConnectivityManager connectivityManager;
    private String host;
    private int port;
    private String username;
    private String password;
    private String clientCertificateAlias;
    private ConnectionSecurity connectionSecurity;
    private AuthType authType;
    private String pathPrefix;
    private String combinedPrefix = null;
    private String pathDelimiter = null;
    private final LinkedList<ImapConnection> connections = new LinkedList();
    private FolderNameCodec folderNameCodec;
    private final Map<String, ImapFolder> folderCache = new HashMap<String, ImapFolder>();

    public static ImapStoreSettings decodeUri(String uri) {
        return ImapStoreUriDecoder.decode(uri);
    }

    public static String createUri(ServerSettings server) {
        return ImapStoreUriCreator.create(server);
    }

    public ImapStore(StoreConfig storeConfig, TrustedSocketFactory trustedSocketFactory, ConnectivityManager connectivityManager) throws MessagingException {
        super(storeConfig, trustedSocketFactory);
        ImapStoreSettings settings;
        try {
            settings = ImapStore.decodeUri(storeConfig.getStoreUri());
        }
        catch (IllegalArgumentException e) {
            throw new MessagingException("Error while decoding store URI", e);
        }
        this.host = settings.host;
        this.port = settings.port;
        this.connectionSecurity = settings.connectionSecurity;
        this.connectivityManager = connectivityManager;
        this.authType = settings.authenticationType;
        this.username = settings.username;
        this.password = settings.password;
        if (this.username == null) {
            throw new MessagingException("username not set");
        }
        if (this.password == null) {
            throw new MessagingException("password not set");
        }
        this.clientCertificateAlias = settings.clientCertificateAlias;
        this.pathPrefix = settings.autoDetectNamespace ? null : settings.pathPrefix;
        this.folderNameCodec = FolderNameCodec.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImapFolder getFolder(String name) {
        ImapFolder folder;
        Map<String, ImapFolder> map = this.folderCache;
        synchronized (map) {
            folder = this.folderCache.get(name);
            if (folder == null) {
                folder = new ImapFolder(this, name);
                this.folderCache.put(name, folder);
            }
        }
        return folder;
    }

    String getCombinedPrefix() {
        if (this.combinedPrefix == null) {
            if (this.pathPrefix != null) {
                String tmpDelim;
                String tmpPrefix = this.pathPrefix.trim();
                String string = tmpDelim = this.pathDelimiter != null ? this.pathDelimiter.trim() : "";
                this.combinedPrefix = tmpPrefix.endsWith(tmpDelim) ? tmpPrefix : (tmpPrefix.length() > 0 ? tmpPrefix + tmpDelim : "");
            } else {
                this.combinedPrefix = "";
            }
        }
        return this.combinedPrefix;
    }

    public List<ImapFolder> getPersonalNamespaces(boolean forceListAll) throws MessagingException {
        ImapConnection connection = this.getConnection();
        try {
            Set<String> folderNames = this.listFolders(connection, false);
            if (forceListAll || !this.mStoreConfig.subscribedFoldersOnly()) {
                List<ImapFolder> list = this.getFolders(folderNames);
                return list;
            }
            Set<String> subscribedFolders = this.listFolders(connection, true);
            folderNames.retainAll(subscribedFolders);
            List<ImapFolder> list = this.getFolders(folderNames);
            return list;
        }
        catch (MessagingException | IOException ioe) {
            connection.close();
            throw new MessagingException("Unable to get folder list.", ioe);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    private Set<String> listFolders(ImapConnection connection, boolean subscribedOnly) throws IOException, MessagingException {
        String commandResponse = subscribedOnly ? "LSUB" : "LIST";
        List<ImapResponse> responses = connection.executeSimpleCommand(String.format("%s \"\" %s", commandResponse, ImapUtility.encodeString(this.getCombinedPrefix() + "*")));
        List<ListResponse> listResponses = subscribedOnly ? ListResponse.parseLsub(responses) : ListResponse.parseList(responses);
        HashSet<String> folderNames = new HashSet<String>(listResponses.size());
        for (ListResponse listResponse : listResponses) {
            String decodedFolderName;
            boolean includeFolder = true;
            try {
                decodedFolderName = this.folderNameCodec.decode(listResponse.getName());
            }
            catch (CharacterCodingException e) {
                Log.w((String)"k9", (String)("Folder name not correctly encoded with the UTF-7 variant as defined by RFC 3501: " + listResponse.getName()), (Throwable)e);
                continue;
            }
            String folder = decodedFolderName;
            if (this.pathDelimiter == null) {
                this.pathDelimiter = listResponse.getHierarchyDelimiter();
                this.combinedPrefix = null;
            }
            if (folder.equalsIgnoreCase(this.mStoreConfig.getInboxFolderName()) || folder.equals(this.mStoreConfig.getOutboxFolderName())) continue;
            int prefixLength = this.getCombinedPrefix().length();
            if (prefixLength > 0) {
                if (folder.length() >= prefixLength) {
                    folder = folder.substring(prefixLength);
                }
                if (!decodedFolderName.equalsIgnoreCase(this.getCombinedPrefix() + folder)) {
                    includeFolder = false;
                }
            }
            if (listResponse.hasAttribute("\\NoSelect")) {
                includeFolder = false;
            }
            if (!includeFolder) continue;
            folderNames.add(folder);
        }
        folderNames.add(this.mStoreConfig.getInboxFolderName());
        return folderNames;
    }

    void autoconfigureFolders(ImapConnection connection) throws IOException, MessagingException {
        if (!connection.hasCapability("SPECIAL-USE")) {
            if (K9MailLib.isDebug()) {
                Log.d((String)"k9", (String)"No detected folder auto-configuration methods.");
            }
            return;
        }
        if (K9MailLib.isDebug()) {
            Log.d((String)"k9", (String)"Folder auto-configuration: Using RFC6154/SPECIAL-USE.");
        }
        String command = String.format("LIST (SPECIAL-USE) \"\" %s", ImapUtility.encodeString(this.getCombinedPrefix() + "*"));
        List<ImapResponse> responses = connection.executeSimpleCommand(command);
        List<ListResponse> listResponses = ListResponse.parseList(responses);
        for (ListResponse listResponse : listResponses) {
            String decodedFolderName;
            try {
                decodedFolderName = this.folderNameCodec.decode(listResponse.getName());
            }
            catch (CharacterCodingException e) {
                Log.w((String)"k9", (String)("Folder name not correctly encoded with the UTF-7 variant as defined by RFC 3501: " + listResponse.getName()), (Throwable)e);
                continue;
            }
            if (this.pathDelimiter == null) {
                this.pathDelimiter = listResponse.getHierarchyDelimiter();
                this.combinedPrefix = null;
            }
            if (listResponse.hasAttribute("\\Archive") || listResponse.hasAttribute("\\All")) {
                this.mStoreConfig.setArchiveFolderName(decodedFolderName);
                if (!K9MailLib.isDebug()) continue;
                Log.d((String)"k9", (String)("Folder auto-configuration detected Archive folder: " + decodedFolderName));
                continue;
            }
            if (listResponse.hasAttribute("\\Drafts")) {
                this.mStoreConfig.setDraftsFolderName(decodedFolderName);
                if (!K9MailLib.isDebug()) continue;
                Log.d((String)"k9", (String)("Folder auto-configuration detected Drafts folder: " + decodedFolderName));
                continue;
            }
            if (listResponse.hasAttribute("\\Sent")) {
                this.mStoreConfig.setSentFolderName(decodedFolderName);
                if (!K9MailLib.isDebug()) continue;
                Log.d((String)"k9", (String)("Folder auto-configuration detected Sent folder: " + decodedFolderName));
                continue;
            }
            if (listResponse.hasAttribute("\\Junk")) {
                this.mStoreConfig.setSpamFolderName(decodedFolderName);
                if (!K9MailLib.isDebug()) continue;
                Log.d((String)"k9", (String)("Folder auto-configuration detected Spam folder: " + decodedFolderName));
                continue;
            }
            if (!listResponse.hasAttribute("\\Trash")) continue;
            this.mStoreConfig.setTrashFolderName(decodedFolderName);
            if (!K9MailLib.isDebug()) continue;
            Log.d((String)"k9", (String)("Folder auto-configuration detected Trash folder: " + decodedFolderName));
        }
    }

    @Override
    public void checkSettings() throws MessagingException {
        try {
            ImapConnection connection = this.createImapConnection();
            connection.open();
            this.autoconfigureFolders(connection);
            connection.close();
        }
        catch (IOException ioe) {
            throw new MessagingException("Unable to connect", ioe);
        }
    }

    ImapConnection getConnection() throws MessagingException {
        ImapConnection connection;
        while ((connection = this.pollConnection()) != null) {
            try {
                connection.executeSimpleCommand("NOOP");
                break;
            }
            catch (IOException ioe) {
                connection.close();
            }
        }
        if (connection == null) {
            connection = this.createImapConnection();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImapConnection pollConnection() {
        LinkedList<ImapConnection> linkedList = this.connections;
        synchronized (linkedList) {
            return this.connections.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection(ImapConnection connection) {
        if (connection != null && connection.isConnected()) {
            LinkedList<ImapConnection> linkedList = this.connections;
            synchronized (linkedList) {
                this.connections.offer(connection);
            }
        }
    }

    ImapConnection createImapConnection() {
        return new ImapConnection(new StoreImapSettings(), this.mTrustedSocketFactory, this.connectivityManager);
    }

    FolderNameCodec getFolderNameCodec() {
        return this.folderNameCodec;
    }

    private List<ImapFolder> getFolders(Collection<String> folderNames) {
        ArrayList<ImapFolder> folders = new ArrayList<ImapFolder>(folderNames.size());
        for (String folderName : folderNames) {
            ImapFolder imapFolder = this.getFolder(folderName);
            folders.add(imapFolder);
        }
        return folders;
    }

    @Override
    public boolean isMoveCapable() {
        return true;
    }

    @Override
    public boolean isCopyCapable() {
        return true;
    }

    @Override
    public boolean isPushCapable() {
        return true;
    }

    @Override
    public boolean isExpungeCapable() {
        return true;
    }

    StoreConfig getStoreConfig() {
        return this.mStoreConfig;
    }

    Set<Flag> getPermanentFlagsIndex() {
        return this.permanentFlagsIndex;
    }

    @Override
    public Pusher getPusher(PushReceiver receiver) {
        return new ImapPusher(this, receiver);
    }

    private class StoreImapSettings
    implements ImapSettings {
        private StoreImapSettings() {
        }

        @Override
        public String getHost() {
            return ImapStore.this.host;
        }

        @Override
        public int getPort() {
            return ImapStore.this.port;
        }

        @Override
        public ConnectionSecurity getConnectionSecurity() {
            return ImapStore.this.connectionSecurity;
        }

        @Override
        public AuthType getAuthType() {
            return ImapStore.this.authType;
        }

        @Override
        public String getUsername() {
            return ImapStore.this.username;
        }

        @Override
        public String getPassword() {
            return ImapStore.this.password;
        }

        @Override
        public String getClientCertificateAlias() {
            return ImapStore.this.clientCertificateAlias;
        }

        @Override
        public boolean useCompression(NetworkType type) {
            return ImapStore.this.mStoreConfig.useCompression(type);
        }

        @Override
        public String getPathPrefix() {
            return ImapStore.this.pathPrefix;
        }

        @Override
        public void setPathPrefix(String prefix) {
            ImapStore.this.pathPrefix = prefix;
        }

        @Override
        public String getPathDelimiter() {
            return ImapStore.this.pathDelimiter;
        }

        @Override
        public void setPathDelimiter(String delimiter) {
            ImapStore.this.pathDelimiter = delimiter;
        }

        @Override
        public String getCombinedPrefix() {
            return ImapStore.this.combinedPrefix;
        }

        @Override
        public void setCombinedPrefix(String prefix) {
            ImapStore.this.combinedPrefix = prefix;
        }
    }
}

