/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import android.util.Log;
import com.fsck.k9.mail.K9MailLib;
import com.fsck.k9.mail.PushReceiver;
import com.fsck.k9.mail.Pusher;
import com.fsck.k9.mail.store.imap.ImapFolderPusher;
import com.fsck.k9.mail.store.imap.ImapStore;
import java.util.ArrayList;
import java.util.List;

class ImapPusher
implements Pusher {
    private final ImapStore store;
    private final PushReceiver pushReceiver;
    private final List<ImapFolderPusher> folderPushers = new ArrayList<ImapFolderPusher>();
    private long lastRefresh = -1L;

    public ImapPusher(ImapStore store, PushReceiver pushReceiver) {
        this.store = store;
        this.pushReceiver = pushReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(List<String> folderNames) {
        List<ImapFolderPusher> list = this.folderPushers;
        synchronized (list) {
            this.stop();
            this.setLastRefresh(this.currentTimeMillis());
            for (String folderName : folderNames) {
                ImapFolderPusher pusher = this.createImapFolderPusher(folderName);
                this.folderPushers.add(pusher);
                pusher.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        List<ImapFolderPusher> list = this.folderPushers;
        synchronized (list) {
            for (ImapFolderPusher folderPusher : this.folderPushers) {
                try {
                    folderPusher.refresh();
                }
                catch (Exception e) {
                    Log.e((String)"k9", (String)("Got exception while refreshing for " + folderPusher.getName()), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (K9MailLib.isDebug()) {
            Log.i((String)"k9", (String)"Requested stop of IMAP pusher");
        }
        List<ImapFolderPusher> list = this.folderPushers;
        synchronized (list) {
            for (ImapFolderPusher folderPusher : this.folderPushers) {
                try {
                    if (K9MailLib.isDebug()) {
                        Log.i((String)"k9", (String)("Requesting stop of IMAP folderPusher " + folderPusher.getName()));
                    }
                    folderPusher.stop();
                }
                catch (Exception e) {
                    Log.e((String)"k9", (String)("Got exception while stopping " + folderPusher.getName()), (Throwable)e);
                }
            }
            this.folderPushers.clear();
        }
    }

    @Override
    public int getRefreshInterval() {
        return this.store.getStoreConfig().getIdleRefreshMinutes() * 60 * 1000;
    }

    @Override
    public long getLastRefresh() {
        return this.lastRefresh;
    }

    @Override
    public void setLastRefresh(long lastRefresh) {
        this.lastRefresh = lastRefresh;
    }

    ImapFolderPusher createImapFolderPusher(String folderName) {
        return new ImapFolderPusher(this.store, folderName, this.pushReceiver);
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

