/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.store.imap.ImapResponseParser;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

class ImapList
extends ArrayList<Object> {
    private static final long serialVersionUID = -4067248341419617583L;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss Z", Locale.US);
    private static final DateFormat BAD_DATE_TIME_FORMAT = new SimpleDateFormat("dd MMM yyyy HH:mm:ss Z", Locale.US);
    private static final DateFormat BAD_DATE_TIME_FORMAT_2 = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z", Locale.US);
    private static final DateFormat BAD_DATE_TIME_FORMAT_3 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.US);

    ImapList() {
    }

    public ImapList getList(int index) {
        return (ImapList)this.get(index);
    }

    public boolean isList(int index) {
        return this.inRange(index) && this.get(index) instanceof ImapList;
    }

    public Object getObject(int index) {
        return this.get(index);
    }

    public String getString(int index) {
        return (String)this.get(index);
    }

    public boolean isString(int index) {
        return this.inRange(index) && this.get(index) instanceof String;
    }

    public long getLong(int index) {
        return Long.parseLong(this.getString(index));
    }

    public int getNumber(int index) {
        return Integer.parseInt(this.getString(index));
    }

    public Date getDate(int index) throws MessagingException {
        return this.getDate(this.getString(index));
    }

    public Date getKeyedDate(String key) throws MessagingException {
        return this.getDate(this.getKeyedString(key));
    }

    private Date getDate(String value) throws MessagingException {
        try {
            if (value == null) {
                return null;
            }
            return this.parseDate(value);
        }
        catch (ParseException pe) {
            throw new MessagingException("Unable to parse IMAP datetime '" + value + "' ", pe);
        }
    }

    public Object getKeyedValue(String key) {
        int count = this.size() - 1;
        for (int i = 0; i < count; ++i) {
            if (!ImapResponseParser.equalsIgnoreCase(this.get(i), key)) continue;
            return this.get(i + 1);
        }
        return null;
    }

    public ImapList getKeyedList(String key) {
        return (ImapList)this.getKeyedValue(key);
    }

    public String getKeyedString(String key) {
        return (String)this.getKeyedValue(key);
    }

    public int getKeyedNumber(String key) {
        return Integer.parseInt(this.getKeyedString(key));
    }

    public boolean containsKey(String key) {
        if (key == null) {
            return false;
        }
        int count = this.size() - 1;
        for (int i = 0; i < count; ++i) {
            if (!ImapResponseParser.equalsIgnoreCase(this.get(i), key)) continue;
            return true;
        }
        return false;
    }

    public int getKeyIndex(String key) {
        int count = this.size() - 1;
        for (int i = 0; i < count; ++i) {
            if (!ImapResponseParser.equalsIgnoreCase(this.get(i), key)) continue;
            return i;
        }
        throw new IllegalArgumentException("getKeyIndex() only works for keys that are in the collection.");
    }

    private boolean inRange(int index) {
        return index >= 0 && index < this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date parseDate(String value) throws ParseException {
        try {
            DateFormat dateFormat = DATE_FORMAT;
            synchronized (dateFormat) {
                return DATE_FORMAT.parse(value);
            }
        }
        catch (Exception e) {
            try {
                DateFormat dateFormat = BAD_DATE_TIME_FORMAT;
                synchronized (dateFormat) {
                    return BAD_DATE_TIME_FORMAT.parse(value);
                }
            }
            catch (Exception e2) {
                try {
                    DateFormat dateFormat = BAD_DATE_TIME_FORMAT_2;
                    synchronized (dateFormat) {
                        return BAD_DATE_TIME_FORMAT_2.parse(value);
                    }
                }
                catch (Exception e3) {
                    DateFormat dateFormat = BAD_DATE_TIME_FORMAT_3;
                    synchronized (dateFormat) {
                        return BAD_DATE_TIME_FORMAT_3.parse(value);
                    }
                }
            }
        }
    }
}

