/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import android.text.TextUtils;
import android.util.Log;
import com.fsck.k9.mail.Body;
import com.fsck.k9.mail.FetchProfile;
import com.fsck.k9.mail.Flag;
import com.fsck.k9.mail.Folder;
import com.fsck.k9.mail.K9MailLib;
import com.fsck.k9.mail.Message;
import com.fsck.k9.mail.MessageRetrievalListener;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.Part;
import com.fsck.k9.mail.filter.EOLConvertingOutputStream;
import com.fsck.k9.mail.internet.MimeBodyPart;
import com.fsck.k9.mail.internet.MimeMessageHelper;
import com.fsck.k9.mail.internet.MimeMultipart;
import com.fsck.k9.mail.internet.MimeUtility;
import com.fsck.k9.mail.store.imap.CopyUidResponse;
import com.fsck.k9.mail.store.imap.FetchBodyCallback;
import com.fsck.k9.mail.store.imap.FetchPartCallback;
import com.fsck.k9.mail.store.imap.FolderNameCodec;
import com.fsck.k9.mail.store.imap.ImapConnection;
import com.fsck.k9.mail.store.imap.ImapList;
import com.fsck.k9.mail.store.imap.ImapMessage;
import com.fsck.k9.mail.store.imap.ImapPushState;
import com.fsck.k9.mail.store.imap.ImapResponse;
import com.fsck.k9.mail.store.imap.ImapResponseParser;
import com.fsck.k9.mail.store.imap.ImapSearcher;
import com.fsck.k9.mail.store.imap.ImapStore;
import com.fsck.k9.mail.store.imap.ImapUtility;
import com.fsck.k9.mail.store.imap.NegativeImapResponseException;
import com.fsck.k9.mail.store.imap.PermanentFlagsResponse;
import com.fsck.k9.mail.store.imap.SearchResponse;
import com.fsck.k9.mail.store.imap.SelectOrExamineResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ImapFolder
extends Folder<ImapMessage> {
    protected static final ThreadLocal<SimpleDateFormat> RFC3501_DATE = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
        }
    };
    protected static final ThreadLocal<SimpleDateFormat> INTERNAL_DATE = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss Z", Locale.US);
        }
    };
    private static final int MORE_MESSAGES_WINDOW_SIZE = 500;
    private static final int FETCH_WINDOW_SIZE = 100;
    protected volatile int messageCount = -1;
    protected volatile long uidNext = -1L;
    protected volatile ImapConnection connection;
    protected ImapStore store = null;
    protected Map<Long, String> msgSeqUidMap = new ConcurrentHashMap<Long, String>();
    private final FolderNameCodec folderNameCodec;
    private final String name;
    private int mode;
    private volatile boolean exists;
    private boolean inSearch = false;
    private boolean canCreateKeywords = false;

    public ImapFolder(ImapStore store, String name) {
        this(store, name, store.getFolderNameCodec());
    }

    ImapFolder(ImapStore store, String name, FolderNameCodec folderNameCodec) {
        this.store = store;
        this.name = name;
        this.folderNameCodec = folderNameCodec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPrefixedName() throws MessagingException {
        String prefixedName = "";
        if (!this.store.getStoreConfig().getInboxFolderName().equalsIgnoreCase(this.name)) {
            ImapConnection connection;
            ImapFolder imapFolder = this;
            synchronized (imapFolder) {
                connection = this.connection == null ? this.store.getConnection() : this.connection;
            }
            try {
                connection.open();
            }
            catch (IOException ioe) {
                throw new MessagingException("Unable to get IMAP prefix", ioe);
            }
            finally {
                if (this.connection == null) {
                    this.store.releaseConnection(connection);
                }
            }
            prefixedName = this.store.getCombinedPrefix();
        }
        prefixedName = prefixedName + this.name;
        return prefixedName;
    }

    protected List<ImapResponse> executeSimpleCommand(String command) throws MessagingException, IOException {
        return this.handleUntaggedResponses(this.connection.executeSimpleCommand(command));
    }

    @Override
    public void open(int mode) throws MessagingException {
        this.internalOpen(mode);
        if (this.messageCount == -1) {
            throw new MessagingException("Did not find message count during open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ImapResponse> internalOpen(int mode) throws MessagingException {
        if (this.isOpen() && this.mode == mode) {
            try {
                return this.executeSimpleCommand("NOOP");
            }
            catch (IOException ioe) {
                this.ioExceptionHandler(this.connection, ioe);
            }
        }
        this.store.releaseConnection(this.connection);
        ImapFolder ioe = this;
        synchronized (ioe) {
            this.connection = this.store.getConnection();
        }
        try {
            this.msgSeqUidMap.clear();
            String openCommand = mode == 0 ? "SELECT" : "EXAMINE";
            String encodedFolderName = this.folderNameCodec.encode(this.getPrefixedName());
            String escapedFolderName = ImapUtility.encodeString(encodedFolderName);
            String command = String.format("%s %s", openCommand, escapedFolderName);
            List<ImapResponse> responses = this.executeSimpleCommand(command);
            this.mode = mode;
            for (ImapResponse response : responses) {
                this.handlePermanentFlags(response);
            }
            this.handleSelectOrExamineOkResponse(ImapUtility.getLastResponse(responses));
            this.exists = true;
            return responses;
        }
        catch (IOException ioe2) {
            throw this.ioExceptionHandler(this.connection, ioe2);
        }
        catch (MessagingException me) {
            Log.e((String)"k9", (String)("Unable to open connection for " + this.getLogId()), (Throwable)me);
            throw me;
        }
    }

    private void handlePermanentFlags(ImapResponse response) {
        PermanentFlagsResponse permanentFlagsResponse = PermanentFlagsResponse.parse(response);
        if (permanentFlagsResponse == null) {
            return;
        }
        Set<Flag> permanentFlags = this.store.getPermanentFlagsIndex();
        permanentFlags.addAll(permanentFlagsResponse.getFlags());
        this.canCreateKeywords = permanentFlagsResponse.canCreateKeywords();
    }

    private void handleSelectOrExamineOkResponse(ImapResponse response) {
        SelectOrExamineResponse selectOrExamineResponse = SelectOrExamineResponse.parse(response);
        if (selectOrExamineResponse == null) {
            return;
        }
        if (selectOrExamineResponse.hasOpenMode()) {
            this.mode = selectOrExamineResponse.getOpenMode();
        }
    }

    @Override
    public boolean isOpen() {
        return this.connection != null;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.messageCount = -1;
        if (!this.isOpen()) {
            return;
        }
        ImapFolder imapFolder = this;
        synchronized (imapFolder) {
            if (this.inSearch && this.connection != null) {
                Log.i((String)"k9", (String)"IMAP search was aborted, shutting down connection.");
                this.connection.close();
            } else {
                this.store.releaseConnection(this.connection);
            }
            this.connection = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private boolean exists(String escapedFolderName) throws MessagingException {
        try {
            this.connection.executeSimpleCommand(String.format("STATUS %s (RECENT)", escapedFolderName));
            return true;
        }
        catch (IOException ioe) {
            throw this.ioExceptionHandler(this.connection, ioe);
        }
        catch (NegativeImapResponseException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() throws MessagingException {
        ImapConnection connection;
        if (this.exists) {
            return true;
        }
        ImapFolder imapFolder = this;
        synchronized (imapFolder) {
            connection = this.connection == null ? this.store.getConnection() : this.connection;
        }
        try {
            String encodedFolderName = this.folderNameCodec.encode(this.getPrefixedName());
            String escapedFolderName = ImapUtility.encodeString(encodedFolderName);
            connection.executeSimpleCommand(String.format("STATUS %s (UIDVALIDITY)", escapedFolderName));
            this.exists = true;
            boolean bl = true;
            return bl;
        }
        catch (NegativeImapResponseException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            throw this.ioExceptionHandler(connection, ioe);
        }
        finally {
            if (this.connection == null) {
                this.store.releaseConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(Folder.FolderType type) throws MessagingException {
        ImapConnection connection;
        ImapFolder imapFolder = this;
        synchronized (imapFolder) {
            connection = this.connection == null ? this.store.getConnection() : this.connection;
        }
        try {
            String encodedFolderName = this.folderNameCodec.encode(this.getPrefixedName());
            String escapedFolderName = ImapUtility.encodeString(encodedFolderName);
            connection.executeSimpleCommand(String.format("CREATE %s", escapedFolderName));
            boolean bl = true;
            return bl;
        }
        catch (NegativeImapResponseException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            throw this.ioExceptionHandler(this.connection, ioe);
        }
        finally {
            if (this.connection == null) {
                this.store.releaseConnection(connection);
            }
        }
    }

    @Override
    public Map<String, String> copyMessages(List<? extends Message> messages, Folder folder) throws MessagingException {
        if (!(folder instanceof ImapFolder)) {
            throw new MessagingException("ImapFolder.copyMessages passed non-ImapFolder");
        }
        if (messages.isEmpty()) {
            return null;
        }
        ImapFolder imapFolder = (ImapFolder)folder;
        this.checkOpen();
        Object[] uids = new String[messages.size()];
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            uids[i] = messages.get(i).getUid();
        }
        try {
            List<ImapResponse> responses;
            ImapResponse response;
            CopyUidResponse copyUidResponse;
            String encodedDestinationFolderName = this.folderNameCodec.encode(imapFolder.getPrefixedName());
            String escapedDestinationFolderName = ImapUtility.encodeString(encodedDestinationFolderName);
            if (!this.exists(escapedDestinationFolderName)) {
                if (K9MailLib.isDebug()) {
                    Log.i((String)"k9", (String)("ImapFolder.copyMessages: attempting to create remote folder '" + escapedDestinationFolderName + "' for " + this.getLogId()));
                }
                imapFolder.create(Folder.FolderType.HOLDS_MESSAGES);
            }
            if ((copyUidResponse = CopyUidResponse.parse(response = ImapUtility.getLastResponse(responses = this.executeSimpleCommand(String.format("UID COPY %s %s", ImapFolder.combine(uids, ','), escapedDestinationFolderName))))) == null) {
                return null;
            }
            return copyUidResponse.getUidMapping();
        }
        catch (IOException ioe) {
            throw this.ioExceptionHandler(this.connection, ioe);
        }
    }

    @Override
    public Map<String, String> moveMessages(List<? extends Message> messages, Folder folder) throws MessagingException {
        if (messages.isEmpty()) {
            return null;
        }
        Map<String, String> uidMapping = this.copyMessages(messages, folder);
        this.setFlags(messages, Collections.singleton(Flag.DELETED), true);
        return uidMapping;
    }

    @Override
    public void delete(List<? extends Message> messages, String trashFolderName) throws MessagingException {
        if (messages.isEmpty()) {
            return;
        }
        if (trashFolderName == null || this.getName().equalsIgnoreCase(trashFolderName)) {
            this.setFlags(messages, Collections.singleton(Flag.DELETED), true);
        } else {
            ImapFolder remoteTrashFolder = this.getStore().getFolder(trashFolderName);
            String encodedTrashFolderName = this.folderNameCodec.encode(remoteTrashFolder.getPrefixedName());
            String escapedTrashFolderName = ImapUtility.encodeString(encodedTrashFolderName);
            if (!this.exists(escapedTrashFolderName)) {
                if (K9MailLib.isDebug()) {
                    Log.i((String)"k9", (String)("IMAPMessage.delete: attempting to create remote '" + trashFolderName + "' folder for " + this.getLogId()));
                }
                remoteTrashFolder.create(Folder.FolderType.HOLDS_MESSAGES);
            }
            if (this.exists(escapedTrashFolderName)) {
                if (K9MailLib.isDebug()) {
                    Log.d((String)"k9", (String)("IMAPMessage.delete: copying remote " + messages.size() + " messages to '" + trashFolderName + "' for " + this.getLogId()));
                }
                this.moveMessages(messages, remoteTrashFolder);
            } else {
                throw new MessagingException("IMAPMessage.delete: remote Trash folder " + trashFolderName + " does not exist and could not be created for " + this.getLogId(), true);
            }
        }
    }

    @Override
    public int getMessageCount() {
        return this.messageCount;
    }

    private int getRemoteMessageCount(String criteria) throws MessagingException {
        this.checkOpen();
        try {
            int count = 0;
            int start = 1;
            String command = String.format(Locale.US, "SEARCH %d:* %s", start, criteria);
            List<ImapResponse> responses = this.executeSimpleCommand(command);
            for (ImapResponse response : responses) {
                if (!ImapResponseParser.equalsIgnoreCase(response.get(0), "SEARCH")) continue;
                count += response.size() - 1;
            }
            return count;
        }
        catch (IOException ioe) {
            throw this.ioExceptionHandler(this.connection, ioe);
        }
    }

    @Override
    public int getUnreadMessageCount() throws MessagingException {
        return this.getRemoteMessageCount("UNSEEN NOT DELETED");
    }

    @Override
    public int getFlaggedMessageCount() throws MessagingException {
        return this.getRemoteMessageCount("FLAGGED NOT DELETED");
    }

    protected long getHighestUid() throws MessagingException {
        try {
            String command = "UID SEARCH *:*";
            List<ImapResponse> responses = this.executeSimpleCommand(command);
            SearchResponse searchResponse = SearchResponse.parse(responses);
            return this.extractHighestUid(searchResponse);
        }
        catch (NegativeImapResponseException e) {
            return -1L;
        }
        catch (IOException ioe) {
            throw this.ioExceptionHandler(this.connection, ioe);
        }
    }

    private long extractHighestUid(SearchResponse searchResponse) {
        List<Long> uids = searchResponse.getNumbers();
        if (uids.isEmpty()) {
            return -1L;
        }
        if (uids.size() == 1) {
            return uids.get(0);
        }
        Collections.sort(uids, Collections.reverseOrder());
        return uids.get(0);
    }

    @Override
    public void delete(boolean recurse) throws MessagingException {
        throw new Error("ImapFolder.delete() not yet implemented");
    }

    @Override
    public ImapMessage getMessage(String uid) throws MessagingException {
        return new ImapMessage(uid, this);
    }

    @Override
    public List<ImapMessage> getMessages(int start, int end, Date earliestDate, MessageRetrievalListener<ImapMessage> listener) throws MessagingException {
        return this.getMessages(start, end, earliestDate, false, listener);
    }

    protected List<ImapMessage> getMessages(final int start, final int end, Date earliestDate, final boolean includeDeleted, MessageRetrievalListener<ImapMessage> listener) throws MessagingException {
        if (start < 1 || end < 1 || end < start) {
            throw new MessagingException(String.format(Locale.US, "Invalid message set %d %d", start, end));
        }
        final String dateSearchString = this.getDateSearchString(earliestDate);
        ImapSearcher searcher = new ImapSearcher(){

            @Override
            public List<ImapResponse> search() throws IOException, MessagingException {
                String command = String.format(Locale.US, "UID SEARCH %d:%d%s%s", start, end, dateSearchString, includeDeleted ? "" : " NOT DELETED");
                return ImapFolder.this.executeSimpleCommand(command);
            }
        };
        return this.search(searcher, listener);
    }

    private String getDateSearchString(Date earliestDate) {
        if (earliestDate == null) {
            return "";
        }
        return " SINCE " + RFC3501_DATE.get().format(earliestDate);
    }

    @Override
    public boolean areMoreMessagesAvailable(int indexOfOldestMessage, Date earliestDate) throws IOException, MessagingException {
        this.checkOpen();
        if (indexOfOldestMessage == 1) {
            return false;
        }
        String dateSearchString = this.getDateSearchString(earliestDate);
        for (int endIndex = indexOfOldestMessage - 1; endIndex > 0; endIndex -= 500) {
            int startIndex = Math.max(0, endIndex - 500) + 1;
            if (!this.existsNonDeletedMessageInRange(startIndex, endIndex, dateSearchString)) continue;
            return true;
        }
        return false;
    }

    private boolean existsNonDeletedMessageInRange(int startIndex, int endIndex, String dateSearchString) throws MessagingException, IOException {
        String command = String.format(Locale.US, "SEARCH %d:%d%s NOT DELETED", startIndex, endIndex, dateSearchString);
        List<ImapResponse> responses = this.executeSimpleCommand(command);
        for (ImapResponse response : responses) {
            if (response.getTag() != null || !ImapResponseParser.equalsIgnoreCase(response.get(0), "SEARCH") || response.size() <= 1) continue;
            return true;
        }
        return false;
    }

    protected List<ImapMessage> getMessages(final List<Long> mesgSeqs, final boolean includeDeleted, MessageRetrievalListener<ImapMessage> listener) throws MessagingException {
        ImapSearcher searcher = new ImapSearcher(){

            @Override
            public List<ImapResponse> search() throws IOException, MessagingException {
                String command = String.format("UID SEARCH %s%s", ImapFolder.combine(mesgSeqs.toArray(), ','), includeDeleted ? "" : " NOT DELETED");
                return ImapFolder.this.executeSimpleCommand(command);
            }
        };
        return this.search(searcher, listener);
    }

    protected List<ImapMessage> getMessagesFromUids(final List<String> mesgUids) throws MessagingException {
        ImapSearcher searcher = new ImapSearcher(){

            @Override
            public List<ImapResponse> search() throws IOException, MessagingException {
                String command = String.format("UID SEARCH UID %s", ImapFolder.combine(mesgUids.toArray(), ','));
                return ImapFolder.this.executeSimpleCommand(command);
            }
        };
        return this.search(searcher, null);
    }

    protected List<ImapMessage> search(ImapSearcher searcher, MessageRetrievalListener<ImapMessage> listener) throws MessagingException {
        this.checkOpen();
        ArrayList<ImapMessage> messages = new ArrayList<ImapMessage>();
        try {
            List<ImapResponse> responses = searcher.search();
            SearchResponse searchResponse = SearchResponse.parse(responses);
            List<Long> uids = searchResponse.getNumbers();
            Collections.sort(uids, Collections.reverseOrder());
            int count = uids.size();
            for (int i = 0; i < count; ++i) {
                String uid = uids.get(i).toString();
                if (listener != null) {
                    listener.messageStarted(uid, i, count);
                }
                ImapMessage message = new ImapMessage(uid, this);
                messages.add(message);
                if (listener == null) continue;
                listener.messageFinished(message, i, count);
            }
        }
        catch (IOException ioe) {
            throw this.ioExceptionHandler(this.connection, ioe);
        }
        return messages;
    }

    @Override
    public void fetch(List<ImapMessage> messages, FetchProfile fetchProfile, MessageRetrievalListener<ImapMessage> listener) throws MessagingException {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        this.checkOpen();
        ArrayList<String> uids = new ArrayList<String>(messages.size());
        HashMap<String, Message> messageMap = new HashMap<String, Message>();
        for (Message message : messages) {
            String uid = message.getUid();
            uids.add(uid);
            messageMap.put(uid, message);
        }
        LinkedHashSet<String> fetchFields = new LinkedHashSet<String>();
        fetchFields.add("UID");
        if (fetchProfile.contains((Object)FetchProfile.Item.FLAGS)) {
            fetchFields.add("FLAGS");
        }
        if (fetchProfile.contains((Object)FetchProfile.Item.ENVELOPE)) {
            fetchFields.add("INTERNALDATE");
            fetchFields.add("RFC822.SIZE");
            fetchFields.add("BODY.PEEK[HEADER.FIELDS (date subject from content-type to cc reply-to message-id references in-reply-to X-K9mail-Identity)]");
        }
        if (fetchProfile.contains((Object)FetchProfile.Item.STRUCTURE)) {
            fetchFields.add("BODYSTRUCTURE");
        }
        if (fetchProfile.contains((Object)FetchProfile.Item.BODY_SANE)) {
            int n = this.store.getStoreConfig().getMaximumAutoDownloadMessageSize();
            if (n > 0) {
                fetchFields.add(String.format(Locale.US, "BODY.PEEK[]<0.%d>", n));
            } else {
                fetchFields.add("BODY.PEEK[]");
            }
        }
        if (fetchProfile.contains((Object)FetchProfile.Item.BODY)) {
            fetchFields.add("BODY.PEEK[]");
        }
        if (fetchProfile.contains((Object)FetchProfile.Item.DATE)) {
            fetchFields.add("BODY.PEEK[HEADER.FIELDS (date)]");
        }
        String string = ImapFolder.combine(fetchFields.toArray(new String[fetchFields.size()]), ' ');
        for (int windowStart = 0; windowStart < messages.size(); windowStart += 100) {
            int windowEnd = Math.min(windowStart + 100, messages.size());
            List uidWindow = uids.subList(windowStart, windowEnd);
            try {
                ImapResponse response;
                String commaSeparatedUids = ImapFolder.combine(uidWindow.toArray(new String[uidWindow.size()]), ',');
                String command = String.format("UID FETCH %s (%s)", commaSeparatedUids, string);
                this.connection.sendCommand(command, false);
                int messageNumber = 0;
                FetchBodyCallback callback = null;
                if (fetchProfile.contains((Object)FetchProfile.Item.BODY) || fetchProfile.contains((Object)FetchProfile.Item.BODY_SANE) || fetchProfile.contains((Object)FetchProfile.Item.DATE)) {
                    callback = new FetchBodyCallback(messageMap);
                }
                do {
                    if ((response = this.connection.readResponse(callback)).getTag() == null && ImapResponseParser.equalsIgnoreCase(response.get(1), "FETCH")) {
                        ImapMessage imapMessage;
                        Object literal;
                        Message message;
                        ImapList fetchList = (ImapList)response.getKeyedValue("FETCH");
                        String uid = fetchList.getKeyedString("UID");
                        long msgSeq = response.getLong(0);
                        if (uid != null) {
                            try {
                                this.msgSeqUidMap.put(msgSeq, uid);
                                if (K9MailLib.isDebug()) {
                                    Log.v((String)"k9", (String)("Stored uid '" + uid + "' for msgSeq " + msgSeq + " into map"));
                                }
                            }
                            catch (Exception e) {
                                Log.e((String)"k9", (String)("Unable to store uid '" + uid + "' for msgSeq " + msgSeq));
                            }
                        }
                        if ((message = messageMap.get(uid)) == null) {
                            if (K9MailLib.isDebug()) {
                                Log.d((String)"k9", (String)("Do not have message in messageMap for UID " + uid + " for " + this.getLogId()));
                            }
                            this.handleUntaggedResponse(response);
                            continue;
                        }
                        if (listener != null) {
                            listener.messageStarted(uid, messageNumber++, messageMap.size());
                        }
                        if ((literal = this.handleFetchResponse(imapMessage = (ImapMessage)message, fetchList)) != null) {
                            if (literal instanceof String) {
                                String bodyString = (String)literal;
                                ByteArrayInputStream bodyStream = new ByteArrayInputStream(bodyString.getBytes());
                                imapMessage.parse(bodyStream);
                            } else if (!(literal instanceof Integer)) {
                                throw new MessagingException("Got FETCH response with bogus parameters");
                            }
                        }
                        if (listener == null) continue;
                        listener.messageFinished(imapMessage, messageNumber, messageMap.size());
                        continue;
                    }
                    this.handleUntaggedResponse(response);
                } while (response.getTag() == null);
                continue;
            }
            catch (IOException ioe) {
                throw this.ioExceptionHandler(this.connection, ioe);
            }
        }
    }

    @Override
    public void fetchPart(Message message, Part part, MessageRetrievalListener<Message> listener) throws MessagingException {
        String fetch;
        this.checkOpen();
        String partId = part.getServerExtra();
        if ("TEXT".equalsIgnoreCase(partId)) {
            int maximumAutoDownloadMessageSize = this.store.getStoreConfig().getMaximumAutoDownloadMessageSize();
            fetch = String.format(Locale.US, "BODY.PEEK[TEXT]<0.%d>", maximumAutoDownloadMessageSize);
        } else {
            fetch = String.format("BODY.PEEK[%s]", partId);
        }
        try {
            ImapResponse response;
            String command = String.format("UID FETCH %s (UID %s)", message.getUid(), fetch);
            this.connection.sendCommand(command, false);
            int messageNumber = 0;
            FetchPartCallback callback = new FetchPartCallback(part);
            do {
                if ((response = this.connection.readResponse(callback)).getTag() == null && ImapResponseParser.equalsIgnoreCase(response.get(1), "FETCH")) {
                    ImapMessage imapMessage;
                    Object literal;
                    ImapList fetchList = (ImapList)response.getKeyedValue("FETCH");
                    String uid = fetchList.getKeyedString("UID");
                    if (!message.getUid().equals(uid)) {
                        if (K9MailLib.isDebug()) {
                            Log.d((String)"k9", (String)("Did not ask for UID " + uid + " for " + this.getLogId()));
                        }
                        this.handleUntaggedResponse(response);
                        continue;
                    }
                    if (listener != null) {
                        listener.messageStarted(uid, messageNumber++, 1);
                    }
                    if ((literal = this.handleFetchResponse(imapMessage = (ImapMessage)message, fetchList)) != null) {
                        if (literal instanceof Body) {
                            MimeMessageHelper.setBody(part, (Body)literal);
                        } else if (literal instanceof String) {
                            String bodyString = (String)literal;
                            ByteArrayInputStream bodyStream = new ByteArrayInputStream(bodyString.getBytes());
                            String contentTransferEncoding = part.getHeader("Content-Transfer-Encoding")[0];
                            String contentType = part.getHeader("Content-Type")[0];
                            MimeMessageHelper.setBody(part, MimeUtility.createBody(bodyStream, contentTransferEncoding, contentType));
                        } else {
                            throw new MessagingException("Got FETCH response with bogus parameters");
                        }
                    }
                    if (listener == null) continue;
                    listener.messageFinished(message, messageNumber, 1);
                    continue;
                }
                this.handleUntaggedResponse(response);
            } while (response.getTag() == null);
        }
        catch (IOException ioe) {
            throw this.ioExceptionHandler(this.connection, ioe);
        }
    }

    private Object handleFetchResponse(ImapMessage message, ImapList fetchList) throws MessagingException {
        String originOctet;
        int size;
        int index;
        ImapList bs;
        ImapList flags;
        Object result = null;
        if (fetchList.containsKey("FLAGS") && (flags = fetchList.getKeyedList("FLAGS")) != null) {
            int count = flags.size();
            for (int i = 0; i < count; ++i) {
                String flag = flags.getString(i);
                if (flag.equalsIgnoreCase("\\Deleted")) {
                    message.setFlagInternal(Flag.DELETED, true);
                    continue;
                }
                if (flag.equalsIgnoreCase("\\Answered")) {
                    message.setFlagInternal(Flag.ANSWERED, true);
                    continue;
                }
                if (flag.equalsIgnoreCase("\\Seen")) {
                    message.setFlagInternal(Flag.SEEN, true);
                    continue;
                }
                if (flag.equalsIgnoreCase("\\Flagged")) {
                    message.setFlagInternal(Flag.FLAGGED, true);
                    continue;
                }
                if (!flag.equalsIgnoreCase("$Forwarded")) continue;
                message.setFlagInternal(Flag.FORWARDED, true);
                this.store.getPermanentFlagsIndex().add(Flag.FORWARDED);
            }
        }
        if (fetchList.containsKey("INTERNALDATE")) {
            Date internalDate = fetchList.getKeyedDate("INTERNALDATE");
            message.setInternalDate(internalDate);
        }
        if (fetchList.containsKey("RFC822.SIZE")) {
            int size2 = fetchList.getKeyedNumber("RFC822.SIZE");
            message.setSize(size2);
        }
        if (fetchList.containsKey("BODYSTRUCTURE") && (bs = fetchList.getKeyedList("BODYSTRUCTURE")) != null) {
            try {
                this.parseBodyStructure(bs, message, "TEXT");
            }
            catch (MessagingException e) {
                if (K9MailLib.isDebug()) {
                    Log.d((String)"k9", (String)("Error handling message for " + this.getLogId()), (Throwable)e);
                }
                message.setBody(null);
            }
        }
        if (fetchList.containsKey("BODY") && (index = fetchList.getKeyIndex("BODY") + 2) < (size = fetchList.size()) && (result = fetchList.getObject(index)) instanceof String && (originOctet = (String)result).startsWith("<") && index + 1 < size) {
            result = fetchList.getObject(index + 1);
        }
        return result;
    }

    protected List<ImapResponse> handleUntaggedResponses(List<ImapResponse> responses) {
        for (ImapResponse response : responses) {
            this.handleUntaggedResponse(response);
        }
        return responses;
    }

    protected void handlePossibleUidNext(ImapResponse response) {
        String key;
        Object keyObj;
        ImapList bracketed;
        Object bracketedObj;
        if (ImapResponseParser.equalsIgnoreCase(response.get(0), "OK") && response.size() > 1 && (bracketedObj = response.get(1)) instanceof ImapList && (bracketed = (ImapList)bracketedObj).size() > 1 && (keyObj = bracketed.get(0)) instanceof String && "UIDNEXT".equalsIgnoreCase(key = (String)keyObj)) {
            this.uidNext = bracketed.getLong(1);
            if (K9MailLib.isDebug()) {
                Log.d((String)"k9", (String)("Got UidNext = " + this.uidNext + " for " + this.getLogId()));
            }
        }
    }

    protected void handleUntaggedResponse(ImapResponse response) {
        if (response.getTag() == null && response.size() > 1) {
            if (ImapResponseParser.equalsIgnoreCase(response.get(1), "EXISTS")) {
                this.messageCount = response.getNumber(0);
                if (K9MailLib.isDebug()) {
                    Log.d((String)"k9", (String)("Got untagged EXISTS with value " + this.messageCount + " for " + this.getLogId()));
                }
            }
            this.handlePossibleUidNext(response);
            if (ImapResponseParser.equalsIgnoreCase(response.get(1), "EXPUNGE") && this.messageCount > 0) {
                --this.messageCount;
                if (K9MailLib.isDebug()) {
                    Log.d((String)"k9", (String)("Got untagged EXPUNGE with messageCount " + this.messageCount + " for " + this.getLogId()));
                }
            }
        }
    }

    private void parseBodyStructure(ImapList bs, Part part, String id) throws MessagingException {
        if (bs.get(0) instanceof ImapList) {
            MimeMultipart mp = MimeMultipart.newInstance();
            int count = bs.size();
            for (int i = 0; i < count; ++i) {
                MimeBodyPart bp;
                if (bs.get(i) instanceof ImapList) {
                    bp = new MimeBodyPart();
                    if (id.equalsIgnoreCase("TEXT")) {
                        this.parseBodyStructure(bs.getList(i), bp, Integer.toString(i + 1));
                    } else {
                        this.parseBodyStructure(bs.getList(i), bp, id + "." + (i + 1));
                    }
                } else {
                    String subType = bs.getString(i);
                    mp.setSubType(subType.toLowerCase(Locale.US));
                    break;
                }
                mp.addBodyPart(bp);
            }
            MimeMessageHelper.setBody(part, mp);
        } else {
            String type = bs.getString(0);
            String subType = bs.getString(1);
            String mimeType = (type + "/" + subType).toLowerCase(Locale.US);
            ImapList bodyParams = null;
            if (bs.get(2) instanceof ImapList) {
                bodyParams = bs.getList(2);
            }
            String encoding = bs.getString(5);
            int size = bs.getNumber(6);
            if (MimeUtility.isMessage(mimeType)) {
                throw new MessagingException("BODYSTRUCTURE message/rfc822 not yet supported.");
            }
            StringBuilder contentType = new StringBuilder();
            contentType.append(mimeType);
            if (bodyParams != null) {
                int count = bodyParams.size();
                for (int i = 0; i < count; i += 2) {
                    String paramName = bodyParams.getString(i);
                    String paramValue = bodyParams.getString(i + 1);
                    contentType.append(String.format(";\r\n %s=\"%s\"", paramName, paramValue));
                }
            }
            part.setHeader("Content-Type", contentType.toString());
            ArrayList bodyDisposition = null;
            if ("text".equalsIgnoreCase(type) && bs.size() > 9 && bs.get(9) instanceof ImapList) {
                bodyDisposition = bs.getList(9);
            } else if (!"text".equalsIgnoreCase(type) && bs.size() > 8 && bs.get(8) instanceof ImapList) {
                bodyDisposition = bs.getList(8);
            }
            StringBuilder contentDisposition = new StringBuilder();
            if (bodyDisposition != null && !bodyDisposition.isEmpty()) {
                if (!"NIL".equalsIgnoreCase(((ImapList)bodyDisposition).getString(0))) {
                    contentDisposition.append(((ImapList)bodyDisposition).getString(0).toLowerCase(Locale.US));
                }
                if (bodyDisposition.size() > 1 && bodyDisposition.get(1) instanceof ImapList) {
                    ImapList bodyDispositionParams = ((ImapList)bodyDisposition).getList(1);
                    int count = bodyDispositionParams.size();
                    for (int i = 0; i < count; i += 2) {
                        String paramName = bodyDispositionParams.getString(i).toLowerCase(Locale.US);
                        String paramValue = bodyDispositionParams.getString(i + 1);
                        contentDisposition.append(String.format(";\r\n %s=\"%s\"", paramName, paramValue));
                    }
                }
            }
            if (MimeUtility.getHeaderParameter(contentDisposition.toString(), "size") == null) {
                contentDisposition.append(String.format(Locale.US, ";\r\n size=%d", size));
            }
            part.setHeader("Content-Disposition", contentDisposition.toString());
            part.setHeader("Content-Transfer-Encoding", encoding);
            if (part instanceof ImapMessage) {
                ((ImapMessage)part).setSize(size);
            }
            part.setServerExtra(id);
        }
    }

    @Override
    public Map<String, String> appendMessages(List<? extends Message> messages) throws MessagingException {
        this.open(0);
        this.checkOpen();
        try {
            HashMap<String, String> uidMap = new HashMap<String, String>();
            for (Message message : messages) {
                String newUid;
                ImapList appendList;
                Object responseList;
                ImapResponse response;
                long messageSize = message.calculateSize();
                Date internalDate = message.getInternalDate() == null ? new Date() : message.getInternalDate();
                String encodeFolderName = this.folderNameCodec.encode(this.getPrefixedName());
                String escapedFolderName = ImapUtility.encodeString(encodeFolderName);
                String command = String.format(Locale.US, "APPEND %s (%s) \"%s\" {%d}", escapedFolderName, this.combineFlags(message.getFlags()), INTERNAL_DATE.get().format(internalDate), messageSize);
                this.connection.sendCommand(command, false);
                do {
                    response = this.connection.readResponse();
                    this.handleUntaggedResponse(response);
                    if (!response.isContinuationRequested()) continue;
                    EOLConvertingOutputStream eolOut = new EOLConvertingOutputStream(this.connection.getOutputStream());
                    message.writeTo(eolOut);
                    eolOut.write(13);
                    eolOut.write(10);
                    eolOut.flush();
                } while (response.getTag() == null);
                if (response.size() > 1 && (responseList = response.get(1)) instanceof ImapList && (appendList = (ImapList)responseList).size() >= 3 && appendList.getString(0).equals("APPENDUID") && !TextUtils.isEmpty((CharSequence)(newUid = appendList.getString(2)))) {
                    message.setUid(newUid);
                    uidMap.put(message.getUid(), newUid);
                    continue;
                }
                String newUid2 = this.getUidFromMessageId(message);
                if (K9MailLib.isDebug()) {
                    Log.d((String)"k9", (String)("Got UID " + newUid2 + " for message for " + this.getLogId()));
                }
                if (TextUtils.isEmpty((CharSequence)newUid2)) continue;
                uidMap.put(message.getUid(), newUid2);
                message.setUid(newUid2);
            }
            return uidMap.isEmpty() ? null : uidMap;
        }
        catch (IOException ioe) {
            throw this.ioExceptionHandler(this.connection, ioe);
        }
    }

    @Override
    public String getUidFromMessageId(Message message) throws MessagingException {
        try {
            String[] messageIdHeader = message.getHeader("Message-ID");
            if (messageIdHeader.length == 0) {
                if (K9MailLib.isDebug()) {
                    Log.d((String)"k9", (String)("Did not get a message-id in order to search for UID  for " + this.getLogId()));
                }
                return null;
            }
            String messageId = messageIdHeader[0];
            if (K9MailLib.isDebug()) {
                Log.d((String)"k9", (String)("Looking for UID for message with message-id " + messageId + " for " + this.getLogId()));
            }
            String command = String.format("UID SEARCH HEADER MESSAGE-ID %s", ImapUtility.encodeString(messageId));
            List<ImapResponse> responses = this.executeSimpleCommand(command);
            for (ImapResponse response : responses) {
                if (response.getTag() != null || !ImapResponseParser.equalsIgnoreCase(response.get(0), "SEARCH") || response.size() <= 1) continue;
                return response.getString(1);
            }
            return null;
        }
        catch (IOException ioe) {
            throw new MessagingException("Could not find UID for message based on Message-ID", ioe);
        }
    }

    @Override
    public void expunge() throws MessagingException {
        this.open(0);
        this.checkOpen();
        try {
            this.executeSimpleCommand("EXPUNGE");
        }
        catch (IOException ioe) {
            throw this.ioExceptionHandler(this.connection, ioe);
        }
    }

    private String combineFlags(Iterable<Flag> flags) {
        ArrayList<String> flagNames = new ArrayList<String>();
        for (Flag flag : flags) {
            if (flag == Flag.SEEN) {
                flagNames.add("\\Seen");
                continue;
            }
            if (flag == Flag.DELETED) {
                flagNames.add("\\Deleted");
                continue;
            }
            if (flag == Flag.ANSWERED) {
                flagNames.add("\\Answered");
                continue;
            }
            if (flag == Flag.FLAGGED) {
                flagNames.add("\\Flagged");
                continue;
            }
            if (flag != Flag.FORWARDED || !this.canCreateKeywords && !this.store.getPermanentFlagsIndex().contains((Object)Flag.FORWARDED)) continue;
            flagNames.add("$Forwarded");
        }
        return ImapFolder.combine(flagNames.toArray(new String[flagNames.size()]), ' ');
    }

    @Override
    public void setFlags(Set<Flag> flags, boolean value) throws MessagingException {
        this.open(0);
        this.checkOpen();
        try {
            String command = String.format("UID STORE 1:* %sFLAGS.SILENT (%s)", value ? "+" : "-", this.combineFlags(flags));
            this.executeSimpleCommand(command);
        }
        catch (IOException ioe) {
            throw this.ioExceptionHandler(this.connection, ioe);
        }
    }

    @Override
    public String getNewPushState(String oldSerializedPushState, Message message) {
        try {
            String uid = message.getUid();
            long messageUid = Long.parseLong(uid);
            ImapPushState oldPushState = ImapPushState.parse(oldSerializedPushState);
            if (messageUid >= oldPushState.uidNext) {
                long uidNext = messageUid + 1L;
                ImapPushState newPushState = new ImapPushState(uidNext);
                return newPushState.toString();
            }
            return null;
        }
        catch (Exception e) {
            Log.e((String)"k9", (String)("Exception while updated push state for " + this.getLogId()), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setFlags(List<? extends Message> messages, Set<Flag> flags, boolean value) throws MessagingException {
        this.open(0);
        this.checkOpen();
        Object[] uids = new String[messages.size()];
        int count = messages.size();
        for (int i = 0; i < count; ++i) {
            uids[i] = messages.get(i).getUid();
        }
        try {
            String command = String.format("UID STORE %s %sFLAGS.SILENT (%s)", ImapFolder.combine(uids, ','), value ? "+" : "-", this.combineFlags(flags));
            this.executeSimpleCommand(command);
        }
        catch (IOException ioe) {
            throw this.ioExceptionHandler(this.connection, ioe);
        }
    }

    private void checkOpen() throws MessagingException {
        if (!this.isOpen()) {
            throw new MessagingException("Folder " + this.getPrefixedName() + " is not open.");
        }
    }

    private MessagingException ioExceptionHandler(ImapConnection connection, IOException ioe) {
        Log.e((String)"k9", (String)("IOException for " + this.getLogId()), (Throwable)ioe);
        if (connection != null) {
            connection.close();
        }
        this.close();
        return new MessagingException("IO Error", ioe);
    }

    public boolean equals(Object other) {
        if (other instanceof ImapFolder) {
            ImapFolder otherFolder = (ImapFolder)other;
            return otherFolder.getName().equalsIgnoreCase(this.getName());
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private ImapStore getStore() {
        return this.store;
    }

    protected String getLogId() {
        String id = this.store.getStoreConfig().toString() + ":" + this.getName() + "/" + Thread.currentThread().getName();
        if (this.connection != null) {
            id = id + "/" + this.connection.getLogId();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ImapMessage> search(final String queryString, final Set<Flag> requiredFlags, final Set<Flag> forbiddenFlags) throws MessagingException {
        if (!this.store.getStoreConfig().allowRemoteSearch()) {
            throw new MessagingException("Your settings do not allow remote searching of this account");
        }
        ImapSearcher searcher = new ImapSearcher(){

            @Override
            public List<ImapResponse> search() throws IOException, MessagingException {
                String imapQuery = "UID SEARCH ";
                if (requiredFlags != null) {
                    for (Flag flag : requiredFlags) {
                        switch (flag) {
                            case DELETED: {
                                imapQuery = imapQuery + "DELETED ";
                                break;
                            }
                            case SEEN: {
                                imapQuery = imapQuery + "SEEN ";
                                break;
                            }
                            case ANSWERED: {
                                imapQuery = imapQuery + "ANSWERED ";
                                break;
                            }
                            case FLAGGED: {
                                imapQuery = imapQuery + "FLAGGED ";
                                break;
                            }
                            case DRAFT: {
                                imapQuery = imapQuery + "DRAFT ";
                                break;
                            }
                            case RECENT: {
                                imapQuery = imapQuery + "RECENT ";
                                break;
                            }
                        }
                    }
                }
                if (forbiddenFlags != null) {
                    for (Flag flag : forbiddenFlags) {
                        switch (flag) {
                            case DELETED: {
                                imapQuery = imapQuery + "UNDELETED ";
                                break;
                            }
                            case SEEN: {
                                imapQuery = imapQuery + "UNSEEN ";
                                break;
                            }
                            case ANSWERED: {
                                imapQuery = imapQuery + "UNANSWERED ";
                                break;
                            }
                            case FLAGGED: {
                                imapQuery = imapQuery + "UNFLAGGED ";
                                break;
                            }
                            case DRAFT: {
                                imapQuery = imapQuery + "UNDRAFT ";
                                break;
                            }
                            case RECENT: {
                                imapQuery = imapQuery + "UNRECENT ";
                                break;
                            }
                        }
                    }
                }
                String encodedQuery = ImapUtility.encodeString(queryString);
                imapQuery = ImapFolder.this.store.getStoreConfig().isRemoteSearchFullText() ? imapQuery + "TEXT " + encodedQuery : imapQuery + "OR SUBJECT " + encodedQuery + " FROM " + encodedQuery;
                return ImapFolder.this.executeSimpleCommand(imapQuery);
            }
        };
        try {
            this.open(1);
            this.checkOpen();
            this.inSearch = true;
            List<ImapMessage> list = this.search(searcher, null);
            return list;
        }
        finally {
            this.inSearch = false;
        }
    }

    private static String combine(Object[] parts, char separator) {
        if (parts == null) {
            return null;
        }
        return TextUtils.join((CharSequence)String.valueOf(separator), (Object[])parts);
    }
}

