/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import com.beetstra.jutf7.CharsetProvider;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

class FolderNameCodec {
    private final Charset modifiedUtf7Charset = new CharsetProvider().charsetForName("X-RFC-3501");

    public static FolderNameCodec newInstance() {
        return new FolderNameCodec();
    }

    private FolderNameCodec() {
    }

    public String encode(String folderName) {
        ByteBuffer byteBuffer = this.modifiedUtf7Charset.encode(folderName);
        byte[] bytes = new byte[byteBuffer.limit()];
        byteBuffer.get(bytes);
        try {
            return new String(bytes, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String decode(String encodedFolderName) throws CharacterCodingException {
        CharsetDecoder decoder = this.modifiedUtf7Charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(encodedFolderName.getBytes("US-ASCII"));
            CharBuffer charBuffer = decoder.decode(byteBuffer);
            return charBuffer.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

