/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import com.fsck.k9.mail.store.imap.ImapList;
import com.fsck.k9.mail.store.imap.ImapResponse;
import com.fsck.k9.mail.store.imap.ImapResponseParser;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

class CapabilityResponse {
    private final Set<String> capabilities;

    private CapabilityResponse(Set<String> capabilities) {
        this.capabilities = Collections.unmodifiableSet(capabilities);
    }

    public static CapabilityResponse parse(List<ImapResponse> responses) {
        for (ImapResponse response : responses) {
            CapabilityResponse result;
            if (!response.isEmpty() && ImapResponseParser.equalsIgnoreCase(response.get(0), "OK") && response.isList(1)) {
                ImapList capabilityList = response.getList(1);
                result = CapabilityResponse.parse(capabilityList);
            } else {
                result = response.getTag() == null ? CapabilityResponse.parse(response) : null;
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static CapabilityResponse parse(ImapList capabilityList) {
        if (capabilityList.isEmpty() || !ImapResponseParser.equalsIgnoreCase(capabilityList.get(0), "CAPABILITY")) {
            return null;
        }
        int size = capabilityList.size();
        HashSet<String> capabilities = new HashSet<String>(size - 1);
        for (int i = 1; i < size; ++i) {
            if (!capabilityList.isString(i)) {
                return null;
            }
            String uppercaseCapability = capabilityList.getString(i).toUpperCase(Locale.US);
            capabilities.add(uppercaseCapability);
        }
        return new CapabilityResponse(capabilities);
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }
}

