/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.ssl;

import android.util.Log;
import com.fsck.k9.mail.CertificateChainException;
import com.fsck.k9.mail.ssl.LocalKeyStore;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.StrictHostnameVerifier;

public final class TrustManagerFactory {
    private static final String LOG_TAG = "TrustManagerFactory";
    private static X509TrustManager defaultTrustManager;
    private static LocalKeyStore keyStore;

    private TrustManagerFactory() {
    }

    public static X509TrustManager get(String host, int port) {
        return SecureX509TrustManager.getInstance(host, port);
    }

    static {
        block4: {
            try {
                keyStore = LocalKeyStore.getInstance();
                javax.net.ssl.TrustManagerFactory tmf = javax.net.ssl.TrustManagerFactory.getInstance("X509");
                tmf.init((KeyStore)null);
                TrustManager[] tms = tmf.getTrustManagers();
                if (tms == null) break block4;
                for (TrustManager tm : tms) {
                    if (!(tm instanceof X509TrustManager)) continue;
                    defaultTrustManager = (X509TrustManager)tm;
                    break;
                }
            }
            catch (NoSuchAlgorithmException e) {
                Log.e((String)LOG_TAG, (String)"Unable to get X509 Trust Manager ", (Throwable)e);
            }
            catch (KeyStoreException e) {
                Log.e((String)LOG_TAG, (String)"Key Store exception while initializing TrustManagerFactory ", (Throwable)e);
            }
        }
    }

    private static class SecureX509TrustManager
    implements X509TrustManager {
        private static final Map<String, SecureX509TrustManager> mTrustManager = new HashMap<String, SecureX509TrustManager>();
        private final String mHost;
        private final int mPort;

        private SecureX509TrustManager(String host, int port) {
            this.mHost = host;
            this.mPort = port;
        }

        public static synchronized X509TrustManager getInstance(String host, int port) {
            SecureX509TrustManager trustManager;
            String key = host + ":" + port;
            if (mTrustManager.containsKey(key)) {
                trustManager = mTrustManager.get(key);
            } else {
                trustManager = new SecureX509TrustManager(host, port);
                mTrustManager.put(key, trustManager);
            }
            return trustManager;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            defaultTrustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            String message = null;
            X509Certificate certificate = chain[0];
            Exception cause = null;
            try {
                defaultTrustManager.checkServerTrusted(chain, authType);
                new StrictHostnameVerifier().verify(this.mHost, certificate);
                return;
            }
            catch (CertificateException e) {
                message = e.getMessage();
                cause = e;
            }
            catch (SSLException e) {
                message = e.getMessage();
                cause = e;
            }
            if (!keyStore.isValidCertificate(certificate, this.mHost, this.mPort)) {
                throw new CertificateChainException(message, chain, cause);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return defaultTrustManager.getAcceptedIssuers();
        }
    }
}

