/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.ssl;

import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.io.IOUtils;

public class LocalKeyStore {
    private static final int KEY_STORE_FILE_VERSION = 1;
    private static String sKeyStoreLocation;
    private File mKeyStoreFile;
    private KeyStore mKeyStore;

    public static void setKeyStoreLocation(String directory) {
        sKeyStoreLocation = directory;
    }

    public static LocalKeyStore getInstance() {
        return LocalKeyStoreHolder.INSTANCE;
    }

    private LocalKeyStore() {
        try {
            this.upgradeKeyStoreFile();
            this.setKeyStoreFile(null);
        }
        catch (CertificateException e) {
            Log.w((String)"k9", (String)"Local key store has not been initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setKeyStoreFile(File file) throws CertificateException {
        if (file == null) {
            file = new File(this.getKeyStoreFilePath(1));
        }
        if (file.length() == 0L && file.exists() && !file.delete()) {
            Log.d((String)"k9", (String)("Failed to delete empty keystore file: " + file.getAbsolutePath()));
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
            store.load(fis, "".toCharArray());
            this.mKeyStore = store;
            this.mKeyStoreFile = file;
        }
        catch (Exception e) {
            Log.e((String)"k9", (String)"Failed to initialize local key store", (Throwable)e);
            this.mKeyStore = null;
            this.mKeyStoreFile = null;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    public synchronized void addCertificate(String host, int port, X509Certificate certificate) throws CertificateException {
        if (this.mKeyStore == null) {
            throw new CertificateException("Certificate not added because key store not initialized");
        }
        try {
            this.mKeyStore.setCertificateEntry(LocalKeyStore.getCertKey(host, port), certificate);
        }
        catch (KeyStoreException e) {
            throw new CertificateException("Failed to add certificate to local key store", e);
        }
        this.writeCertificateFile();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeCertificateFile() throws CertificateException {
        FileOutputStream keyStoreStream = null;
        try {
            keyStoreStream = new FileOutputStream(this.mKeyStoreFile);
            this.mKeyStore.store(keyStoreStream, "".toCharArray());
        }
        catch (FileNotFoundException e) {
            try {
                throw new CertificateException("Unable to write KeyStore: " + e.getMessage());
                catch (CertificateException e2) {
                    throw new CertificateException("Unable to write KeyStore: " + e2.getMessage());
                }
                catch (IOException e3) {
                    throw new CertificateException("Unable to write KeyStore: " + e3.getMessage());
                }
                catch (NoSuchAlgorithmException e4) {
                    throw new CertificateException("Unable to write KeyStore: " + e4.getMessage());
                }
                catch (KeyStoreException e5) {
                    throw new CertificateException("Unable to write KeyStore: " + e5.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(keyStoreStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)keyStoreStream);
    }

    public synchronized boolean isValidCertificate(Certificate certificate, String host, int port) {
        if (this.mKeyStore == null) {
            return false;
        }
        Certificate storedCert = null;
        try {
            storedCert = this.mKeyStore.getCertificate(LocalKeyStore.getCertKey(host, port));
            return storedCert != null && storedCert.equals(certificate);
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    private static String getCertKey(String host, int port) {
        return host + ":" + port;
    }

    public synchronized void deleteCertificate(String oldHost, int oldPort) {
        if (this.mKeyStore == null) {
            return;
        }
        try {
            this.mKeyStore.deleteEntry(LocalKeyStore.getCertKey(oldHost, oldPort));
            this.writeCertificateFile();
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (CertificateException e) {
            Log.e((String)"k9", (String)"Error updating the local key store file", (Throwable)e);
        }
    }

    private void upgradeKeyStoreFile() throws CertificateException {
        File versionZeroFile = new File(this.getKeyStoreFilePath(0));
        if (versionZeroFile.exists() && !versionZeroFile.delete()) {
            Log.d((String)"k9", (String)("Failed to delete old key-store file: " + versionZeroFile.getAbsolutePath()));
        }
    }

    private String getKeyStoreFilePath(int version) throws CertificateException {
        if (sKeyStoreLocation == null) {
            throw new CertificateException("Local key store location has not been initialized");
        }
        if (version < 1) {
            return sKeyStoreLocation + File.separator + "KeyStore.bks";
        }
        return sKeyStoreLocation + File.separator + "KeyStore_v" + version + ".bks";
    }

    private static class LocalKeyStoreHolder {
        static final LocalKeyStore INSTANCE = new LocalKeyStore();

        private LocalKeyStoreHolder() {
        }
    }
}

