/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.internet;

import com.fsck.k9.mail.BodyPart;
import com.fsck.k9.mail.BoundaryGenerator;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.Multipart;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class MimeMultipart
extends Multipart {
    private String mimeType;
    private byte[] preamble;
    private byte[] epilogue;
    private final String boundary;

    public static MimeMultipart newInstance() {
        String boundary = BoundaryGenerator.getInstance().generateBoundary();
        return new MimeMultipart(boundary);
    }

    public MimeMultipart(String boundary) {
        this("multipart/mixed", boundary);
    }

    public MimeMultipart(String mimeType, String boundary) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType can't be null");
        }
        if (boundary == null) {
            throw new IllegalArgumentException("boundary can't be null");
        }
        this.mimeType = mimeType;
        this.boundary = boundary;
    }

    @Override
    public String getBoundary() {
        return this.boundary;
    }

    @Override
    public byte[] getPreamble() {
        return this.preamble;
    }

    public void setPreamble(byte[] preamble) {
        this.preamble = preamble;
    }

    @Override
    public byte[] getEpilogue() {
        return this.epilogue;
    }

    public void setEpilogue(byte[] epilogue) {
        this.epilogue = epilogue;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public void setSubType(String subType) {
        this.mimeType = "multipart/" + subType;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException, MessagingException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out), 1024);
        if (this.preamble != null) {
            out.write(this.preamble);
            writer.write("\r\n");
        }
        if (this.getBodyParts().isEmpty()) {
            writer.write("--");
            writer.write(this.boundary);
            writer.write("\r\n");
        } else {
            for (BodyPart bodyPart : this.getBodyParts()) {
                writer.write("--");
                writer.write(this.boundary);
                writer.write("\r\n");
                writer.flush();
                bodyPart.writeTo(out);
                writer.write("\r\n");
            }
        }
        writer.write("--");
        writer.write(this.boundary);
        writer.write("--\r\n");
        writer.flush();
        if (this.epilogue != null) {
            out.write(this.epilogue);
        }
    }

    @Override
    public InputStream getInputStream() throws MessagingException {
        return null;
    }
}

