/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.internet;

import com.fsck.k9.mail.Body;
import com.fsck.k9.mail.Message;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.Multipart;
import com.fsck.k9.mail.Part;
import com.fsck.k9.mail.internet.MimeUtility;
import com.fsck.k9.mail.internet.TextBody;

public class MimeMessageHelper {
    private MimeMessageHelper() {
    }

    public static void setBody(Part part, Body body) throws MessagingException {
        part.setBody(body);
        if (part instanceof Message) {
            part.setHeader("MIME-Version", "1.0");
        }
        if (body instanceof Multipart) {
            Multipart multipart = (Multipart)body;
            multipart.setParent(part);
            String mimeType = multipart.getMimeType();
            String contentType = String.format("%s; boundary=\"%s\"", mimeType, multipart.getBoundary());
            part.setHeader("Content-Type", contentType);
            MimeMessageHelper.setEncoding(part, "7bit");
        } else if (body instanceof TextBody) {
            String contentType;
            if (MimeUtility.mimeTypeMatches(part.getMimeType(), "text/*")) {
                contentType = String.format("%s;\r\n charset=utf-8", part.getMimeType());
                String name = MimeUtility.getHeaderParameter(part.getContentType(), "name");
                if (name != null) {
                    contentType = contentType + String.format(";\r\n name=\"%s\"", name);
                }
            } else {
                contentType = part.getMimeType();
            }
            part.setHeader("Content-Type", contentType);
            MimeMessageHelper.setEncoding(part, "quoted-printable");
        }
    }

    public static void setEncoding(Part part, String encoding) throws MessagingException {
        Body body = part.getBody();
        if (body != null) {
            body.setEncoding(encoding);
        }
        part.setHeader("Content-Transfer-Encoding", encoding);
    }
}

