/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.internet;

import android.support.annotation.NonNull;
import com.fsck.k9.mail.Address;
import com.fsck.k9.mail.Body;
import com.fsck.k9.mail.BodyPart;
import com.fsck.k9.mail.Message;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.Multipart;
import com.fsck.k9.mail.Part;
import com.fsck.k9.mail.internet.CharsetSupport;
import com.fsck.k9.mail.internet.MimeBodyPart;
import com.fsck.k9.mail.internet.MimeHeader;
import com.fsck.k9.mail.internet.MimeMultipart;
import com.fsck.k9.mail.internet.MimeUtility;
import com.fsck.k9.mail.internet.TextBody;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.field.DefaultFieldParser;
import org.apache.james.mime4j.io.EOLConvertingInputStream;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;

public class MimeMessage
extends Message {
    private MimeHeader mHeader = new MimeHeader();
    protected Address[] mFrom;
    protected Address[] mTo;
    protected Address[] mCc;
    protected Address[] mBcc;
    protected Address[] mReplyTo;
    protected String mMessageId;
    private String[] mReferences;
    private String[] mInReplyTo;
    private Date mSentDate;
    private SimpleDateFormat mDateFormat;
    private Body mBody;
    protected int mSize;
    private String serverExtra;

    public static MimeMessage parseMimeMessage(InputStream in, boolean recurse) throws IOException, MessagingException {
        MimeMessage mimeMessage = new MimeMessage();
        mimeMessage.parse(in, recurse);
        return mimeMessage;
    }

    public final void parse(InputStream in) throws IOException, MessagingException {
        this.parse(in, false);
    }

    private void parse(InputStream in, boolean recurse) throws IOException, MessagingException {
        this.mHeader.clear();
        this.mFrom = null;
        this.mTo = null;
        this.mCc = null;
        this.mBcc = null;
        this.mReplyTo = null;
        this.mMessageId = null;
        this.mReferences = null;
        this.mInReplyTo = null;
        this.mSentDate = null;
        this.mBody = null;
        MimeConfig parserConfig = new MimeConfig();
        parserConfig.setMaxHeaderLen(-1);
        parserConfig.setMaxLineLen(-1);
        parserConfig.setMaxHeaderCount(-1);
        MimeStreamParser parser = new MimeStreamParser(parserConfig);
        parser.setContentHandler((ContentHandler)new MimeMessageBuilder());
        if (recurse) {
            parser.setRecurse();
        }
        try {
            parser.parse((InputStream)new EOLConvertingInputStream(in));
        }
        catch (MimeException me) {
            throw new MessagingException(me.getMessage(), me);
        }
    }

    @Override
    public Date getSentDate() {
        if (this.mSentDate == null) {
            try {
                DateTimeField field = (DateTimeField)DefaultFieldParser.parse((String)("Date: " + MimeUtility.unfoldAndDecode(this.getFirstHeader("Date"))));
                this.mSentDate = field.getDate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.mSentDate;
    }

    public void addSentDate(Date sentDate, boolean hideTimeZone) {
        if (this.mDateFormat == null) {
            this.mDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
        }
        if (hideTimeZone) {
            this.mDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        this.addHeader("Date", this.mDateFormat.format(sentDate));
        this.setInternalSentDate(sentDate);
    }

    @Override
    public void setSentDate(Date sentDate, boolean hideTimeZone) {
        this.removeHeader("Date");
        this.addSentDate(sentDate, hideTimeZone);
    }

    public void setInternalSentDate(Date sentDate) {
        this.mSentDate = sentDate;
    }

    @Override
    public String getContentType() {
        String contentType = this.getFirstHeader("Content-Type");
        return contentType == null ? "text/plain" : MimeUtility.unfoldAndDecode(contentType);
    }

    @Override
    public String getDisposition() {
        return MimeUtility.unfoldAndDecode(this.getFirstHeader("Content-Disposition"));
    }

    @Override
    public String getContentId() {
        return null;
    }

    @Override
    public String getMimeType() {
        return MimeUtility.getHeaderParameter(this.getContentType(), null);
    }

    @Override
    public boolean isMimeType(String mimeType) {
        return this.getMimeType().equalsIgnoreCase(mimeType);
    }

    @Override
    public int getSize() {
        return this.mSize;
    }

    @Override
    public Address[] getRecipients(Message.RecipientType type) {
        switch (type) {
            case TO: {
                if (this.mTo == null) {
                    this.mTo = Address.parse(MimeUtility.unfold(this.getFirstHeader("To")));
                }
                return this.mTo;
            }
            case CC: {
                if (this.mCc == null) {
                    this.mCc = Address.parse(MimeUtility.unfold(this.getFirstHeader("CC")));
                }
                return this.mCc;
            }
            case BCC: {
                if (this.mBcc == null) {
                    this.mBcc = Address.parse(MimeUtility.unfold(this.getFirstHeader("BCC")));
                }
                return this.mBcc;
            }
        }
        throw new IllegalArgumentException("Unrecognized recipient type.");
    }

    @Override
    public void setRecipients(Message.RecipientType type, Address[] addresses) {
        if (type == Message.RecipientType.TO) {
            if (addresses == null || addresses.length == 0) {
                this.removeHeader("To");
                this.mTo = null;
            } else {
                this.setHeader("To", Address.toEncodedString(addresses));
                this.mTo = addresses;
            }
        } else if (type == Message.RecipientType.CC) {
            if (addresses == null || addresses.length == 0) {
                this.removeHeader("CC");
                this.mCc = null;
            } else {
                this.setHeader("CC", Address.toEncodedString(addresses));
                this.mCc = addresses;
            }
        } else if (type == Message.RecipientType.BCC) {
            if (addresses == null || addresses.length == 0) {
                this.removeHeader("BCC");
                this.mBcc = null;
            } else {
                this.setHeader("BCC", Address.toEncodedString(addresses));
                this.mBcc = addresses;
            }
        } else {
            throw new IllegalStateException("Unrecognized recipient type.");
        }
    }

    @Override
    public String getSubject() {
        return MimeUtility.unfoldAndDecode(this.getFirstHeader("Subject"), this);
    }

    @Override
    public void setSubject(String subject) {
        this.setHeader("Subject", subject);
    }

    @Override
    public Address[] getFrom() {
        if (this.mFrom == null) {
            String list = MimeUtility.unfold(this.getFirstHeader("From"));
            if (list == null || list.length() == 0) {
                list = MimeUtility.unfold(this.getFirstHeader("Sender"));
            }
            this.mFrom = Address.parse(list);
        }
        return this.mFrom;
    }

    @Override
    public void setFrom(Address from) {
        if (from != null) {
            this.setHeader("From", from.toEncodedString());
            this.mFrom = new Address[]{from};
        } else {
            this.mFrom = null;
        }
    }

    @Override
    public Address[] getReplyTo() {
        if (this.mReplyTo == null) {
            this.mReplyTo = Address.parse(MimeUtility.unfold(this.getFirstHeader("Reply-to")));
        }
        return this.mReplyTo;
    }

    @Override
    public void setReplyTo(Address[] replyTo) {
        if (replyTo == null || replyTo.length == 0) {
            this.removeHeader("Reply-to");
            this.mReplyTo = null;
        } else {
            this.setHeader("Reply-to", Address.toEncodedString(replyTo));
            this.mReplyTo = replyTo;
        }
    }

    @Override
    public String getMessageId() {
        if (this.mMessageId == null) {
            this.mMessageId = this.getFirstHeader("Message-ID");
        }
        return this.mMessageId;
    }

    public void setMessageId(String messageId) {
        this.setHeader("Message-ID", messageId);
        this.mMessageId = messageId;
    }

    @Override
    public void setInReplyTo(String inReplyTo) {
        this.setHeader("In-Reply-To", inReplyTo);
    }

    @Override
    public String[] getReferences() {
        if (this.mReferences == null) {
            this.mReferences = this.getHeader("References");
        }
        return this.mReferences;
    }

    @Override
    public void setReferences(String references) {
        references = references.replaceAll("\\s+", " ");
        int limit = 985;
        int originalLength = references.length();
        if (originalLength >= 985) {
            int start = references.indexOf(60);
            String firstReference = references.substring(start, references.indexOf(60, start + 1));
            String tail = references.substring(references.indexOf(60, firstReference.length() + originalLength - 985));
            references = firstReference + tail;
        }
        this.setHeader("References", references);
    }

    @Override
    public Body getBody() {
        return this.mBody;
    }

    @Override
    public void setBody(Body body) {
        this.mBody = body;
    }

    private String getFirstHeader(String name) {
        return this.mHeader.getFirstHeader(name);
    }

    @Override
    public void addHeader(String name, String value) {
        this.mHeader.addHeader(name, value);
    }

    @Override
    public void addRawHeader(String name, String raw) {
        this.mHeader.addRawHeader(name, raw);
    }

    @Override
    public void setHeader(String name, String value) {
        this.mHeader.setHeader(name, value);
    }

    @Override
    @NonNull
    public String[] getHeader(String name) {
        return this.mHeader.getHeader(name);
    }

    @Override
    public void removeHeader(String name) {
        this.mHeader.removeHeader(name);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.mHeader.getHeaderNames();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException, MessagingException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out), 1024);
        this.mHeader.writeTo(out);
        writer.write("\r\n");
        writer.flush();
        if (this.mBody != null) {
            this.mBody.writeTo(out);
        }
    }

    @Override
    public void writeHeaderTo(OutputStream out) throws IOException, MessagingException {
        this.mHeader.writeTo(out);
    }

    @Override
    public InputStream getInputStream() throws MessagingException {
        return null;
    }

    @Override
    public void setEncoding(String encoding) throws MessagingException {
        if (this.mBody != null) {
            this.mBody.setEncoding(encoding);
        }
        this.setHeader("Content-Transfer-Encoding", encoding);
    }

    @Override
    public void setCharset(String charset) throws MessagingException {
        this.mHeader.setCharset(charset);
        if (this.mBody instanceof Multipart) {
            ((Multipart)this.mBody).setCharset(charset);
        } else if (this.mBody instanceof TextBody) {
            CharsetSupport.setCharset(charset, this);
            ((TextBody)this.mBody).setCharset(charset);
        }
    }

    protected void copy(MimeMessage destination) {
        super.copy(destination);
        destination.mHeader = this.mHeader.clone();
        destination.mBody = this.mBody;
        destination.mMessageId = this.mMessageId;
        destination.mSentDate = this.mSentDate;
        destination.mDateFormat = this.mDateFormat;
        destination.mSize = this.mSize;
        destination.mFrom = this.mFrom;
        destination.mTo = this.mTo;
        destination.mCc = this.mCc;
        destination.mBcc = this.mBcc;
        destination.mReplyTo = this.mReplyTo;
        destination.mReferences = this.mReferences;
        destination.mInReplyTo = this.mInReplyTo;
    }

    @Override
    public MimeMessage clone() {
        MimeMessage message = new MimeMessage();
        this.copy(message);
        return message;
    }

    @Override
    public long getId() {
        return Long.parseLong(this.mUid);
    }

    @Override
    public boolean hasAttachments() {
        return false;
    }

    @Override
    public String getServerExtra() {
        return this.serverExtra;
    }

    @Override
    public void setServerExtra(String serverExtra) {
        this.serverExtra = serverExtra;
    }

    public MimeBodyPart toBodyPart() throws MessagingException {
        MimeHeader contentHeaders = new MimeHeader();
        for (String header : this.mHeader.getHeaderNames()) {
            if (!header.toLowerCase().startsWith("content-")) continue;
            for (String value : this.mHeader.getHeader(header)) {
                contentHeaders.addHeader(header, value);
            }
        }
        return new MimeBodyPart(contentHeaders, this.getBody());
    }

    private class MimeMessageBuilder
    implements ContentHandler {
        private final LinkedList<Object> stack = new LinkedList();

        private void expect(Class<?> c) {
            if (!c.isInstance(this.stack.peek())) {
                throw new IllegalStateException("Internal stack error: Expected '" + c.getName() + "' found '" + this.stack.peek().getClass().getName() + "'");
            }
        }

        public void startMessage() {
            if (this.stack.isEmpty()) {
                this.stack.addFirst(MimeMessage.this);
            } else {
                this.expect(Part.class);
                Part part = (Part)this.stack.peek();
                MimeMessage m = new MimeMessage();
                part.setBody(m);
                this.stack.addFirst(m);
            }
        }

        public void endMessage() {
            this.expect(MimeMessage.class);
            this.stack.removeFirst();
        }

        public void startHeader() {
            this.expect(Part.class);
        }

        public void endHeader() {
            this.expect(Part.class);
        }

        public void startMultipart(BodyDescriptor bd) throws MimeException {
            this.expect(Part.class);
            Part e = (Part)this.stack.peek();
            String mimeType = bd.getMimeType();
            String boundary = bd.getBoundary();
            MimeMultipart multiPart = new MimeMultipart(mimeType, boundary);
            e.setBody(multiPart);
            this.stack.addFirst(multiPart);
        }

        public void body(BodyDescriptor bd, InputStream in) throws IOException, MimeException {
            this.expect(Part.class);
            Body body = MimeUtility.createBody(in, bd.getTransferEncoding(), bd.getMimeType());
            ((Part)this.stack.peek()).setBody(body);
        }

        public void endMultipart() {
            boolean hasNoEpilogue;
            this.expect(Multipart.class);
            Multipart multipart = (Multipart)this.stack.removeFirst();
            boolean hasNoBodyParts = multipart.getCount() == 0;
            boolean bl = hasNoEpilogue = multipart.getEpilogue() == null;
            if (hasNoBodyParts && hasNoEpilogue) {
                this.expect(Part.class);
                Part part = (Part)this.stack.peek();
                part.setBody(null);
            }
        }

        public void startBodyPart() throws MimeException {
            this.expect(MimeMultipart.class);
            try {
                MimeBodyPart bodyPart = new MimeBodyPart();
                ((MimeMultipart)this.stack.peek()).addBodyPart(bodyPart);
                this.stack.addFirst(bodyPart);
            }
            catch (MessagingException me) {
                throw new MimeException((Throwable)me);
            }
        }

        public void endBodyPart() {
            this.expect(BodyPart.class);
            this.stack.removeFirst();
        }

        public void preamble(InputStream is) throws IOException {
            this.expect(MimeMultipart.class);
            ByteArrayOutputStream preamble = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)preamble);
            ((MimeMultipart)this.stack.peek()).setPreamble(preamble.toByteArray());
        }

        public void epilogue(InputStream is) throws IOException {
            this.expect(MimeMultipart.class);
            ByteArrayOutputStream epilogue = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)epilogue);
            ((MimeMultipart)this.stack.peek()).setEpilogue(epilogue.toByteArray());
        }

        public void raw(InputStream is) throws IOException {
            throw new UnsupportedOperationException("Not supported");
        }

        public void field(Field parsedField) throws MimeException {
            this.expect(Part.class);
            String name = parsedField.getName();
            String raw = parsedField.getRaw().toString();
            ((Part)this.stack.peek()).addRawHeader(name, raw);
        }
    }
}

