/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.internet;

import android.support.annotation.NonNull;
import com.fsck.k9.mail.internet.EncoderUtil;
import com.fsck.k9.mail.internet.MimeUtility;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class MimeHeader
implements Cloneable {
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_CONTENT_ID = "Content-ID";
    private List<Field> mFields = new ArrayList<Field>();
    private String mCharset = null;

    public void clear() {
        this.mFields.clear();
    }

    public String getFirstHeader(String name) {
        String[] header = this.getHeader(name);
        if (header.length == 0) {
            return null;
        }
        return header[0];
    }

    public void addHeader(String name, String value) {
        Field field = Field.newNameValueField(name, MimeUtility.foldAndEncode(value));
        this.mFields.add(field);
    }

    void addRawHeader(String name, String raw) {
        Field field = Field.newRawField(name, raw);
        this.mFields.add(field);
    }

    public void setHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.removeHeader(name);
        this.addHeader(name, value);
    }

    @NonNull
    public Set<String> getHeaderNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Field field : this.mFields) {
            names.add(field.getName());
        }
        return names;
    }

    @NonNull
    public String[] getHeader(String name) {
        ArrayList<String> values = new ArrayList<String>();
        for (Field field : this.mFields) {
            if (!field.getName().equalsIgnoreCase(name)) continue;
            values.add(field.getValue());
        }
        return values.toArray(new String[values.size()]);
    }

    public void removeHeader(String name) {
        ArrayList<Field> removeFields = new ArrayList<Field>();
        for (Field field : this.mFields) {
            if (!field.getName().equalsIgnoreCase(name)) continue;
            removeFields.add(field);
        }
        this.mFields.removeAll(removeFields);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Field field : this.mFields) {
            if (field.hasRawData()) {
                builder.append(field.getRaw());
            } else {
                this.writeNameValueField(builder, field);
            }
            builder.append('\r').append('\n');
        }
        return builder.toString();
    }

    public void writeTo(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out), 1024);
        for (Field field : this.mFields) {
            if (field.hasRawData()) {
                writer.write(field.getRaw());
            } else {
                this.writeNameValueField(writer, field);
            }
            writer.write("\r\n");
        }
        writer.flush();
    }

    private void writeNameValueField(BufferedWriter writer, Field field) throws IOException {
        String value = field.getValue();
        if (this.hasToBeEncoded(value)) {
            Charset charset = null;
            if (this.mCharset != null) {
                charset = Charset.forName(this.mCharset);
            }
            value = EncoderUtil.encodeEncodedWord(field.getValue(), charset);
        }
        writer.write(field.getName());
        writer.write(": ");
        writer.write(value);
    }

    private void writeNameValueField(StringBuilder builder, Field field) {
        String value = field.getValue();
        if (this.hasToBeEncoded(value)) {
            Charset charset = null;
            if (this.mCharset != null) {
                charset = Charset.forName(this.mCharset);
            }
            value = EncoderUtil.encodeEncodedWord(field.getValue(), charset);
        }
        builder.append(field.getName());
        builder.append(": ");
        builder.append(value);
    }

    private boolean hasToBeEncoded(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= ' ' && '~' >= c || c == '\n' || c == '\r' || c == '\t') continue;
            return true;
        }
        return false;
    }

    public void setCharset(String charset) {
        this.mCharset = charset;
    }

    public MimeHeader clone() {
        try {
            MimeHeader header = (MimeHeader)super.clone();
            header.mFields = new ArrayList<Field>(this.mFields);
            return header;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class Field {
        private final String name;
        private final String value;
        private final String raw;

        public static Field newNameValueField(String name, String value) {
            if (value == null) {
                throw new NullPointerException("Argument 'value' cannot be null");
            }
            return new Field(name, value, null);
        }

        public static Field newRawField(String name, String raw) {
            if (raw == null) {
                throw new NullPointerException("Argument 'raw' cannot be null");
            }
            if (name != null && !raw.startsWith(name + ":")) {
                throw new IllegalArgumentException("The value of 'raw' needs to start with the supplied field name followed by a colon");
            }
            return new Field(name, null, raw);
        }

        private Field(String name, String value, String raw) {
            if (name == null) {
                throw new NullPointerException("Argument 'name' cannot be null");
            }
            this.name = name;
            this.value = value;
            this.raw = raw;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            if (this.value != null) {
                return this.value;
            }
            int delimiterIndex = this.raw.indexOf(58);
            if (delimiterIndex == this.raw.length() - 1) {
                return "";
            }
            return this.raw.substring(delimiterIndex + 1).trim();
        }

        public String getRaw() {
            return this.raw;
        }

        public boolean hasRawData() {
            return this.raw != null;
        }

        public String toString() {
            return this.hasRawData() ? this.getRaw() : this.getName() + ": " + this.getValue();
        }
    }
}

