/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.internet;

import android.support.annotation.NonNull;
import com.fsck.k9.mail.Body;
import com.fsck.k9.mail.BodyPart;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.internet.MimeHeader;
import com.fsck.k9.mail.internet.MimeMessageHelper;
import com.fsck.k9.mail.internet.MimeUtility;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class MimeBodyPart
extends BodyPart {
    private final MimeHeader mHeader;
    private Body mBody;

    public MimeBodyPart() throws MessagingException {
        this(null);
    }

    public MimeBodyPart(Body body) throws MessagingException {
        this(body, null);
    }

    public MimeBodyPart(Body body, String mimeType) throws MessagingException {
        this.mHeader = new MimeHeader();
        if (mimeType != null) {
            this.addHeader("Content-Type", mimeType);
        }
        MimeMessageHelper.setBody(this, body);
    }

    MimeBodyPart(MimeHeader header, Body body) throws MessagingException {
        this.mHeader = header;
        MimeMessageHelper.setBody(this, body);
    }

    private String getFirstHeader(String name) {
        return this.mHeader.getFirstHeader(name);
    }

    @Override
    public void addHeader(String name, String value) {
        this.mHeader.addHeader(name, value);
    }

    @Override
    public void addRawHeader(String name, String raw) {
        this.mHeader.addRawHeader(name, raw);
    }

    @Override
    public void setHeader(String name, String value) {
        this.mHeader.setHeader(name, value);
    }

    @Override
    @NonNull
    public String[] getHeader(String name) {
        return this.mHeader.getHeader(name);
    }

    @Override
    public void removeHeader(String name) {
        this.mHeader.removeHeader(name);
    }

    @Override
    public Body getBody() {
        return this.mBody;
    }

    @Override
    public void setBody(Body body) {
        this.mBody = body;
    }

    @Override
    public void setEncoding(String encoding) throws MessagingException {
        if (this.mBody != null) {
            this.mBody.setEncoding(encoding);
        }
        this.setHeader("Content-Transfer-Encoding", encoding);
    }

    @Override
    public String getContentType() {
        String contentType = this.getFirstHeader("Content-Type");
        return contentType == null ? "text/plain" : MimeUtility.unfoldAndDecode(contentType);
    }

    @Override
    public String getDisposition() {
        return this.getFirstHeader("Content-Disposition");
    }

    @Override
    public String getContentId() {
        String contentId = this.getFirstHeader("Content-ID");
        if (contentId == null) {
            return null;
        }
        int first = contentId.indexOf(60);
        int last = contentId.lastIndexOf(62);
        return first != -1 && last != -1 ? contentId.substring(first + 1, last) : contentId;
    }

    @Override
    public String getMimeType() {
        return MimeUtility.getHeaderParameter(this.getContentType(), null);
    }

    @Override
    public boolean isMimeType(String mimeType) {
        return this.getMimeType().equalsIgnoreCase(mimeType);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException, MessagingException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out), 1024);
        this.mHeader.writeTo(out);
        writer.write("\r\n");
        writer.flush();
        if (this.mBody != null) {
            this.mBody.writeTo(out);
        }
    }

    @Override
    public void writeHeaderTo(OutputStream out) throws IOException, MessagingException {
        this.mHeader.writeTo(out);
    }
}

