/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.internet;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.fsck.k9.mail.Body;
import com.fsck.k9.mail.BodyPart;
import com.fsck.k9.mail.Message;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.Multipart;
import com.fsck.k9.mail.Part;
import com.fsck.k9.mail.internet.CharsetSupport;
import com.fsck.k9.mail.internet.MimeUtility;
import com.fsck.k9.mail.internet.TextBody;
import com.fsck.k9.mail.internet.Viewable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.BoundedInputStream;

public class MessageExtractor {
    public static final long NO_TEXT_SIZE_LIMIT = -1L;

    private MessageExtractor() {
    }

    public static String getTextFromPart(Part part) {
        return MessageExtractor.getTextFromPart(part, -1L);
    }

    public static String getTextFromPart(Part part, long textSizeLimit) {
        try {
            if (part != null && part.getBody() != null) {
                Body body = part.getBody();
                if (body instanceof TextBody) {
                    return ((TextBody)body).getRawText();
                }
                String mimeType = part.getMimeType();
                if (mimeType != null && MimeUtility.mimeTypeMatches(mimeType, "text/*") || part.isMimeType("application/pgp")) {
                    return MessageExtractor.getTextFromTextPart(part, body, mimeType, textSizeLimit);
                }
                throw new MessagingException("Provided non-text part: " + part);
            }
            throw new MessagingException("Provided invalid part: " + part);
        }
        catch (IOException e) {
            Log.e((String)"k9", (String)"Unable to getTextFromPart", (Throwable)e);
        }
        catch (MessagingException e) {
            Log.e((String)"k9", (String)"Unable to getTextFromPart", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTextFromTextPart(Part part, Body body, String mimeType, long textSizeLimit) throws IOException, MessagingException {
        InputStream in;
        String charset = MimeUtility.getHeaderParameter(part.getContentType(), "charset");
        if (MimeUtility.isSameMimeType(mimeType, "text/html") && charset == null) {
            in = MimeUtility.decodeBody(body);
            try {
                byte[] buf = new byte[256];
                in.read(buf, 0, buf.length);
                String str = new String(buf, "US-ASCII");
                if (TextUtils.isEmpty((CharSequence)str)) {
                    String string = "";
                    return string;
                }
                Pattern p = Pattern.compile("<meta http-equiv=\"?Content-Type\"? content=\"text/html; charset=(.+?)\">", 2);
                Matcher m = p.matcher(str);
                if (m.find()) {
                    charset = m.group(1);
                }
            }
            finally {
                try {
                    MimeUtility.closeInputStreamWithoutDeletingTemporaryFiles(in);
                }
                catch (IOException iOException) {}
            }
        }
        charset = CharsetSupport.fixupCharset(charset, MessageExtractor.getMessageFromPart(part));
        in = MimeUtility.decodeBody(body);
        InputStream possiblyLimitedIn = textSizeLimit != -1L ? new BoundedInputStream(in, textSizeLimit) : in;
        try {
            String string = CharsetSupport.readToString(possiblyLimitedIn, charset);
            return string;
        }
        finally {
            try {
                MimeUtility.closeInputStreamWithoutDeletingTemporaryFiles(in);
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean hasMissingParts(Part part) {
        Body body = part.getBody();
        if (body == null) {
            return true;
        }
        if (body instanceof Multipart) {
            Multipart multipart = (Multipart)body;
            for (Part part2 : multipart.getBodyParts()) {
                if (!MessageExtractor.hasMissingParts(part2)) continue;
                return true;
            }
        }
        return false;
    }

    public static void findViewablesAndAttachments(Part part, @Nullable List<Viewable> outputViewableParts, @Nullable List<Part> outputNonViewableParts) throws MessagingException {
        boolean skipSavingViewableParts;
        boolean skipSavingNonViewableParts = outputNonViewableParts == null;
        boolean bl = skipSavingViewableParts = outputViewableParts == null;
        if (skipSavingNonViewableParts && skipSavingViewableParts) {
            throw new IllegalArgumentException("method was called but no output is to be collected - this a bug!");
        }
        Body body = part.getBody();
        if (body instanceof Multipart) {
            Multipart multipart = (Multipart)body;
            if (MimeUtility.isSameMimeType(part.getMimeType(), "multipart/alternative")) {
                List<Viewable> text = MessageExtractor.findTextPart(multipart, true);
                Set<Part> set = MessageExtractor.getParts(text);
                List<Viewable> html = MessageExtractor.findHtmlPart(multipart, set, outputNonViewableParts, true);
                if (skipSavingViewableParts) {
                    return;
                }
                if (!text.isEmpty() || !html.isEmpty()) {
                    Viewable.Alternative alternative = new Viewable.Alternative(text, html);
                    outputViewableParts.add(alternative);
                }
            } else {
                for (Part part2 : multipart.getBodyParts()) {
                    MessageExtractor.findViewablesAndAttachments(part2, outputViewableParts, outputNonViewableParts);
                }
            }
        } else if (body instanceof Message && !"attachment".equalsIgnoreCase(MessageExtractor.getContentDisposition(part))) {
            if (skipSavingViewableParts) {
                return;
            }
            Message message = (Message)body;
            outputViewableParts.add(new Viewable.MessageHeader(part, message));
            MessageExtractor.findViewablesAndAttachments(message, outputViewableParts, outputNonViewableParts);
        } else if (MessageExtractor.isPartTextualBody(part).booleanValue()) {
            if (skipSavingViewableParts) {
                return;
            }
            String mimeType = part.getMimeType();
            if (MimeUtility.isSameMimeType(mimeType, "text/plain")) {
                Viewable.Text text = new Viewable.Text(part);
                outputViewableParts.add(text);
            } else {
                Viewable.Html html = new Viewable.Html(part);
                outputViewableParts.add(html);
            }
        } else if (!MimeUtility.isSameMimeType(part.getMimeType(), "application/pgp-signature")) {
            if (skipSavingNonViewableParts) {
                return;
            }
            outputNonViewableParts.add(part);
        }
    }

    public static Set<Part> getTextParts(Part part) throws MessagingException {
        ArrayList<Viewable> viewableParts = new ArrayList<Viewable>();
        ArrayList<Part> nonViewableParts = new ArrayList<Part>();
        MessageExtractor.findViewablesAndAttachments(part, viewableParts, nonViewableParts);
        return MessageExtractor.getParts(viewableParts);
    }

    public static List<Part> collectAttachments(Message message) throws MessagingException {
        try {
            ArrayList<Part> attachments = new ArrayList<Part>();
            MessageExtractor.findViewablesAndAttachments(message, new ArrayList<Viewable>(), attachments);
            return attachments;
        }
        catch (Exception e) {
            throw new MessagingException("Couldn't collect attachment parts", e);
        }
    }

    public static Set<Part> collectTextParts(Message message) throws MessagingException {
        try {
            return MessageExtractor.getTextParts(message);
        }
        catch (Exception e) {
            throw new MessagingException("Couldn't extract viewable parts", e);
        }
    }

    private static Message getMessageFromPart(Part part) {
        while (part != null) {
            if (part instanceof Message) {
                return (Message)part;
            }
            if (!(part instanceof BodyPart)) {
                return null;
            }
            Multipart multipart = ((BodyPart)part).getParent();
            if (multipart == null) {
                return null;
            }
            part = multipart.getParent();
        }
        return null;
    }

    private static List<Viewable> findTextPart(Multipart multipart, boolean directChild) throws MessagingException {
        ArrayList<Viewable> viewables = new ArrayList<Viewable>();
        for (Part part : multipart.getBodyParts()) {
            Body body = part.getBody();
            if (body instanceof Multipart) {
                Multipart innerMultipart = (Multipart)body;
                List<Viewable> textViewables = MessageExtractor.findTextPart(innerMultipart, false);
                if (textViewables.isEmpty()) continue;
                viewables.addAll(textViewables);
                if (!directChild) continue;
                break;
            }
            if (!MessageExtractor.isPartTextualBody(part).booleanValue() || !MimeUtility.isSameMimeType(part.getMimeType(), "text/plain")) continue;
            Viewable.Text text = new Viewable.Text(part);
            viewables.add(text);
            if (!directChild) continue;
            break;
        }
        return viewables;
    }

    private static List<Viewable> findHtmlPart(Multipart multipart, Set<Part> knownTextParts, @Nullable List<Part> outputNonViewableParts, boolean directChild) throws MessagingException {
        boolean saveNonViewableParts = outputNonViewableParts != null;
        ArrayList<Viewable> viewables = new ArrayList<Viewable>();
        boolean partFound = false;
        for (Part part : multipart.getBodyParts()) {
            Body body = part.getBody();
            if (body instanceof Multipart) {
                Multipart innerMultipart = (Multipart)body;
                if (directChild && partFound) {
                    if (!saveNonViewableParts) continue;
                    MessageExtractor.findAttachments(innerMultipart, knownTextParts, outputNonViewableParts);
                    continue;
                }
                List<Viewable> htmlViewables = MessageExtractor.findHtmlPart(innerMultipart, knownTextParts, outputNonViewableParts, false);
                if (htmlViewables.isEmpty()) continue;
                partFound = true;
                viewables.addAll(htmlViewables);
                continue;
            }
            if ((!directChild || !partFound) && MessageExtractor.isPartTextualBody(part).booleanValue() && MimeUtility.isSameMimeType(part.getMimeType(), "text/html")) {
                Viewable.Html html = new Viewable.Html(part);
                viewables.add(html);
                partFound = true;
                continue;
            }
            if (knownTextParts.contains(part) || !saveNonViewableParts) continue;
            outputNonViewableParts.add(part);
        }
        return viewables;
    }

    private static void findAttachments(Multipart multipart, Set<Part> knownTextParts, @NonNull List<Part> attachments) {
        for (Part part : multipart.getBodyParts()) {
            Body body = part.getBody();
            if (body instanceof Multipart) {
                Multipart innerMultipart = (Multipart)body;
                MessageExtractor.findAttachments(innerMultipart, knownTextParts, attachments);
                continue;
            }
            if (knownTextParts.contains(part)) continue;
            attachments.add(part);
        }
    }

    private static Set<Part> getParts(List<Viewable> viewables) {
        HashSet<Part> parts = new HashSet<Part>();
        for (Viewable viewable : viewables) {
            if (viewable instanceof Viewable.Textual) {
                parts.add(((Viewable.Textual)viewable).getPart());
                continue;
            }
            if (!(viewable instanceof Viewable.Alternative)) continue;
            Viewable.Alternative alternative = (Viewable.Alternative)viewable;
            parts.addAll(MessageExtractor.getParts(alternative.getText()));
            parts.addAll(MessageExtractor.getParts(alternative.getHtml()));
        }
        return parts;
    }

    private static Boolean isPartTextualBody(Part part) throws MessagingException {
        boolean isAttachmentDisposition;
        String disposition = part.getDisposition();
        String dispositionType = null;
        String dispositionFilename = null;
        if (disposition != null) {
            dispositionType = MimeUtility.getHeaderParameter(disposition, null);
            dispositionFilename = MimeUtility.getHeaderParameter(disposition, "filename");
        }
        boolean bl = isAttachmentDisposition = "attachment".equalsIgnoreCase(dispositionType) || dispositionFilename != null;
        if (isAttachmentDisposition) {
            return false;
        }
        if (part.isMimeType("text/html")) {
            return true;
        }
        if (part.isMimeType("text/plain")) {
            return true;
        }
        if (part.isMimeType("application/pgp")) {
            return true;
        }
        return false;
    }

    private static String getContentDisposition(Part part) {
        String disposition = part.getDisposition();
        if (disposition != null) {
            return MimeUtility.getHeaderParameter(disposition, null);
        }
        return null;
    }
}

