/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.MalformedInputException;

class Iso2022JpToShiftJisInputStream
extends InputStream {
    private InputStream mIn;
    private Charset charset = Charset.ASCII;
    private int out;
    private boolean hasOut = false;

    public Iso2022JpToShiftJisInputStream(InputStream in) {
        this.mIn = in;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        if (this.hasOut) {
            this.hasOut = false;
            return this.out;
        }
        int in1 = this.mIn.read();
        while (in1 == 27) {
            in1 = this.mIn.read();
            if (in1 == 40) {
                in1 = this.mIn.read();
                if (in1 == 66 || in1 == 74) {
                    this.charset = Charset.ASCII;
                } else {
                    if (in1 != 73) throw new MalformedInputException(0);
                    this.charset = Charset.JISX0201;
                }
            } else {
                if (in1 != 36) throw new MalformedInputException(0);
                in1 = this.mIn.read();
                if (in1 != 64 && in1 != 66) throw new MalformedInputException(0);
                this.charset = Charset.JISX0208;
            }
            in1 = this.mIn.read();
        }
        if (in1 == 10 || in1 == 13) {
            this.charset = Charset.ASCII;
        }
        if (in1 < 33 || in1 >= 127) {
            return in1;
        }
        switch (this.charset) {
            case ASCII: {
                return in1;
            }
            case JISX0201: {
                return in1 + 128;
            }
            case JISX0208: {
                int out2;
                int in2 = this.mIn.read();
                if (in2 < 33 || in2 >= 127) {
                    throw new MalformedInputException(0);
                }
                int out1 = (in1 + 1) / 2 + (in1 < 95 ? 112 : 176);
                this.out = out2 = in2 + (in1 % 2 == 0 ? 126 : (in2 < 96 ? 31 : 32));
                this.hasOut = true;
                return out1;
            }
        }
        throw new RuntimeException();
    }

    private static enum Charset {
        ASCII,
        JISX0201,
        JISX0208;

    }
}

