/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.internet;

import android.text.TextUtils;
import android.util.Log;
import com.fsck.k9.mail.Message;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.internet.CharsetSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.james.mime4j.codec.Base64InputStream;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;
import org.apache.james.mime4j.util.CharsetUtil;

class DecoderUtil {
    DecoderUtil() {
    }

    private static String decodeB(String encodedWord, String charset) {
        byte[] bytes = DecoderUtil.getBytes(encodedWord, "US-ASCII");
        Base64InputStream is = new Base64InputStream((InputStream)new ByteArrayInputStream(bytes));
        try {
            return CharsetSupport.readToString((InputStream)is, charset);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String decodeQ(String encodedWord, String charset) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < encodedWord.length(); ++i) {
            char c = encodedWord.charAt(i);
            if (c == '_') {
                sb.append("=20");
                continue;
            }
            sb.append(c);
        }
        byte[] bytes = DecoderUtil.getBytes(sb.toString(), "US-ASCII");
        QuotedPrintableInputStream is = new QuotedPrintableInputStream((InputStream)new ByteArrayInputStream(bytes));
        try {
            return CharsetSupport.readToString((InputStream)is, charset);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String decodeEncodedWords(String body, Message message) {
        if (!body.contains("=?")) {
            return body;
        }
        int previousEnd = 0;
        boolean previousWasEncoded = false;
        StringBuilder sb = new StringBuilder();
        while (true) {
            int begin;
            if ((begin = body.indexOf("=?", previousEnd)) == -1) {
                sb.append(body.substring(previousEnd));
                return sb.toString();
            }
            int qm1 = body.indexOf(63, begin + 2);
            if (qm1 == -1) {
                sb.append(body.substring(previousEnd));
                return sb.toString();
            }
            int qm2 = body.indexOf(63, qm1 + 1);
            if (qm2 == -1) {
                sb.append(body.substring(previousEnd));
                return sb.toString();
            }
            int end = body.indexOf("?=", qm2 + 1);
            if (end == -1) {
                sb.append(body.substring(previousEnd));
                return sb.toString();
            }
            String sep = body.substring(previousEnd, begin);
            String decoded = DecoderUtil.decodeEncodedWord(body, begin, end += 2, message);
            if (decoded == null) {
                sb.append(sep);
                sb.append(body.substring(begin, end));
            } else {
                if (!previousWasEncoded || !CharsetUtil.isWhitespace((String)sep)) {
                    sb.append(sep);
                }
                sb.append(decoded);
            }
            previousEnd = end;
            previousWasEncoded = decoded != null;
        }
    }

    private static String decodeEncodedWord(String body, int begin, int end, Message message) {
        String charset;
        int qm1 = body.indexOf(63, begin + 2);
        if (qm1 == end - 2) {
            return null;
        }
        int qm2 = body.indexOf(63, qm1 + 1);
        if (qm2 == end - 2) {
            return null;
        }
        String mimeCharset = body.substring(begin + 2, qm1);
        String encoding = body.substring(qm1 + 1, qm2);
        String encodedText = body.substring(qm2 + 1, end - 2);
        try {
            charset = CharsetSupport.fixupCharset(mimeCharset, message);
        }
        catch (MessagingException e) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)encodedText)) {
            Log.w((String)"k9", (String)("Missing encoded text in encoded word: '" + body.substring(begin, end) + "'"));
            return null;
        }
        if (encoding.equalsIgnoreCase("Q")) {
            return DecoderUtil.decodeQ(encodedText, charset);
        }
        if (encoding.equalsIgnoreCase("B")) {
            return DecoderUtil.decodeB(encodedText, charset);
        }
        Log.w((String)"k9", (String)("Warning: Unknown encoding in encoded word '" + body.substring(begin, end) + "'"));
        return null;
    }

    public static byte[] getBytes(String s, String charset) {
        try {
            return s.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

