/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.internet;

import android.util.Log;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.filter.Base64OutputStream;
import com.fsck.k9.mail.internet.RawDataBody;
import com.fsck.k9.mail.internet.SizeAware;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.james.mime4j.codec.QuotedPrintableOutputStream;

public class BinaryTempFileBody
implements RawDataBody,
SizeAware {
    private static File mTempDirectory;
    private File mFile;
    String mEncoding = null;

    public static void setTempDirectory(File tempDirectory) {
        mTempDirectory = tempDirectory;
    }

    public static File getTempDirectory() {
        return mTempDirectory;
    }

    @Override
    public String getEncoding() {
        return this.mEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEncoding(String encoding) throws MessagingException {
        if (this.mEncoding != null && this.mEncoding.equalsIgnoreCase(encoding)) {
            return;
        }
        if (!"8bit".equalsIgnoreCase(this.mEncoding)) {
            throw new RuntimeException("Can't convert from encoding: " + this.mEncoding);
        }
        try {
            File newFile = File.createTempFile("body", null, mTempDirectory);
            FileOutputStream out = new FileOutputStream(newFile);
            try {
                Object wrappedOut = null;
                if ("quoted-printable".equals(encoding)) {
                    wrappedOut = new QuotedPrintableOutputStream((OutputStream)out, false);
                } else if ("base64".equals(encoding)) {
                    wrappedOut = new Base64OutputStream(out);
                } else {
                    throw new RuntimeException("Target encoding not supported: " + encoding);
                }
                InputStream in = this.getInputStream();
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)wrappedOut);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)wrappedOut);
                }
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
            this.mFile = newFile;
            this.mEncoding = encoding;
        }
        catch (IOException e) {
            throw new MessagingException("Unable to convert body", e);
        }
    }

    public BinaryTempFileBody(String encoding) {
        if (mTempDirectory == null) {
            throw new RuntimeException("setTempDirectory has not been called on BinaryTempFileBody!");
        }
        this.mEncoding = encoding;
    }

    public OutputStream getOutputStream() throws IOException {
        this.mFile = File.createTempFile("body", null, mTempDirectory);
        this.mFile.deleteOnExit();
        return new FileOutputStream(this.mFile);
    }

    @Override
    public InputStream getInputStream() throws MessagingException {
        try {
            return new BinaryTempFileBodyInputStream(new FileInputStream(this.mFile));
        }
        catch (IOException ioe) {
            throw new MessagingException("Unable to open body", ioe);
        }
    }

    @Override
    public void writeTo(OutputStream out) throws IOException, MessagingException {
        InputStream in = this.getInputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public long getSize() {
        return this.mFile.length();
    }

    public File getFile() {
        return this.mFile;
    }

    class BinaryTempFileBodyInputStream
    extends FilterInputStream {
        public BinaryTempFileBodyInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                Log.d((String)"k9", (String)"deleting temp file");
                BinaryTempFileBody.this.mFile.delete();
            }
        }

        public void closeWithoutDeleting() throws IOException {
            super.close();
        }
    }
}

