/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.filter;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SignSafeOutputStream
extends FilterOutputStream {
    private static final byte[] ESCAPED_SPACE = new byte[]{61, 50, 48};
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private State state = State.cr_FROM;
    private final byte[] outBuffer = new byte[1024];
    private int outputIndex;
    private boolean closed = false;

    public SignSafeOutputStream(OutputStream out) {
        super(out);
    }

    public void encode(byte next) throws IOException {
        State nextState = this.state.nextState(next);
        if (nextState == State.SPACE_FROM) {
            this.state = State.INIT;
            this.writeToBuffer(ESCAPED_SPACE[0]);
            this.writeToBuffer(ESCAPED_SPACE[1]);
            this.writeToBuffer(ESCAPED_SPACE[2]);
        } else {
            this.state = nextState;
            this.writeToBuffer(next);
        }
    }

    private void writeToBuffer(byte next) throws IOException {
        this.outBuffer[this.outputIndex++] = next;
        if (this.outputIndex >= this.outBuffer.length) {
            this.flushOutput();
        }
    }

    void flushOutput() throws IOException {
        if (this.outputIndex < this.outBuffer.length) {
            this.out.write(this.outBuffer, 0, this.outputIndex);
        } else {
            this.out.write(this.outBuffer);
        }
        this.outputIndex = 0;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream has been closed");
        }
        this.encode((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream has been closed");
        }
        for (int inputIndex = off; inputIndex < len + off; ++inputIndex) {
            this.encode(b[inputIndex]);
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushOutput();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.flush();
        }
        finally {
            this.closed = true;
        }
    }

    static enum State {
        INIT{

            @Override
            public State nextState(int b) {
                switch (b) {
                    case 13: {
                        return lf_FROM;
                    }
                }
                return INIT;
            }
        }
        ,
        lf_FROM{

            @Override
            public State nextState(int b) {
                switch (b) {
                    case 10: {
                        return cr_FROM;
                    }
                    case 13: {
                        return lf_FROM;
                    }
                }
                return INIT;
            }
        }
        ,
        cr_FROM{

            @Override
            public State nextState(int b) {
                switch (b) {
                    case 70: {
                        return F_FROM;
                    }
                    case 13: {
                        return lf_FROM;
                    }
                }
                return INIT;
            }
        }
        ,
        F_FROM{

            @Override
            public State nextState(int b) {
                switch (b) {
                    case 114: {
                        return R_FROM;
                    }
                    case 13: {
                        return lf_FROM;
                    }
                }
                return INIT;
            }
        }
        ,
        R_FROM{

            @Override
            public State nextState(int b) {
                switch (b) {
                    case 111: {
                        return O_FROM;
                    }
                    case 13: {
                        return lf_FROM;
                    }
                }
                return INIT;
            }
        }
        ,
        O_FROM{

            @Override
            public State nextState(int b) {
                switch (b) {
                    case 109: {
                        return M_FROM;
                    }
                    case 13: {
                        return lf_FROM;
                    }
                }
                return INIT;
            }
        }
        ,
        M_FROM{

            @Override
            public State nextState(int b) {
                switch (b) {
                    case 32: {
                        return SPACE_FROM;
                    }
                    case 13: {
                        return lf_FROM;
                    }
                }
                return INIT;
            }
        }
        ,
        SPACE_FROM{

            @Override
            public State nextState(int b) {
                switch (b) {
                    case 13: {
                        return lf_FROM;
                    }
                }
                return INIT;
            }
        };


        public abstract State nextState(int var1);
    }
}

