/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail;

import android.content.Context;
import com.fsck.k9.mail.Message;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.ServerSettings;
import com.fsck.k9.mail.ssl.DefaultTrustedSocketFactory;
import com.fsck.k9.mail.store.StoreConfig;
import com.fsck.k9.mail.transport.SmtpTransport;
import com.fsck.k9.mail.transport.WebDavTransport;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public abstract class Transport {
    protected static final int SOCKET_CONNECT_TIMEOUT = 10000;
    protected static final int SOCKET_READ_TIMEOUT = 300000;

    public static synchronized Transport getInstance(Context context, StoreConfig storeConfig) throws MessagingException {
        String uri = storeConfig.getTransportUri();
        if (uri.startsWith("smtp")) {
            return new SmtpTransport(storeConfig, new DefaultTrustedSocketFactory(context));
        }
        if (uri.startsWith("webdav")) {
            return new WebDavTransport(storeConfig);
        }
        throw new MessagingException("Unable to locate an applicable Transport for " + uri);
    }

    public static ServerSettings decodeTransportUri(String uri) {
        if (uri.startsWith("smtp")) {
            return SmtpTransport.decodeUri(uri);
        }
        if (uri.startsWith("webdav")) {
            return WebDavTransport.decodeUri(uri);
        }
        throw new IllegalArgumentException("Not a valid transport URI");
    }

    public static String createTransportUri(ServerSettings server) {
        if (ServerSettings.Type.SMTP == server.type) {
            return SmtpTransport.createUri(server);
        }
        if (ServerSettings.Type.WebDAV == server.type) {
            return WebDavTransport.createUri(server);
        }
        throw new IllegalArgumentException("Not a valid transport URI");
    }

    public abstract void open() throws MessagingException;

    public abstract void sendMessage(Message var1) throws MessagingException;

    public abstract void close();

    protected static String encodeUtf8(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not found");
        }
    }

    protected static String decodeUtf8(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not found");
        }
    }
}

