/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail;

import com.fsck.k9.mail.AuthType;
import com.fsck.k9.mail.ConnectionSecurity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ServerSettings {
    public final Type type;
    public final String host;
    public final int port;
    public final ConnectionSecurity connectionSecurity;
    public final AuthType authenticationType;
    public final String username;
    public final String password;
    public final String clientCertificateAlias;
    private final Map<String, String> extra;

    public ServerSettings(Type type, String host, int port, ConnectionSecurity connectionSecurity, AuthType authenticationType, String username, String password, String clientCertificateAlias) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.connectionSecurity = connectionSecurity;
        this.authenticationType = authenticationType;
        this.username = username;
        this.password = password;
        this.clientCertificateAlias = clientCertificateAlias;
        this.extra = null;
    }

    public ServerSettings(Type type, String host, int port, ConnectionSecurity connectionSecurity, AuthType authenticationType, String username, String password, String clientCertificateAlias, Map<String, String> extra) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.connectionSecurity = connectionSecurity;
        this.authenticationType = authenticationType;
        this.username = username;
        this.password = password;
        this.clientCertificateAlias = clientCertificateAlias;
        this.extra = extra != null ? Collections.unmodifiableMap(new HashMap<String, String>(extra)) : null;
    }

    public ServerSettings(Type type) {
        this.type = type;
        this.host = null;
        this.port = -1;
        this.connectionSecurity = ConnectionSecurity.NONE;
        this.authenticationType = null;
        this.username = null;
        this.password = null;
        this.clientCertificateAlias = null;
        this.extra = null;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    protected void putIfNotNull(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    public ServerSettings newPassword(String newPassword) {
        return new ServerSettings(this.type, this.host, this.port, this.connectionSecurity, this.authenticationType, this.username, newPassword, this.clientCertificateAlias);
    }

    public ServerSettings newClientCertificateAlias(String newAlias) {
        return new ServerSettings(this.type, this.host, this.port, this.connectionSecurity, AuthType.EXTERNAL, this.username, this.password, newAlias);
    }

    public static enum Type {
        IMAP(143, 993),
        SMTP(587, 465),
        WebDAV(80, 443),
        POP3(110, 995);

        public final int defaultPort;
        public final int defaultTlsPort;

        private Type(int defaultPort, int defaultTlsPort) {
            this.defaultPort = defaultPort;
            this.defaultTlsPort = defaultTlsPort;
        }
    }
}

