/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail;

import android.support.annotation.NonNull;
import android.util.Log;
import com.fsck.k9.mail.Address;
import com.fsck.k9.mail.Body;
import com.fsck.k9.mail.Flag;
import com.fsck.k9.mail.Folder;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.Part;
import com.fsck.k9.mail.filter.CountingOutputStream;
import com.fsck.k9.mail.filter.EOLConvertingOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;

public abstract class Message
implements Part,
Body {
    protected String mUid;
    private Set<Flag> mFlags = EnumSet.noneOf(Flag.class);
    private Date mInternalDate;
    protected Folder mFolder;

    public boolean olderThan(Date earliestDate) {
        if (earliestDate == null) {
            return false;
        }
        Date myDate = this.getSentDate();
        if (myDate == null) {
            myDate = this.getInternalDate();
        }
        if (myDate != null) {
            return myDate.before(earliestDate);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        return this.getUid().equals(other.getUid()) && this.getFolder().getName().equals(other.getFolder().getName());
    }

    public int hashCode() {
        int MULTIPLIER = 31;
        int result = 1;
        result = 31 * result + this.mFolder.getName().hashCode();
        result = 31 * result + this.mUid.hashCode();
        return result;
    }

    public String getUid() {
        return this.mUid;
    }

    public void setUid(String uid) {
        this.mUid = uid;
    }

    public Folder getFolder() {
        return this.mFolder;
    }

    public abstract String getSubject();

    public abstract void setSubject(String var1);

    public Date getInternalDate() {
        return this.mInternalDate;
    }

    public void setInternalDate(Date internalDate) {
        this.mInternalDate = internalDate;
    }

    public abstract Date getSentDate();

    public abstract void setSentDate(Date var1, boolean var2);

    public abstract Address[] getRecipients(RecipientType var1);

    public abstract void setRecipients(RecipientType var1, Address[] var2);

    public void setRecipient(RecipientType type, Address address) {
        this.setRecipients(type, new Address[]{address});
    }

    public abstract Address[] getFrom();

    public abstract void setFrom(Address var1);

    public abstract Address[] getReplyTo();

    public abstract void setReplyTo(Address[] var1);

    public abstract String getMessageId();

    public abstract void setInReplyTo(String var1);

    public abstract String[] getReferences();

    public abstract void setReferences(String var1);

    @Override
    public abstract Body getBody();

    @Override
    public abstract void addHeader(String var1, String var2);

    @Override
    public abstract void addRawHeader(String var1, String var2);

    @Override
    public abstract void setHeader(String var1, String var2);

    @Override
    @NonNull
    public abstract String[] getHeader(String var1);

    public abstract Set<String> getHeaderNames();

    @Override
    public abstract void removeHeader(String var1);

    @Override
    public abstract void setBody(Body var1);

    public abstract long getId();

    public abstract boolean hasAttachments();

    public abstract int getSize();

    public void delete(String trashFolderName) throws MessagingException {
    }

    public Set<Flag> getFlags() {
        return Collections.unmodifiableSet(this.mFlags);
    }

    public void setFlag(Flag flag, boolean set) throws MessagingException {
        if (set) {
            this.mFlags.add(flag);
        } else {
            this.mFlags.remove((Object)flag);
        }
    }

    public void setFlags(Set<Flag> flags, boolean set) throws MessagingException {
        for (Flag flag : flags) {
            this.setFlag(flag, set);
        }
    }

    public boolean isSet(Flag flag) {
        return this.mFlags.contains((Object)flag);
    }

    public void destroy() throws MessagingException {
    }

    @Override
    public abstract void setEncoding(String var1) throws MessagingException;

    public abstract void setCharset(String var1) throws MessagingException;

    public long calculateSize() {
        try {
            CountingOutputStream out = new CountingOutputStream();
            EOLConvertingOutputStream eolOut = new EOLConvertingOutputStream(out);
            this.writeTo(eolOut);
            eolOut.flush();
            return out.getCount();
        }
        catch (IOException e) {
            Log.e((String)"k9", (String)"Failed to calculate a message size", (Throwable)e);
        }
        catch (MessagingException e) {
            Log.e((String)"k9", (String)"Failed to calculate a message size", (Throwable)e);
        }
        return 0L;
    }

    protected void copy(Message destination) {
        destination.mUid = this.mUid;
        destination.mInternalDate = this.mInternalDate;
        destination.mFolder = this.mFolder;
        destination.mFlags = EnumSet.copyOf(this.mFlags);
    }

    public abstract Message clone();

    public static enum RecipientType {
        TO,
        CC,
        BCC;

    }
}

