/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail;

import android.util.Log;
import com.fsck.k9.mail.FetchProfile;
import com.fsck.k9.mail.Flag;
import com.fsck.k9.mail.K9MailLib;
import com.fsck.k9.mail.Message;
import com.fsck.k9.mail.MessageRetrievalListener;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.Part;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Folder<T extends Message> {
    private String status = null;
    private long lastChecked = 0L;
    private long lastPush = 0L;
    public static final int OPEN_MODE_RW = 0;
    public static final int OPEN_MODE_RO = 1;

    public abstract void open(int var1) throws MessagingException;

    public abstract void close();

    public abstract boolean isOpen();

    public abstract int getMode();

    public abstract boolean create(FolderType var1) throws MessagingException;

    public boolean create(FolderType type, int displayLimit) throws MessagingException {
        return this.create(type);
    }

    public abstract boolean exists() throws MessagingException;

    public abstract int getMessageCount() throws MessagingException;

    public abstract int getUnreadMessageCount() throws MessagingException;

    public abstract int getFlaggedMessageCount() throws MessagingException;

    public abstract T getMessage(String var1) throws MessagingException;

    public abstract List<T> getMessages(int var1, int var2, Date var3, MessageRetrievalListener<T> var4) throws MessagingException;

    public abstract boolean areMoreMessagesAvailable(int var1, Date var2) throws IOException, MessagingException;

    public abstract Map<String, String> appendMessages(List<? extends Message> var1) throws MessagingException;

    public Map<String, String> copyMessages(List<? extends Message> msgs, Folder folder) throws MessagingException {
        return null;
    }

    public Map<String, String> moveMessages(List<? extends Message> msgs, Folder folder) throws MessagingException {
        return null;
    }

    public void delete(List<? extends Message> msgs, String trashFolderName) throws MessagingException {
        for (Message message : msgs) {
            T myMessage = this.getMessage(message.getUid());
            ((Message)myMessage).delete(trashFolderName);
        }
    }

    public abstract void setFlags(List<? extends Message> var1, Set<Flag> var2, boolean var3) throws MessagingException;

    public abstract void setFlags(Set<Flag> var1, boolean var2) throws MessagingException;

    public abstract String getUidFromMessageId(Message var1) throws MessagingException;

    public void expunge() throws MessagingException {
    }

    public abstract void fetch(List<T> var1, FetchProfile var2, MessageRetrievalListener<T> var3) throws MessagingException;

    public void fetchPart(Message message, Part part, MessageRetrievalListener<Message> listener) throws MessagingException {
        if (K9MailLib.isDebug()) {
            Log.d((String)"k9", (String)"fetchPart() not implemented.");
        }
    }

    public abstract void delete(boolean var1) throws MessagingException;

    public abstract String getName();

    public String getNewPushState(String oldPushState, Message message) {
        return null;
    }

    public boolean isFlagSupported(Flag flag) {
        return true;
    }

    public boolean supportsFetchingFlags() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public long getLastChecked() {
        return this.lastChecked;
    }

    public void setLastChecked(long lastChecked) throws MessagingException {
        this.lastChecked = lastChecked;
    }

    public long getLastPush() {
        return this.lastPush;
    }

    public void setLastPush(long lastCheckedDisplay) throws MessagingException {
        this.lastPush = lastCheckedDisplay;
    }

    public long getLastUpdate() {
        return Math.max(this.getLastChecked(), this.getLastPush());
    }

    public FolderClass getDisplayClass() {
        return FolderClass.NO_CLASS;
    }

    public FolderClass getSyncClass() {
        return this.getDisplayClass();
    }

    public FolderClass getPushClass() {
        return this.getSyncClass();
    }

    public boolean isInTopGroup() {
        return false;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) throws MessagingException {
        this.status = status;
    }

    public List<T> search(String queryString, Set<Flag> requiredFlags, Set<Flag> forbiddenFlags) throws MessagingException {
        throw new MessagingException("K-9 does not support searches on this folder type");
    }

    public static enum FolderType {
        HOLDS_FOLDERS,
        HOLDS_MESSAGES;

    }

    public static enum FolderClass {
        NONE,
        NO_CLASS,
        INHERITED,
        FIRST_CLASS,
        SECOND_CLASS;

    }
}

