/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail;

import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.filter.Base64;
import com.fsck.k9.mail.filter.Hex;
import java.security.MessageDigest;

public class Authentication {
    private static final String US_ASCII = "US-ASCII";

    public static String computeCramMd5(String username, String password, String b64Nonce) throws MessagingException {
        try {
            byte[] b64NonceBytes = b64Nonce.getBytes(US_ASCII);
            byte[] b64CRAM = Authentication.computeCramMd5Bytes(username, password, b64NonceBytes);
            return new String(b64CRAM, US_ASCII);
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException("This shouldn't happen", e);
        }
    }

    public static byte[] computeCramMd5Bytes(String username, String password, byte[] b64Nonce) throws MessagingException {
        try {
            byte[] nonce = Base64.decodeBase64(b64Nonce);
            byte[] secretBytes = password.getBytes();
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (secretBytes.length > 64) {
                secretBytes = md.digest(secretBytes);
            }
            byte[] ipad = new byte[64];
            byte[] opad = new byte[64];
            System.arraycopy(secretBytes, 0, ipad, 0, secretBytes.length);
            System.arraycopy(secretBytes, 0, opad, 0, secretBytes.length);
            int i = 0;
            while (i < ipad.length) {
                int n = i++;
                ipad[n] = (byte)(ipad[n] ^ 0x36);
            }
            i = 0;
            while (i < opad.length) {
                int n = i++;
                opad[n] = (byte)(opad[n] ^ 0x5C);
            }
            md.update(ipad);
            byte[] firstPass = md.digest(nonce);
            md.update(opad);
            byte[] result = md.digest(firstPass);
            String plainCRAM = username + " " + new String(Hex.encodeHex(result));
            byte[] b64CRAM = Base64.encodeBase64(plainCRAM.getBytes());
            return b64CRAM;
        }
        catch (Exception e) {
            throw new MessagingException("Something went wrong during CRAM-MD5 computation", e);
        }
    }
}

