/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.accessors;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.github.jamm.CannotAccessFieldException;
import org.github.jamm.accessors.FieldAccessor;
import sun.misc.Unsafe;

final class JpmsAccessor
implements FieldAccessor {
    private final MethodHandle trySetAccessibleMH;
    private final Unsafe unsafe;

    public JpmsAccessor(MethodHandle trySetAccessibleMH, Unsafe unsafe) {
        this.trySetAccessibleMH = trySetAccessibleMH;
        this.unsafe = unsafe;
    }

    @Override
    public Object getFieldValue(Object object, Field field) {
        try {
            if (this.trySetAccessibleMH.invoke(field)) {
                return field.get(object);
            }
            if (this.unsafe == null) {
                throw new CannotAccessFieldException("The value of the '" + field.getName() + "' field from " + object.getClass().getName() + " cannot be retrieved as the field cannot be made accessible and Unsafe is unavailable");
            }
            long offset = this.unsafe.objectFieldOffset(field);
            boolean isFinal = Modifier.isFinal(field.getModifiers());
            boolean isVolatile = Modifier.isVolatile(field.getModifiers());
            return isFinal || isVolatile ? this.unsafe.getObjectVolatile(object, offset) : this.unsafe.getObject(object, offset);
        }
        catch (Throwable e) {
            throw new CannotAccessFieldException("The value of the '" + field.getName() + "' field from " + object.getClass().getName() + " cannot be retrieved", e);
        }
    }
}

