/*
 * Decompiled with CFR 0.152.
 */
package com.github.javierugarte.searchtoolbar;

import android.content.Context;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.github.javierugarte.searchtoolbar.R;
import com.github.javierugarte.searchtoolbar.SearchToolbarListener;
import com.github.javierugarte.searchtoolbar.utils.InputUtils;

public class SearchToolbar
extends Toolbar {
    private EditText keyword;
    private ImageButton clear;
    private SearchToolbarListener listener;
    private LinearLayout containerSearch;
    private TextWatcher textWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            if (SearchToolbar.this.listener != null) {
                if (s.length() == 0) {
                    SearchToolbar.this.listener.onClear();
                } else {
                    SearchToolbar.this.listener.onSearch(s.toString());
                }
            }
        }
    };

    public SearchToolbar(Context context) {
        super(context);
        this.init();
    }

    public SearchToolbar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SearchToolbar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setSearchToolbarListener(SearchToolbarListener listener) {
        this.listener = listener;
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.search_toolbar, (ViewGroup)this, true);
        this.keyword = (EditText)this.findViewById(R.id.search_keyword);
        this.clear = (ImageButton)this.findViewById(R.id.reset_button);
        this.containerSearch = (LinearLayout)this.findViewById(R.id.container_search);
        this.clear.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchToolbar.this.keyword.setText((CharSequence)"");
            }
        });
        this.showSearch();
    }

    public void setHint(int hint) {
        this.keyword.setHint(hint);
    }

    public void setHint(CharSequence hint) {
        this.keyword.setHint(hint);
    }

    private void showSearch() {
        this.containerSearch.setVisibility(0);
        this.keyword.addTextChangedListener(this.textWatcher);
        this.keyword.requestFocus();
        InputUtils.showKeyboard(this.getContext(), this.keyword);
        if (this.listener != null) {
            this.listener.onSearch(this.keyword.getText().toString());
        }
    }
}

