/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.jdpay;

import cn.hutool.core.util.StrUtil;
import com.ijpay.jdpay.JdPayApiConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JdPayApiConfigKit {
    private static final ThreadLocal<String> TL = new ThreadLocal();
    private static final Map<String, JdPayApiConfig> CFG_MAP = new ConcurrentHashMap<String, JdPayApiConfig>();
    private static final String DEFAULT_CFG_KEY = "_default_key_";

    public static JdPayApiConfig putApiConfig(JdPayApiConfig jdPayApiConfig) {
        if (CFG_MAP.size() == 0) {
            CFG_MAP.put(DEFAULT_CFG_KEY, jdPayApiConfig);
        }
        return CFG_MAP.put(jdPayApiConfig.getAppId(), jdPayApiConfig);
    }

    public static JdPayApiConfig setThreadLocalJdPayApiConfig(JdPayApiConfig jdPayApiConfig) {
        if (StrUtil.isNotEmpty((CharSequence)jdPayApiConfig.getAppId())) {
            JdPayApiConfigKit.setThreadLocalAppId(jdPayApiConfig.getAppId());
        }
        return JdPayApiConfigKit.putApiConfig(jdPayApiConfig);
    }

    public static JdPayApiConfig removeApiConfig(JdPayApiConfig jdPayApiConfig) {
        return JdPayApiConfigKit.removeApiConfig(jdPayApiConfig.getAppId());
    }

    public static JdPayApiConfig removeApiConfig(String appId) {
        return CFG_MAP.remove(appId);
    }

    public static void setThreadLocalAppId(String appId) {
        if (StrUtil.isEmpty((CharSequence)appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getAppId();
        }
        TL.set(appId);
    }

    public static void removeThreadLocalAppId() {
        TL.remove();
    }

    public static String getAppId() {
        String appId = TL.get();
        if (StrUtil.isEmpty((CharSequence)appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getAppId();
        }
        return appId;
    }

    public static JdPayApiConfig getJdPayApiConfig() {
        String appId = JdPayApiConfigKit.getAppId();
        return JdPayApiConfigKit.getApiConfig(appId);
    }

    public static JdPayApiConfig getApiConfig(String appId) {
        JdPayApiConfig cfg = CFG_MAP.get(appId);
        if (cfg == null) {
            throw new IllegalStateException("\u9700\u4e8b\u5148\u8c03\u7528 JdPayApiConfigKit.putApiConfig(jdPayApiConfig) \u5c06 appId \u5bf9\u5e94\u7684 jdPayApiConfig \u5bf9\u8c61\u5b58\u5165\uff0c\u624d\u53ef\u4ee5\u4f7f\u7528 JdPayApiConfigKit.getJdPayApiConfig() \u7684\u7cfb\u5217\u65b9\u6cd5");
        }
        return cfg;
    }
}

