/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typesolvers;

import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import java.util.Optional;

public class ReflectionTypeSolver
implements TypeSolver {
    private TypeSolver parent;
    private final boolean jreOnly;

    public ReflectionTypeSolver(boolean jreOnly) {
        this.jreOnly = jreOnly;
    }

    public ReflectionTypeSolver() {
        this(true);
    }

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        this.parent = parent;
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        if (!this.jreOnly || name.startsWith("java.") || name.startsWith("javax.")) {
            try {
                ClassLoader classLoader = ReflectionTypeSolver.class.getClassLoader();
                if (classLoader == null) {
                    throw new RuntimeException("The ReflectionTypeSolver has been probably loaded through the bootstrap class loader. This usage is not supported by the JavaSymbolSolver");
                }
                Class<?> clazz = classLoader.loadClass(name);
                return SymbolReference.solved((ResolvedDeclaration)ReflectionFactory.typeDeclarationFor(clazz, this.getRoot()));
            }
            catch (ClassNotFoundException e) {
                int lastDot = name.lastIndexOf(46);
                if (lastDot == -1) {
                    return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
                }
                String parentName = name.substring(0, lastDot);
                String childName = name.substring(lastDot + 1);
                SymbolReference<ResolvedReferenceTypeDeclaration> parent = this.tryToSolveType(parentName);
                if (parent.isSolved()) {
                    Optional<ResolvedReferenceTypeDeclaration> innerClass = ((ResolvedReferenceTypeDeclaration)parent.getCorrespondingDeclaration()).internalTypes().stream().filter(it -> it.getName().equals(childName)).findFirst();
                    if (innerClass.isPresent()) {
                        return SymbolReference.solved((ResolvedDeclaration)((ResolvedDeclaration)innerClass.get()));
                    }
                    return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
                }
                return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
            }
        }
        return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
    }
}

