/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typesolvers;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseStart;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Providers;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class JavaParserTypeSolver
implements TypeSolver {
    private final Path srcDir;
    private final JavaParser javaParser;
    private TypeSolver parent;
    private final Cache<Path, Optional<CompilationUnit>> parsedFiles = CacheBuilder.newBuilder().softValues().build();
    private final Cache<Path, List<CompilationUnit>> parsedDirectories = CacheBuilder.newBuilder().softValues().build();
    private final Cache<String, SymbolReference<ResolvedReferenceTypeDeclaration>> foundTypes = CacheBuilder.newBuilder().softValues().build();

    public JavaParserTypeSolver(File srcDir) {
        this(srcDir.toPath());
    }

    public JavaParserTypeSolver(String srcDir) {
        this(new File(srcDir));
    }

    public JavaParserTypeSolver(File srcDir, ParserConfiguration parserConfiguration) {
        this(srcDir.toPath(), parserConfiguration);
    }

    public JavaParserTypeSolver(String srcDir, ParserConfiguration parserConfiguration) {
        this(new File(srcDir), parserConfiguration);
    }

    public JavaParserTypeSolver(Path srcDir, ParserConfiguration parserConfiguration) {
        if (!Files.exists(srcDir, new LinkOption[0]) || !Files.isDirectory(srcDir, new LinkOption[0])) {
            throw new IllegalStateException("SrcDir does not exist or is not a directory: " + srcDir);
        }
        this.srcDir = srcDir;
        this.javaParser = new JavaParser(parserConfiguration);
    }

    public JavaParserTypeSolver(Path srcDir) {
        this(srcDir, new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.BLEEDING_EDGE));
    }

    public String toString() {
        return "JavaParserTypeSolver{srcDir=" + this.srcDir + ", parent=" + this.parent + '}';
    }

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        this.parent = parent;
    }

    private Optional<CompilationUnit> parse(Path srcFile) {
        try {
            return (Optional)this.parsedFiles.get((Object)srcFile.toAbsolutePath(), () -> {
                try {
                    if (!Files.exists(srcFile, new LinkOption[0])) {
                        return Optional.empty();
                    }
                    return this.javaParser.parse(ParseStart.COMPILATION_UNIT, Providers.provider((Path)srcFile)).getResult().map(cu -> cu.setStorage(srcFile));
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Issue while parsing while type solving: " + srcFile.toAbsolutePath(), e);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private List<CompilationUnit> parseDirectory(Path srcDirectory) {
        try {
            return (List)this.parsedDirectories.get((Object)srcDirectory.toAbsolutePath(), () -> {
                ArrayList units = new ArrayList();
                if (Files.exists(srcDirectory, new LinkOption[0])) {
                    Files.newDirectoryStream(srcDirectory).forEach(file -> {
                        if (file.getFileName().toString().toLowerCase().endsWith(".java")) {
                            this.parse((Path)file).ifPresent(units::add);
                        }
                    });
                }
                return units;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        try {
            return (SymbolReference)this.foundTypes.get((Object)name, () -> {
                SymbolReference<ResolvedReferenceTypeDeclaration> result = this.tryToSolveTypeUncached(name);
                if (result.isSolved()) {
                    return SymbolReference.solved((ResolvedDeclaration)result.getCorrespondingDeclaration());
                }
                return result;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveTypeUncached(String name) {
        String[] nameElements = name.split("\\.");
        for (int i = nameElements.length; i > 0; --i) {
            Optional<TypeDeclaration<?>> astTypeDeclaration;
            StringBuilder filePath = new StringBuilder(this.srcDir.toAbsolutePath().toString());
            for (int j = 0; j < i; ++j) {
                filePath.append("/").append(nameElements[j]);
            }
            filePath.append(".java");
            StringBuilder typeName = new StringBuilder();
            for (int j = i - 1; j < nameElements.length; ++j) {
                if (j != i - 1) {
                    typeName.append(".");
                }
                typeName.append(nameElements[j]);
            }
            Path srcFile = Paths.get(filePath.toString(), new String[0]);
            Optional<CompilationUnit> compilationUnit = this.parse(srcFile);
            if (compilationUnit.isPresent() && (astTypeDeclaration = Navigator.findType(compilationUnit.get(), typeName.toString())).isPresent()) {
                return SymbolReference.solved((ResolvedDeclaration)JavaParserFacade.get(this).getTypeDeclaration(astTypeDeclaration.get()));
            }
            List<CompilationUnit> compilationUnits = this.parseDirectory(srcFile.getParent());
            for (CompilationUnit compilationUnit2 : compilationUnits) {
                Optional<TypeDeclaration<?>> astTypeDeclaration2 = Navigator.findType(compilationUnit2, typeName.toString());
                if (!astTypeDeclaration2.isPresent()) continue;
                return SymbolReference.solved((ResolvedDeclaration)JavaParserFacade.get(this).getTypeDeclaration(astTypeDeclaration2.get()));
            }
        }
        return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
    }
}

