/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.resolution.types.ResolvedVoidType;
import com.github.javaparser.resolution.types.ResolvedWildcard;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistClassDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistInterfaceDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;

class JavassistUtils {
    JavassistUtils() {
    }

    static Optional<MethodUsage> getMethodUsage(CtClass ctClass, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver, Context invokationContext) {
        CtMethod[] ctMethodArray = ctClass.getDeclaredMethods();
        int n = ctMethodArray.length;
        for (int i = 0; i < n; ++i) {
            CtMethod method = ctMethodArray[i];
            if (!method.getName().equals(name)) continue;
            MethodUsage methodUsage = new MethodUsage((ResolvedMethodDeclaration)new JavassistMethodDeclaration(method, typeSolver));
            if (argumentsTypes.size() < methodUsage.getNoParams()) continue;
            try {
                if (method.getGenericSignature() != null) {
                    SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature((String)method.getGenericSignature());
                    List<ResolvedType> parametersOfReturnType = JavassistUtils.parseTypeParameters(methodSignature.getReturnType().toString(), typeSolver, invokationContext);
                    ResolvedType newReturnType = methodUsage.returnType();
                    if (newReturnType.isReferenceType() && parametersOfReturnType.size() > 0) {
                        newReturnType = newReturnType.asReferenceType().transformTypeParameters(tp -> (ResolvedType)parametersOfReturnType.remove(0));
                    }
                    methodUsage = methodUsage.replaceReturnType(newReturnType);
                }
                return Optional.of(methodUsage);
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Optional<MethodUsage> ref;
            CtClass superClass = ctClass.getSuperclass();
            if (superClass != null && (ref = new JavassistClassDeclaration(superClass, typeSolver).solveMethodAsUsage(name, argumentsTypes, typeSolver, invokationContext, null)).isPresent()) {
                return ref;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            for (CtClass interfaze : ctClass.getInterfaces()) {
                Optional<MethodUsage> ref = new JavassistInterfaceDeclaration(interfaze, typeSolver).solveMethodAsUsage(name, argumentsTypes, typeSolver, invokationContext, null);
                if (!ref.isPresent()) continue;
                return ref;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return Optional.empty();
    }

    private static List<ResolvedType> parseTypeParameters(String signature, TypeSolver typeSolver, Context invokationContext) {
        String originalSignature = signature;
        if (signature.contains("<")) {
            if (!(signature = signature.substring(signature.indexOf(60) + 1)).endsWith(">")) {
                throw new IllegalArgumentException();
            }
            if ((signature = signature.substring(0, signature.length() - 1)).contains(",")) {
                throw new UnsupportedOperationException();
            }
            if (signature.startsWith("?")) {
                ArrayList<ResolvedType> types = new ArrayList<ResolvedType>();
                types.add((ResolvedType)ResolvedWildcard.UNBOUNDED);
                return types;
            }
            List<ResolvedType> typeParameters = JavassistUtils.parseTypeParameters(signature, typeSolver, invokationContext);
            if (signature.contains("<")) {
                signature = signature.substring(0, signature.indexOf(60));
            }
            if (signature.contains(">")) {
                throw new UnsupportedOperationException();
            }
            ResolvedType type = new SymbolSolver(typeSolver).solveTypeUsage(signature, invokationContext);
            if (type.isReferenceType() && typeParameters.size() > 0) {
                type = type.asReferenceType().transformTypeParameters(tp -> (ResolvedType)typeParameters.remove(0));
            }
            ArrayList<ResolvedType> types = new ArrayList<ResolvedType>();
            types.add(type);
            return types;
        }
        return Collections.emptyList();
    }

    static ResolvedType signatureTypeToType(SignatureAttribute.Type signatureType, TypeSolver typeSolver, ResolvedTypeParametrizable typeParametrizable) {
        if (signatureType instanceof SignatureAttribute.ClassType) {
            SignatureAttribute.ClassType classType = (SignatureAttribute.ClassType)signatureType;
            List<ResolvedType> typeArguments = classType.getTypeArguments() == null ? Collections.emptyList() : Arrays.stream(classType.getTypeArguments()).map(ta -> JavassistUtils.typeArgumentToType(ta, typeSolver, typeParametrizable)).collect(Collectors.toList());
            String typeName = classType.getDeclaringClass() != null ? classType.getDeclaringClass().getName() + "." + classType.getName() : classType.getName();
            ResolvedReferenceTypeDeclaration typeDeclaration = typeSolver.solveType(JavassistUtils.removeTypeArguments(JavassistUtils.internalNameToCanonicalName(typeName)));
            return new ReferenceTypeImpl(typeDeclaration, typeArguments, typeSolver);
        }
        if (signatureType instanceof SignatureAttribute.TypeVariable) {
            SignatureAttribute.TypeVariable typeVariableSignature = (SignatureAttribute.TypeVariable)signatureType;
            Optional typeParameterDeclarationOpt = typeParametrizable.findTypeParameter(typeVariableSignature.getName());
            if (!typeParameterDeclarationOpt.isPresent()) {
                throw new UnsolvedSymbolException("Unable to solve TypeVariable " + typeVariableSignature);
            }
            ResolvedTypeParameterDeclaration typeParameterDeclaration = (ResolvedTypeParameterDeclaration)typeParameterDeclarationOpt.get();
            return new ResolvedTypeVariable(typeParameterDeclaration);
        }
        if (signatureType instanceof SignatureAttribute.ArrayType) {
            SignatureAttribute.ArrayType arrayType = (SignatureAttribute.ArrayType)signatureType;
            return new ResolvedArrayType(JavassistUtils.signatureTypeToType(arrayType.getComponentType(), typeSolver, typeParametrizable));
        }
        if (signatureType instanceof SignatureAttribute.BaseType) {
            SignatureAttribute.BaseType baseType = (SignatureAttribute.BaseType)signatureType;
            if (baseType.toString().equals("void")) {
                return ResolvedVoidType.INSTANCE;
            }
            return ResolvedPrimitiveType.byName((String)baseType.toString());
        }
        throw new RuntimeException(signatureType.getClass().getCanonicalName());
    }

    private static String removeTypeArguments(String typeName) {
        if (typeName.contains("<")) {
            return typeName.substring(0, typeName.indexOf(60));
        }
        return typeName;
    }

    static String internalNameToCanonicalName(String typeName) {
        return typeName.replaceAll("\\$", ".");
    }

    private static ResolvedType objectTypeArgumentToType(SignatureAttribute.ObjectType typeArgument, TypeSolver typeSolver, ResolvedTypeParametrizable typeParametrizable) {
        String typeName = typeArgument.jvmTypeName();
        Optional<ResolvedType> type = JavassistUtils.getGenericParameterByName(typeName, typeParametrizable);
        return type.orElseGet(() -> new ReferenceTypeImpl(typeSolver.solveType(JavassistUtils.removeTypeArguments(JavassistUtils.internalNameToCanonicalName(typeName))), typeSolver));
    }

    private static Optional<ResolvedType> getGenericParameterByName(String typeName, ResolvedTypeParametrizable typeParametrizable) {
        Optional tp = typeParametrizable.findTypeParameter(typeName);
        return tp.map(ResolvedTypeVariable::new);
    }

    private static ResolvedType typeArgumentToType(SignatureAttribute.TypeArgument typeArgument, TypeSolver typeSolver, ResolvedTypeParametrizable typeParametrizable) {
        if (typeArgument.isWildcard()) {
            if (typeArgument.getType() == null) {
                return ResolvedWildcard.UNBOUNDED;
            }
            if (typeArgument.getKind() == '+') {
                return ResolvedWildcard.extendsBound((ResolvedType)JavassistUtils.objectTypeArgumentToType(typeArgument.getType(), typeSolver, typeParametrizable));
            }
            if (typeArgument.getKind() == '-') {
                return ResolvedWildcard.superBound((ResolvedType)JavassistUtils.objectTypeArgumentToType(typeArgument.getType(), typeSolver, typeParametrizable));
            }
            throw new UnsupportedOperationException();
        }
        return JavassistUtils.objectTypeArgumentToType(typeArgument.getType(), typeSolver, typeParametrizable);
    }

    static Optional<String> extractParameterName(CtBehavior method, int paramNumber) {
        LocalVariableAttribute attr;
        MethodInfo methodInfo = method.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute != null && (attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable")) != null) {
            int pos = Modifier.isStatic((int)method.getModifiers()) ? 0 : 1;
            return Optional.ofNullable(attr.variableName(paramNumber + pos));
        }
        return Optional.empty();
    }
}

