/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.declarations;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.resolution.declarations.ResolvedClassDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.Helper;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserConstructorDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserFieldDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserMethodDeclaration;
import com.github.javaparser.symbolsolver.logic.AbstractClassDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class JavaParserAnonymousClassDeclaration
extends AbstractClassDeclaration {
    private final TypeSolver typeSolver;
    private final ObjectCreationExpr wrappedNode;
    private final ResolvedTypeDeclaration superTypeDeclaration;
    private final String name = "Anonymous-" + UUID.randomUUID();

    public JavaParserAnonymousClassDeclaration(ObjectCreationExpr wrappedNode, TypeSolver typeSolver) {
        this.typeSolver = typeSolver;
        this.wrappedNode = wrappedNode;
        this.superTypeDeclaration = (ResolvedTypeDeclaration)JavaParserFactory.getContext((Node)wrappedNode.getParentNode().get(), typeSolver).solveType(wrappedNode.getType().getName().getId(), typeSolver).getCorrespondingDeclaration();
    }

    public ResolvedTypeDeclaration getSuperTypeDeclaration() {
        return this.superTypeDeclaration;
    }

    public <T extends Node> List<T> findMembersOfKind(Class<T> memberClass) {
        if (this.wrappedNode.getAnonymousClassBody().isPresent()) {
            return ((NodeList)this.wrappedNode.getAnonymousClassBody().get()).stream().filter(node -> memberClass.isAssignableFrom(node.getClass())).map(memberClass::cast).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Context getContext() {
        return JavaParserFactory.getContext((Node)this.wrappedNode, this.typeSolver);
    }

    protected ResolvedReferenceType object() {
        return new ReferenceTypeImpl(this.typeSolver.solveType(Object.class.getCanonicalName()), this.typeSolver);
    }

    public ResolvedReferenceType getSuperClass() {
        return new ReferenceTypeImpl(this.superTypeDeclaration.asReferenceType(), this.typeSolver);
    }

    public List<ResolvedReferenceType> getInterfaces() {
        return this.superTypeDeclaration.asReferenceType().getAncestors().stream().filter(type -> type.getTypeDeclaration().isInterface()).collect(Collectors.toList());
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return this.findMembersOfKind(ConstructorDeclaration.class).stream().map(ctor -> new JavaParserConstructorDeclaration((ResolvedClassDeclaration)this, (ConstructorDeclaration)ctor, this.typeSolver)).collect(Collectors.toList());
    }

    public AccessSpecifier accessSpecifier() {
        return AccessSpecifier.PRIVATE;
    }

    public List<ResolvedReferenceType> getAncestors() {
        return ImmutableList.builder().add((Object)this.getSuperClass()).addAll((Iterable)this.superTypeDeclaration.asReferenceType().getAncestors()).build();
    }

    public List<ResolvedFieldDeclaration> getAllFields() {
        List myFields = this.findMembersOfKind(FieldDeclaration.class).stream().flatMap(field -> field.getVariables().stream().map(variable -> new JavaParserFieldDeclaration((VariableDeclarator)variable, this.typeSolver))).collect(Collectors.toList());
        List superClassFields = this.getSuperClass().getTypeDeclaration().getAllFields();
        List interfaceFields = this.getInterfaces().stream().flatMap(inteface -> inteface.getTypeDeclaration().getAllFields().stream()).collect(Collectors.toList());
        return ImmutableList.builder().addAll(myFields).addAll((Iterable)superClassFields).addAll(interfaceFields).build();
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.findMembersOfKind(MethodDeclaration.class).stream().map(method -> new JavaParserMethodDeclaration((MethodDeclaration)method, this.typeSolver)).collect(Collectors.toSet());
    }

    public boolean isAssignableBy(ResolvedType type) {
        return false;
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return false;
    }

    public boolean hasDirectlyAnnotation(String qualifiedName) {
        return false;
    }

    public String getPackageName() {
        return Helper.getPackageName((Node)this.wrappedNode);
    }

    public String getClassName() {
        return Helper.getClassName("", (Node)this.wrappedNode);
    }

    public String getQualifiedName() {
        String containerName = Helper.containerName(this.wrappedNode.getParentNode().orElse(null));
        if (containerName.isEmpty()) {
            return this.getName();
        }
        return containerName + "." + this.getName();
    }

    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        return this.findMembersOfKind(TypeDeclaration.class).stream().map(typeMember -> JavaParserFacade.get(this.typeSolver).getTypeDeclaration((TypeDeclaration<?>)typeMember)).collect(Collectors.toSet());
    }

    public String getName() {
        return this.name;
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return Lists.newArrayList();
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        throw new UnsupportedOperationException("containerType is not supported for " + ((Object)((Object)this)).getClass().getCanonicalName());
    }
}

