/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.naming;

import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.ReceiverParameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.modules.ModuleDeclaration;
import com.github.javaparser.ast.modules.ModuleExportsStmt;
import com.github.javaparser.ast.modules.ModuleOpensStmt;
import com.github.javaparser.ast.modules.ModuleProvidesStmt;
import com.github.javaparser.ast.modules.ModuleRequiresStmt;
import com.github.javaparser.ast.modules.ModuleUsesStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.symbolsolver.resolution.naming.NameRole;

public class NameLogic {
    public static boolean isSimpleName(Node node) {
        return !NameLogic.isQualifiedName(node);
    }

    public static boolean isQualifiedName(Node node) {
        if (!NameLogic.isAName(node)) {
            throw new IllegalArgumentException();
        }
        return NameLogic.nameAsString(node).contains(".");
    }

    public static boolean isAName(Node node) {
        if (node instanceof FieldAccessExpr) {
            FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)node;
            return NameLogic.isAName((Node)fieldAccessExpr.getScope());
        }
        return node instanceof SimpleName || node instanceof Name || node instanceof ClassOrInterfaceType || node instanceof NameExpr;
    }

    public static NameRole classifyRole(Node name) {
        if (!NameLogic.isAName(name)) {
            throw new IllegalArgumentException("The given node is not a name");
        }
        if (!name.getParentNode().isPresent()) {
            throw new IllegalArgumentException("We cannot understand the role of a name if it has no parent");
        }
        if (NameLogic.whenParentIs(Name.class, name, (p, c) -> p.getQualifier().isPresent() && p.getQualifier().get() == c)) {
            return NameLogic.classifyRole((Node)name.getParentNode().get());
        }
        if (NameLogic.whenParentIs(PackageDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(ImportDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(MarkerAnnotationExpr.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ClassOrInterfaceDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(ClassOrInterfaceDeclaration.class, name, (p, c) -> p.getExtendedTypes().contains((Object)c) || p.getImplementedTypes().contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ClassOrInterfaceType.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(NameExpr.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(FieldAccessExpr.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(AnnotationDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(AnnotationMemberDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(AnnotationMemberDeclaration.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(MethodDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(MethodDeclaration.class, name, (p, c) -> p.getType() == c || p.getThrownExceptions().contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(Parameter.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(Parameter.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ReceiverParameter.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(MethodCallExpr.class, name, (p, c) -> p.getName() == c || p.getTypeArguments().isPresent() && ((NodeList)p.getTypeArguments().get()).contains((Object)c) || p.getScope().isPresent() && p.getScope().get() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ConstructorDeclaration.class, name, (p, c) -> p.getName() == c || p.getThrownExceptions().contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(TypeParameter.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(EnumDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(EnumConstantDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(FieldAccessExpr.class, name, (p, c) -> p.getName() == c || p.getScope() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ObjectCreationExpr.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ReturnStmt.class, name, (p, c) -> p.getExpression().isPresent() && p.getExpression().get() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleDeclaration.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(ModuleRequiresStmt.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleExportsStmt.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleExportsStmt.class, name, (p, c) -> p.getModuleNames().contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleOpensStmt.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleOpensStmt.class, name, (p, c) -> p.getModuleNames().contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleUsesStmt.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ModuleProvidesStmt.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ClassExpr.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ThisExpr.class, name, (p, c) -> p.getClassExpr().isPresent() && p.getClassExpr().get() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(SuperExpr.class, name, (p, c) -> p.getClassExpr().isPresent() && p.getClassExpr().get() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ArrayCreationExpr.class, name, (p, c) -> p.getElementType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(CastExpr.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(InstanceOfExpr.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(TypeExpr.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ArrayAccessExpr.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(UnaryExpr.class, name, (p, c) -> p.getExpression() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(AssignExpr.class, name, (p, c) -> p.getTarget() == c || p.getValue() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(TryStmt.class, name, (p, c) -> p.getResources().contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p, c) -> p.getType() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(VariableDeclarator.class, name, (p, c) -> p.getInitializer().isPresent() && p.getInitializer().get() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(MemberValuePair.class, name, (p, c) -> p.getValue() == c)) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(MemberValuePair.class, name, (p, c) -> p.getName() == c)) {
            return NameRole.DECLARATION;
        }
        if (NameLogic.whenParentIs(ExplicitConstructorInvocationStmt.class, name, (p, c) -> p.getExpression().isPresent() && p.getExpression().get() == c || p.getTypeArguments().isPresent() && ((NodeList)p.getTypeArguments().get()).contains((Object)c))) {
            return NameRole.REFERENCE;
        }
        if (NameLogic.whenParentIs(ObjectCreationExpr.class, name, (p, c) -> p.getType() == c || p.getScope().isPresent() && p.getScope().get() == c)) {
            return NameRole.REFERENCE;
        }
        if (name.getParentNode().isPresent() && NameLogic.isAName((Node)name.getParentNode().get())) {
            return NameLogic.classifyRole((Node)name.getParentNode().get());
        }
        throw new UnsupportedOperationException("Unable to classify role of name contained in " + ((Node)name.getParentNode().get()).getClass().getSimpleName());
    }

    public static String nameAsString(Node name) {
        if (!NameLogic.isAName(name)) {
            throw new IllegalArgumentException("A name was expected");
        }
        if (name instanceof Name) {
            return ((Name)name).asString();
        }
        if (name instanceof SimpleName) {
            return ((SimpleName)name).getIdentifier();
        }
        if (name instanceof ClassOrInterfaceType) {
            return ((ClassOrInterfaceType)name).asString();
        }
        if (name instanceof FieldAccessExpr) {
            FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)name;
            if (NameLogic.isAName((Node)fieldAccessExpr.getScope())) {
                return NameLogic.nameAsString((Node)fieldAccessExpr.getScope()) + "." + NameLogic.nameAsString((Node)fieldAccessExpr.getName());
            }
            throw new IllegalArgumentException();
        }
        if (name instanceof NameExpr) {
            return ((NameExpr)name).getNameAsString();
        }
        throw new UnsupportedOperationException("Unknown type of name found: " + name + " (" + name.getClass().getCanonicalName() + ")");
    }

    private static <P extends Node, C extends Node> boolean whenParentIs(Class<P> parentClass, C child, PredicateOnParentAndChild<P, C> predicate) {
        if (child.getParentNode().isPresent()) {
            Node parent = (Node)child.getParentNode().get();
            return parentClass.isInstance(parent) && predicate.isSatisfied((Node)parentClass.cast(parent), child);
        }
        return false;
    }

    private static interface PredicateOnParentAndChild<P extends Node, C extends Node> {
        public boolean isSatisfied(P var1, C var2);
    }
}

