/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedLambdaConstraintType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.resolution.types.ResolvedUnionType;
import com.github.javaparser.resolution.types.ResolvedWildcard;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.ContextHelper;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.ObjectCreationContext;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.resolution.Value;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.MethodResolutionLogic;
import com.github.javaparser.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MethodCallExprContext
extends AbstractJavaParserContext<MethodCallExpr> {
    public MethodCallExprContext(MethodCallExpr wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    @Override
    public Optional<ResolvedType> solveGenericType(String name, TypeSolver typeSolver) {
        if (((MethodCallExpr)this.wrappedNode).getScope().isPresent()) {
            ResolvedType typeOfScope = JavaParserFacade.get(typeSolver).getType((Node)((MethodCallExpr)this.wrappedNode).getScope().get());
            Optional res = typeOfScope.asReferenceType().getGenericParameterByName(name);
            return res;
        }
        return Optional.empty();
    }

    public String toString() {
        return "MethodCallExprContext{wrapped=" + this.wrappedNode + "}";
    }

    @Override
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver) {
        if (((MethodCallExpr)this.wrappedNode).getScope().isPresent()) {
            int i;
            String className;
            SymbolReference<ResolvedTypeDeclaration> ref;
            Expression scope = (Expression)((MethodCallExpr)this.wrappedNode).getScope().get();
            if (scope instanceof NameExpr && (ref = this.solveType(className = ((NameExpr)scope).getName().getId(), typeSolver)).isSolved()) {
                SymbolReference<ResolvedMethodDeclaration> m = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)ref.getCorrespondingDeclaration(), name, argumentsTypes, typeSolver);
                if (m.isSolved()) {
                    MethodUsage methodUsage = new MethodUsage((ResolvedMethodDeclaration)m.getCorrespondingDeclaration());
                    methodUsage = this.resolveMethodTypeParametersFromExplicitList(typeSolver, methodUsage);
                    methodUsage = this.resolveMethodTypeParameters(methodUsage, argumentsTypes);
                    return Optional.of(methodUsage);
                }
                throw new UnsolvedSymbolException(((ResolvedTypeDeclaration)ref.getCorrespondingDeclaration()).toString(), "Method '" + name + "' with parameterTypes " + argumentsTypes);
            }
            ResolvedType typeOfScope = JavaParserFacade.get(typeSolver).getType((Node)scope);
            HashMap<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
            for (i = 0; i < argumentsTypes.size(); ++i) {
                ResolvedType originalArgumentType = argumentsTypes.get(i);
                ResolvedType updatedArgumentType = this.usingParameterTypesFromScope(typeOfScope, originalArgumentType, inferredTypes);
                argumentsTypes.set(i, updatedArgumentType);
            }
            for (i = 0; i < argumentsTypes.size(); ++i) {
                ResolvedType updatedArgumentType = this.applyInferredTypes(argumentsTypes.get(i), inferredTypes);
                argumentsTypes.set(i, updatedArgumentType);
            }
            return this.solveMethodAsUsage(typeOfScope, name, argumentsTypes, typeSolver, (Context)this);
        }
        Context parentContext = this.getParent();
        while (parentContext instanceof MethodCallExprContext || parentContext instanceof ObjectCreationContext) {
            parentContext = parentContext.getParent();
        }
        return parentContext.solveMethodAsUsage(name, argumentsTypes, typeSolver);
    }

    private MethodUsage resolveMethodTypeParametersFromExplicitList(TypeSolver typeSolver, MethodUsage methodUsage) {
        if (((MethodCallExpr)this.wrappedNode).getTypeArguments().isPresent()) {
            ArrayList<ResolvedType> typeArguments = new ArrayList<ResolvedType>();
            for (Type ty : (NodeList)((MethodCallExpr)this.wrappedNode).getTypeArguments().get()) {
                typeArguments.add(JavaParserFacade.get(typeSolver).convertToUsage(ty));
            }
            List tyParamDecls = methodUsage.getDeclaration().getTypeParameters();
            if (tyParamDecls.size() == typeArguments.size()) {
                for (int i = 0; i < tyParamDecls.size(); ++i) {
                    methodUsage = methodUsage.replaceTypeParameter((ResolvedTypeParameterDeclaration)tyParamDecls.get(i), (ResolvedType)typeArguments.get(i));
                }
            }
        }
        return methodUsage;
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        return this.getParent().solveSymbol(name, typeSolver);
    }

    @Override
    public Optional<Value> solveSymbolAsValue(String name, TypeSolver typeSolver) {
        Context parentContext = this.getParent();
        return parentContext.solveSymbolAsValue(name, typeSolver);
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly, TypeSolver typeSolver) {
        Collection<ResolvedReferenceTypeDeclaration> rrtds = this.findTypeDeclarations(((MethodCallExpr)this.wrappedNode).getScope(), typeSolver);
        for (ResolvedReferenceTypeDeclaration rrtd : rrtds) {
            SymbolReference<ResolvedMethodDeclaration> res = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)rrtd, name, argumentsTypes, false, typeSolver);
            if (!res.isSolved()) continue;
            return res;
        }
        return SymbolReference.unsolved(ResolvedMethodDeclaration.class);
    }

    private Optional<MethodUsage> solveMethodAsUsage(ResolvedReferenceType refType, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver, Context invokationContext) {
        Optional<MethodUsage> ref = ContextHelper.solveMethodAsUsage((ResolvedTypeDeclaration)refType.getTypeDeclaration(), name, argumentsTypes, typeSolver, invokationContext, refType.typeParametersValues());
        if (ref.isPresent()) {
            MethodUsage methodUsage = ref.get();
            methodUsage = this.resolveMethodTypeParametersFromExplicitList(typeSolver, methodUsage);
            HashMap<ResolvedTypeParameterDeclaration, ResolvedType> derivedValues = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
            for (int i = 0; i < methodUsage.getParamTypes().size(); ++i) {
                ResolvedParameterDeclaration parameter = methodUsage.getDeclaration().getParam(i);
                ResolvedType parameterType = parameter.getType();
                if (parameter.isVariadic()) {
                    parameterType = parameterType.asArrayType().getComponentType();
                }
                this.inferTypes(argumentsTypes.get(i), parameterType, derivedValues);
            }
            for (Map.Entry entry : derivedValues.entrySet()) {
                methodUsage = methodUsage.replaceTypeParameter((ResolvedTypeParameterDeclaration)entry.getKey(), (ResolvedType)entry.getValue());
            }
            ResolvedType returnType = refType.useThisTypeParametersOnTheGivenType(methodUsage.returnType());
            if (returnType != methodUsage.returnType()) {
                methodUsage = methodUsage.replaceReturnType(returnType);
            }
            for (int i = 0; i < methodUsage.getParamTypes().size(); ++i) {
                ResolvedType replaced = refType.useThisTypeParametersOnTheGivenType((ResolvedType)methodUsage.getParamTypes().get(i));
                methodUsage = methodUsage.replaceParamType(i, replaced);
            }
            return Optional.of(methodUsage);
        }
        return ref;
    }

    private void inferTypes(ResolvedType source, ResolvedType target, Map<ResolvedTypeParameterDeclaration, ResolvedType> mappings) {
        if (source.equals(target)) {
            return;
        }
        if (source.isReferenceType() && target.isReferenceType()) {
            ResolvedReferenceType sourceRefType = source.asReferenceType();
            ResolvedReferenceType targetRefType = target.asReferenceType();
            if (sourceRefType.getQualifiedName().equals(targetRefType.getQualifiedName()) && !sourceRefType.isRawType() && !targetRefType.isRawType()) {
                for (int i = 0; i < sourceRefType.typeParametersValues().size(); ++i) {
                    this.inferTypes((ResolvedType)sourceRefType.typeParametersValues().get(i), (ResolvedType)targetRefType.typeParametersValues().get(i), mappings);
                }
            }
            return;
        }
        if (source.isReferenceType() && target.isWildcard()) {
            if (target.asWildcard().isBounded()) {
                this.inferTypes(source, target.asWildcard().getBoundedType(), mappings);
                return;
            }
            return;
        }
        if (source.isWildcard() && target.isWildcard()) {
            if (source.asWildcard().isBounded() && target.asWildcard().isBounded()) {
                this.inferTypes(source.asWildcard().getBoundedType(), target.asWildcard().getBoundedType(), mappings);
            }
            return;
        }
        if (source.isReferenceType() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isWildcard() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isArray() && target.isWildcard()) {
            if (target.asWildcard().isBounded()) {
                this.inferTypes(source, target.asWildcard().getBoundedType(), mappings);
                return;
            }
            return;
        }
        if (source.isArray() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isWildcard() && target.isReferenceType()) {
            if (source.asWildcard().isBounded()) {
                this.inferTypes(source.asWildcard().getBoundedType(), target, mappings);
            }
            return;
        }
        if (source.isConstraint() && target.isReferenceType()) {
            this.inferTypes(source.asConstraintType().getBound(), target, mappings);
            return;
        }
        if (source.isConstraint() && target.isTypeVariable()) {
            this.inferTypes(source.asConstraintType().getBound(), target, mappings);
            return;
        }
        if (source.isTypeVariable() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isPrimitive() || target.isPrimitive()) {
            return;
        }
        if (source.isNull()) {
            return;
        }
        throw new RuntimeException(source.describe() + " " + target.describe());
    }

    private MethodUsage resolveMethodTypeParameters(MethodUsage methodUsage, List<ResolvedType> actualParamTypes) {
        HashMap<ResolvedTypeParameterDeclaration, ResolvedType> matchedTypeParameters = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
        if (methodUsage.getDeclaration().hasVariadicParameter()) {
            if (actualParamTypes.size() == methodUsage.getDeclaration().getNumberOfParams()) {
                ResolvedType actualType;
                ResolvedType expectedType = methodUsage.getDeclaration().getLastParam().getType().asArrayType().getComponentType();
                ResolvedType resolvedType = actualType = actualParamTypes.get(actualParamTypes.size() - 1).isArray() ? actualParamTypes.get(actualParamTypes.size() - 1).asArrayType().getComponentType() : actualParamTypes.get(actualParamTypes.size() - 1);
                if (!expectedType.isAssignableBy(actualType)) {
                    for (ResolvedTypeParameterDeclaration tp : methodUsage.getDeclaration().getTypeParameters()) {
                        expectedType = MethodResolutionLogic.replaceTypeParam(expectedType, tp, this.typeSolver);
                    }
                }
                if (!expectedType.isAssignableBy(actualType)) {
                    throw new UnsupportedOperationException(String.format("Unable to resolve the type typeParametersValues in a MethodUsage. Expected type: %s, Actual type: %s. Method Declaration: %s. MethodUsage: %s", expectedType, actualType, methodUsage.getDeclaration(), methodUsage));
                }
                this.matchTypeParameters(expectedType, actualType, matchedTypeParameters);
            } else {
                return methodUsage;
            }
        }
        int until = methodUsage.getDeclaration().hasVariadicParameter() ? actualParamTypes.size() - 1 : actualParamTypes.size();
        for (int i = 0; i < until; ++i) {
            ResolvedType expectedType = methodUsage.getParamType(i);
            ResolvedType actualType = actualParamTypes.get(i);
            this.matchTypeParameters(expectedType, actualType, matchedTypeParameters);
        }
        for (ResolvedTypeParameterDeclaration tp : matchedTypeParameters.keySet()) {
            methodUsage = methodUsage.replaceTypeParameter(tp, (ResolvedType)matchedTypeParameters.get(tp));
        }
        return methodUsage;
    }

    private void matchTypeParameters(ResolvedType expectedType, ResolvedType actualType, Map<ResolvedTypeParameterDeclaration, ResolvedType> matchedTypeParameters) {
        if (expectedType.isTypeVariable()) {
            if (!actualType.isTypeVariable() && !actualType.isReferenceType()) {
                throw new UnsupportedOperationException(actualType.getClass().getCanonicalName());
            }
            matchedTypeParameters.put(expectedType.asTypeParameter(), actualType);
        } else if (expectedType.isArray()) {
            if (!actualType.isArray()) {
                throw new UnsupportedOperationException(actualType.getClass().getCanonicalName());
            }
            this.matchTypeParameters(expectedType.asArrayType().getComponentType(), actualType.asArrayType().getComponentType(), matchedTypeParameters);
        } else if (expectedType.isReferenceType()) {
            if (actualType.isReferenceType() && actualType.asReferenceType().typeParametersValues().size() > 0) {
                int i = 0;
                for (ResolvedType tp : expectedType.asReferenceType().typeParametersValues()) {
                    this.matchTypeParameters(tp, (ResolvedType)actualType.asReferenceType().typeParametersValues().get(i), matchedTypeParameters);
                    ++i;
                }
            }
        } else if (!expectedType.isPrimitive() && !expectedType.isWildcard()) {
            throw new UnsupportedOperationException(expectedType.getClass().getCanonicalName());
        }
    }

    private Optional<MethodUsage> solveMethodAsUsage(ResolvedTypeVariable tp, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver, Context invokationContext) {
        for (ResolvedTypeParameterDeclaration.Bound bound : tp.asTypeParameter().getBounds()) {
            Optional<MethodUsage> methodUsage = this.solveMethodAsUsage(bound.getType(), name, argumentsTypes, typeSolver, invokationContext);
            if (!methodUsage.isPresent()) continue;
            return methodUsage;
        }
        return Optional.empty();
    }

    private Optional<MethodUsage> solveMethodAsUsage(ResolvedType type, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver, Context invokationContext) {
        if (type instanceof ResolvedReferenceType) {
            return this.solveMethodAsUsage((ResolvedReferenceType)type, name, argumentsTypes, typeSolver, invokationContext);
        }
        if (type instanceof ResolvedTypeVariable) {
            return this.solveMethodAsUsage((ResolvedTypeVariable)type, name, argumentsTypes, typeSolver, invokationContext);
        }
        if (type instanceof ResolvedWildcard) {
            ResolvedWildcard wildcardUsage = (ResolvedWildcard)type;
            if (wildcardUsage.isSuper()) {
                return this.solveMethodAsUsage(wildcardUsage.getBoundedType(), name, argumentsTypes, typeSolver, invokationContext);
            }
            if (wildcardUsage.isExtends()) {
                throw new UnsupportedOperationException("extends wildcard");
            }
            throw new UnsupportedOperationException("unbounded wildcard");
        }
        if (type instanceof ResolvedLambdaConstraintType) {
            ResolvedLambdaConstraintType constraintType = (ResolvedLambdaConstraintType)type;
            return this.solveMethodAsUsage(constraintType.getBound(), name, argumentsTypes, typeSolver, invokationContext);
        }
        if (type instanceof ResolvedArrayType) {
            return this.solveMethodAsUsage(new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)new ReflectionClassDeclaration(Object.class, typeSolver), typeSolver), name, argumentsTypes, typeSolver, invokationContext);
        }
        if (type instanceof ResolvedUnionType) {
            Optional commonAncestor = type.asUnionType().getCommonAncestor();
            if (commonAncestor.isPresent()) {
                return this.solveMethodAsUsage((ResolvedReferenceType)commonAncestor.get(), name, argumentsTypes, typeSolver, invokationContext);
            }
            throw new UnsupportedOperationException("no common ancestor available for " + type.describe());
        }
        throw new UnsupportedOperationException("type usage: " + type.getClass().getCanonicalName());
    }

    private ResolvedType usingParameterTypesFromScope(ResolvedType scope, ResolvedType type, Map<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes) {
        if (type.isReferenceType()) {
            for (Pair entry : type.asReferenceType().getTypeParametersMap()) {
                if (!((ResolvedTypeParameterDeclaration)entry.a).declaredOnType() || !scope.asReferenceType().getGenericParameterByName(((ResolvedTypeParameterDeclaration)entry.a).getName()).isPresent()) continue;
                type = type.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, (ResolvedType)scope.asReferenceType().getGenericParameterByName(((ResolvedTypeParameterDeclaration)entry.a).getName()).get(), inferredTypes);
            }
            return type;
        }
        return type;
    }

    private ResolvedType applyInferredTypes(ResolvedType type, Map<ResolvedTypeParameterDeclaration, ResolvedType> inferredTypes) {
        for (ResolvedTypeParameterDeclaration tp : inferredTypes.keySet()) {
            type = type.replaceTypeVariables(tp, inferredTypes.get(tp), inferredTypes);
        }
        return type;
    }
}

