/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedLambdaConstraintType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import com.github.javaparser.symbolsolver.logic.FunctionalInterfaceLogic;
import com.github.javaparser.symbolsolver.logic.InferenceContext;
import com.github.javaparser.symbolsolver.logic.ObjectProvider;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.resolution.Value;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.reflectionmodel.MyObjectProvider;
import com.github.javaparser.symbolsolver.resolution.SymbolDeclarator;
import com.github.javaparser.utils.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class LambdaExprContext
extends AbstractJavaParserContext<LambdaExpr> {
    public LambdaExprContext(LambdaExpr wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    @Override
    public Optional<Value> solveSymbolAsValue(String name, TypeSolver typeSolver) {
        for (Parameter parameter : ((LambdaExpr)this.wrappedNode).getParameters()) {
            SymbolDeclarator sb = JavaParserFactory.getSymbolDeclarator((Node)parameter, typeSolver);
            int index = 0;
            for (ResolvedValueDeclaration decl : sb.getSymbolDeclarations()) {
                if (decl.getName().equals(name)) {
                    if (Navigator.getParentNode(this.wrappedNode) instanceof MethodCallExpr) {
                        MethodCallExpr methodCallExpr = (MethodCallExpr)Navigator.getParentNode(this.wrappedNode);
                        MethodUsage methodUsage = JavaParserFacade.get(typeSolver).solveMethodAsUsage(methodCallExpr);
                        int i = this.pos(methodCallExpr, (Expression)this.wrappedNode);
                        ResolvedType lambdaType = (ResolvedType)methodUsage.getParamTypes().get(i);
                        Optional functionalMethodOpt = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)lambdaType);
                        if (functionalMethodOpt.isPresent()) {
                            int lambdaParamIndex;
                            MethodUsage functionalMethod = (MethodUsage)functionalMethodOpt.get();
                            InferenceContext inferenceContext = new InferenceContext((ObjectProvider)MyObjectProvider.INSTANCE);
                            inferenceContext.addPair(lambdaType, (ResolvedType)new ReferenceTypeImpl(lambdaType.asReferenceType().getTypeDeclaration(), typeSolver));
                            boolean found = false;
                            for (lambdaParamIndex = 0; lambdaParamIndex < ((LambdaExpr)this.wrappedNode).getParameters().size(); ++lambdaParamIndex) {
                                if (!((LambdaExpr)this.wrappedNode).getParameter(lambdaParamIndex).getName().getIdentifier().equals(name)) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                return Optional.empty();
                            }
                            ResolvedType argType = inferenceContext.resolve(inferenceContext.addSingle(functionalMethod.getParamType(lambdaParamIndex)));
                            ResolvedLambdaConstraintType conType = argType.isWildcard() ? ResolvedLambdaConstraintType.bound((ResolvedType)argType.asWildcard().getBoundedType()) : ResolvedLambdaConstraintType.bound((ResolvedType)argType);
                            Value value = new Value((ResolvedType)conType, name);
                            return Optional.of(value);
                        }
                        return Optional.empty();
                    }
                    if (Navigator.getParentNode(this.wrappedNode) instanceof VariableDeclarator) {
                        VariableDeclarator variableDeclarator = (VariableDeclarator)Navigator.getParentNode(this.wrappedNode);
                        ResolvedType t = JavaParserFacade.get(typeSolver).convertToUsageVariableType(variableDeclarator);
                        Optional functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)t);
                        if (functionalMethod.isPresent()) {
                            ResolvedType lambdaType = ((MethodUsage)functionalMethod.get()).getParamType(index);
                            HashMap inferredTypes = new HashMap();
                            if (lambdaType.isReferenceType()) {
                                for (Pair entry : lambdaType.asReferenceType().getTypeParametersMap()) {
                                    if (!((ResolvedType)entry.b).isTypeVariable() || !((ResolvedType)entry.b).asTypeParameter().declaredOnType()) continue;
                                    ResolvedType ot = t.asReferenceType().typeParametersMap().getValue((ResolvedTypeParameterDeclaration)entry.a);
                                    lambdaType = lambdaType.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, ot, inferredTypes);
                                }
                            } else if (lambdaType.isTypeVariable() && lambdaType.asTypeParameter().declaredOnType()) {
                                lambdaType = t.asReferenceType().typeParametersMap().getValue(lambdaType.asTypeParameter());
                            }
                            Value value = new Value(lambdaType, name);
                            return Optional.of(value);
                        }
                        throw new UnsupportedOperationException();
                    }
                    throw new UnsupportedOperationException();
                }
                ++index;
            }
        }
        return this.getParent().solveSymbolAsValue(name, typeSolver);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        for (Parameter parameter : ((LambdaExpr)this.wrappedNode).getParameters()) {
            SymbolDeclarator sb = JavaParserFactory.getSymbolDeclarator((Node)parameter, typeSolver);
            SymbolReference<ResolvedValueDeclaration> symbolReference = LambdaExprContext.solveWith(sb, name);
            if (!symbolReference.isSolved()) continue;
            return symbolReference;
        }
        return this.getParent().solveSymbol(name, typeSolver);
    }

    @Override
    public SymbolReference<ResolvedTypeDeclaration> solveType(String name, TypeSolver typeSolver) {
        return this.getParent().solveType(name, typeSolver);
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly, TypeSolver typeSolver) {
        return this.getParent().solveMethod(name, argumentsTypes, false, typeSolver);
    }

    @Override
    protected final Optional<Value> solveWithAsValue(SymbolDeclarator symbolDeclarator, String name, TypeSolver typeSolver) {
        for (ResolvedValueDeclaration decl : symbolDeclarator.getSymbolDeclarations()) {
            if (!decl.getName().equals(name)) continue;
            throw new UnsupportedOperationException();
        }
        return Optional.empty();
    }

    private int pos(MethodCallExpr callExpr, Expression param) {
        int i = 0;
        for (Expression p : callExpr.getArguments()) {
            if (p == param) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }
}

